# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetOrgInvitationResult',
    'AwaitableGetOrgInvitationResult',
    'get_org_invitation',
    'get_org_invitation_output',
]

@pulumi.output_type
class GetOrgInvitationResult:
    """
    A collection of values returned by getOrgInvitation.
    """
    def __init__(__self__, created_at=None, expires_at=None, id=None, invitation_id=None, inviter_username=None, org_id=None, roles=None, teams_ids=None, username=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if expires_at and not isinstance(expires_at, str):
            raise TypeError("Expected argument 'expires_at' to be a str")
        pulumi.set(__self__, "expires_at", expires_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if invitation_id and not isinstance(invitation_id, str):
            raise TypeError("Expected argument 'invitation_id' to be a str")
        pulumi.set(__self__, "invitation_id", invitation_id)
        if inviter_username and not isinstance(inviter_username, str):
            raise TypeError("Expected argument 'inviter_username' to be a str")
        pulumi.set(__self__, "inviter_username", inviter_username)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if roles and not isinstance(roles, list):
            raise TypeError("Expected argument 'roles' to be a list")
        pulumi.set(__self__, "roles", roles)
        if teams_ids and not isinstance(teams_ids, list):
            raise TypeError("Expected argument 'teams_ids' to be a list")
        pulumi.set(__self__, "teams_ids", teams_ids)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Timestamp in ISO 8601 date and time format in UTC when Atlas sent the invitation.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> str:
        """
        Timestamp in ISO 8601 date and time format in UTC when the invitation expires. Users have 30 days to accept an invitation.
        """
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="invitationId")
    def invitation_id(self) -> str:
        return pulumi.get(self, "invitation_id")

    @property
    @pulumi.getter(name="inviterUsername")
    def inviter_username(self) -> str:
        """
        Atlas user who invited `username` to the organization.
        """
        return pulumi.get(self, "inviter_username")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> str:
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter
    def roles(self) -> Sequence[str]:
        """
        Atlas roles to assign to the invited user. If the user accepts the invitation, Atlas assigns these roles to them. The [MongoDB Documentation](https://www.mongodb.com/docs/atlas/reference/user-roles/#organization-roles) describes the roles a user can have.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter(name="teamsIds")
    def teams_ids(self) -> Sequence[str]:
        """
        An array of unique 24-hexadecimal digit strings that identify the teams that the user was invited to join.
        """
        return pulumi.get(self, "teams_ids")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")


class AwaitableGetOrgInvitationResult(GetOrgInvitationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrgInvitationResult(
            created_at=self.created_at,
            expires_at=self.expires_at,
            id=self.id,
            invitation_id=self.invitation_id,
            inviter_username=self.inviter_username,
            org_id=self.org_id,
            roles=self.roles,
            teams_ids=self.teams_ids,
            username=self.username)


def get_org_invitation(invitation_id: Optional[str] = None,
                       org_id: Optional[str] = None,
                       username: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrgInvitationResult:
    """
    ## # Data Source: OrgInvitation

    `OrgInvitation` describes an invitation for a user to join an Atlas organization.


    :param str invitation_id: Unique 24-hexadecimal digit string that identifies the invitation in Atlas.
    :param str org_id: Unique 24-hexadecimal digit string that identifies the organization to which you invited the user.
    :param str username: Email address of the invited user. This is the address to which Atlas sends the invite. If the user accepts the invitation, they log in to Atlas with this username.
    """
    __args__ = dict()
    __args__['invitationId'] = invitation_id
    __args__['orgId'] = org_id
    __args__['username'] = username
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getOrgInvitation:getOrgInvitation', __args__, opts=opts, typ=GetOrgInvitationResult).value

    return AwaitableGetOrgInvitationResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        expires_at=pulumi.get(__ret__, 'expires_at'),
        id=pulumi.get(__ret__, 'id'),
        invitation_id=pulumi.get(__ret__, 'invitation_id'),
        inviter_username=pulumi.get(__ret__, 'inviter_username'),
        org_id=pulumi.get(__ret__, 'org_id'),
        roles=pulumi.get(__ret__, 'roles'),
        teams_ids=pulumi.get(__ret__, 'teams_ids'),
        username=pulumi.get(__ret__, 'username'))


@_utilities.lift_output_func(get_org_invitation)
def get_org_invitation_output(invitation_id: Optional[pulumi.Input[str]] = None,
                              org_id: Optional[pulumi.Input[str]] = None,
                              username: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOrgInvitationResult]:
    """
    ## # Data Source: OrgInvitation

    `OrgInvitation` describes an invitation for a user to join an Atlas organization.


    :param str invitation_id: Unique 24-hexadecimal digit string that identifies the invitation in Atlas.
    :param str org_id: Unique 24-hexadecimal digit string that identifies the organization to which you invited the user.
    :param str username: Email address of the invited user. This is the address to which Atlas sends the invite. If the user accepts the invitation, they log in to Atlas with this username.
    """
    ...
