# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetProjectIpAddressesResult',
    'AwaitableGetProjectIpAddressesResult',
    'get_project_ip_addresses',
    'get_project_ip_addresses_output',
]

@pulumi.output_type
class GetProjectIpAddressesResult:
    """
    A collection of values returned by getProjectIpAddresses.
    """
    def __init__(__self__, id=None, project_id=None, services=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if services and not isinstance(services, dict):
            raise TypeError("Expected argument 'services' to be a dict")
        pulumi.set(__self__, "services", services)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        Unique 24-hexadecimal digit string that identifies your project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def services(self) -> 'outputs.GetProjectIpAddressesServicesResult':
        """
        List of IP addresses in a project categorized by services.
        """
        return pulumi.get(self, "services")


class AwaitableGetProjectIpAddressesResult(GetProjectIpAddressesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectIpAddressesResult(
            id=self.id,
            project_id=self.project_id,
            services=self.services)


def get_project_ip_addresses(project_id: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectIpAddressesResult:
    """
    ## # Data Source: get_project_ip_addresses

    `get_project_ip_addresses` returns the IP addresses in a project categorized by services.

    ## Example Usage

    ### S
    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    test = mongodbatlas.get_project_ip_addresses(project_id=project_id)
    pulumi.export("projectServices", test.services)
    ```


    :param str project_id: Unique 24-hexadecimal digit string that identifies your project.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getProjectIpAddresses:getProjectIpAddresses', __args__, opts=opts, typ=GetProjectIpAddressesResult).value

    return AwaitableGetProjectIpAddressesResult(
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        services=pulumi.get(__ret__, 'services'))


@_utilities.lift_output_func(get_project_ip_addresses)
def get_project_ip_addresses_output(project_id: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProjectIpAddressesResult]:
    """
    ## # Data Source: get_project_ip_addresses

    `get_project_ip_addresses` returns the IP addresses in a project categorized by services.

    ## Example Usage

    ### S
    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    test = mongodbatlas.get_project_ip_addresses(project_id=project_id)
    pulumi.export("projectServices", test.services)
    ```


    :param str project_id: Unique 24-hexadecimal digit string that identifies your project.
    """
    ...
