# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetProjectsResult',
    'AwaitableGetProjectsResult',
    'get_projects',
    'get_projects_output',
]

@pulumi.output_type
class GetProjectsResult:
    """
    A collection of values returned by getProjects.
    """
    def __init__(__self__, id=None, items_per_page=None, page_num=None, results=None, total_count=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items_per_page and not isinstance(items_per_page, int):
            raise TypeError("Expected argument 'items_per_page' to be a int")
        pulumi.set(__self__, "items_per_page", items_per_page)
        if page_num and not isinstance(page_num, int):
            raise TypeError("Expected argument 'page_num' to be a int")
        pulumi.set(__self__, "page_num", page_num)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter
    @_utilities.deprecated("""Please use each project's id attribute instead""")
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="itemsPerPage")
    def items_per_page(self) -> Optional[int]:
        return pulumi.get(self, "items_per_page")

    @property
    @pulumi.getter(name="pageNum")
    def page_num(self) -> Optional[int]:
        return pulumi.get(self, "page_num")

    @property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetProjectsResultResult']:
        return pulumi.get(self, "results")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        return pulumi.get(self, "total_count")


class AwaitableGetProjectsResult(GetProjectsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectsResult(
            id=self.id,
            items_per_page=self.items_per_page,
            page_num=self.page_num,
            results=self.results,
            total_count=self.total_count)


def get_projects(items_per_page: Optional[int] = None,
                 page_num: Optional[int] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectsResult:
    """
    ## # Data Source: get_projects

    `get_projects` describes all Projects. This represents projects that have been created.

    > **NOTE:** Groups and projects are synonymous terms. You may find `groupId` in the official documentation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    test = mongodbatlas.get_roles_org_id()
    test_project = mongodbatlas.Project("test",
        name="project-name",
        org_id=test.org_id,
        teams=[
            {
                "team_id": "5e0fa8c99ccf641c722fe645",
                "role_names": ["GROUP_OWNER"],
            },
            {
                "team_id": "5e1dd7b4f2a30ba80a70cd4rw",
                "role_names": [
                    "GROUP_READ_ONLY",
                    "GROUP_DATA_ACCESS_READ_WRITE",
                ],
            },
        ],
        limits=[{
            "name": "atlas.project.deployment.clusters",
            "value": 26,
        }])
    test_get_projects = mongodbatlas.get_projects(page_num=1,
        items_per_page=5)
    ```


    :param int items_per_page: Number of items to return per page, up to a maximum of 500. Defaults to `100`.
    :param int page_num: The page to return. Defaults to `1`.
    """
    __args__ = dict()
    __args__['itemsPerPage'] = items_per_page
    __args__['pageNum'] = page_num
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getProjects:getProjects', __args__, opts=opts, typ=GetProjectsResult).value

    return AwaitableGetProjectsResult(
        id=pulumi.get(__ret__, 'id'),
        items_per_page=pulumi.get(__ret__, 'items_per_page'),
        page_num=pulumi.get(__ret__, 'page_num'),
        results=pulumi.get(__ret__, 'results'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(get_projects)
def get_projects_output(items_per_page: Optional[pulumi.Input[Optional[int]]] = None,
                        page_num: Optional[pulumi.Input[Optional[int]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProjectsResult]:
    """
    ## # Data Source: get_projects

    `get_projects` describes all Projects. This represents projects that have been created.

    > **NOTE:** Groups and projects are synonymous terms. You may find `groupId` in the official documentation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    test = mongodbatlas.get_roles_org_id()
    test_project = mongodbatlas.Project("test",
        name="project-name",
        org_id=test.org_id,
        teams=[
            {
                "team_id": "5e0fa8c99ccf641c722fe645",
                "role_names": ["GROUP_OWNER"],
            },
            {
                "team_id": "5e1dd7b4f2a30ba80a70cd4rw",
                "role_names": [
                    "GROUP_READ_ONLY",
                    "GROUP_DATA_ACCESS_READ_WRITE",
                ],
            },
        ],
        limits=[{
            "name": "atlas.project.deployment.clusters",
            "value": 26,
        }])
    test_get_projects = mongodbatlas.get_projects(page_num=1,
        items_per_page=5)
    ```


    :param int items_per_page: Number of items to return per page, up to a maximum of 500. Defaults to `100`.
    :param int page_num: The page to return. Defaults to `1`.
    """
    ...
