# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['MongodbEmployeeAccessGrantArgs', 'MongodbEmployeeAccessGrant']

@pulumi.input_type
class MongodbEmployeeAccessGrantArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[str],
                 expiration_time: pulumi.Input[str],
                 grant_type: pulumi.Input[str],
                 project_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a MongodbEmployeeAccessGrant resource.
        :param pulumi.Input[str] cluster_name: Human-readable label that identifies this cluster.
        :param pulumi.Input[str] expiration_time: Expiration date for the employee access grant.
        :param pulumi.Input[str] grant_type: Level of access to grant to MongoDB Employees. Possible values are CLUSTER*DATABASE*LOGS, CLUSTER*INFRASTRUCTURE or CLUSTER*INFRASTRUCTURE*AND*APP*SERVICES*SYNC_DATA.
        :param pulumi.Input[str] project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "grant_type", grant_type)
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[str]:
        """
        Human-readable label that identifies this cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> pulumi.Input[str]:
        """
        Expiration date for the employee access grant.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter(name="grantType")
    def grant_type(self) -> pulumi.Input[str]:
        """
        Level of access to grant to MongoDB Employees. Possible values are CLUSTER*DATABASE*LOGS, CLUSTER*INFRASTRUCTURE or CLUSTER*INFRASTRUCTURE*AND*APP*SERVICES*SYNC_DATA.
        """
        return pulumi.get(self, "grant_type")

    @grant_type.setter
    def grant_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "grant_type", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class _MongodbEmployeeAccessGrantState:
    def __init__(__self__, *,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 expiration_time: Optional[pulumi.Input[str]] = None,
                 grant_type: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MongodbEmployeeAccessGrant resources.
        :param pulumi.Input[str] cluster_name: Human-readable label that identifies this cluster.
        :param pulumi.Input[str] expiration_time: Expiration date for the employee access grant.
        :param pulumi.Input[str] grant_type: Level of access to grant to MongoDB Employees. Possible values are CLUSTER*DATABASE*LOGS, CLUSTER*INFRASTRUCTURE or CLUSTER*INFRASTRUCTURE*AND*APP*SERVICES*SYNC_DATA.
        :param pulumi.Input[str] project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        """
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if grant_type is not None:
            pulumi.set(__self__, "grant_type", grant_type)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable label that identifies this cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[str]]:
        """
        Expiration date for the employee access grant.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter(name="grantType")
    def grant_type(self) -> Optional[pulumi.Input[str]]:
        """
        Level of access to grant to MongoDB Employees. Possible values are CLUSTER*DATABASE*LOGS, CLUSTER*INFRASTRUCTURE or CLUSTER*INFRASTRUCTURE*AND*APP*SERVICES*SYNC_DATA.
        """
        return pulumi.get(self, "grant_type")

    @grant_type.setter
    def grant_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "grant_type", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)


class MongodbEmployeeAccessGrant(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 expiration_time: Optional[pulumi.Input[str]] = None,
                 grant_type: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # Resource: MongodbEmployeeAccessGrant

        `MongodbEmployeeAccessGrant` provides a MongoDB Employee Access Grant resource. The resource lets you create, delete, update and import a MongoDB employee access grant.

        ## Example Usage

        ### S

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        example = mongodbatlas.MongodbEmployeeAccessGrant("example",
            project_id=project_id,
            cluster_name=cluster_name,
            grant_type="CLUSTER_INFRASTRUCTURE_AND_APP_SERVICES_SYNC_DATA",
            expiration_time="2025-01-01T12:00:00Z")
        ds_example = mongodbatlas.get_mongodb_employee_access_grant(project_id=project_id,
            cluster_name=cluster_name)
        pulumi.export("grantType", ds_example.grant_type)
        pulumi.export("expirationTime", ds_example.expiration_time)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_name: Human-readable label that identifies this cluster.
        :param pulumi.Input[str] expiration_time: Expiration date for the employee access grant.
        :param pulumi.Input[str] grant_type: Level of access to grant to MongoDB Employees. Possible values are CLUSTER*DATABASE*LOGS, CLUSTER*INFRASTRUCTURE or CLUSTER*INFRASTRUCTURE*AND*APP*SERVICES*SYNC_DATA.
        :param pulumi.Input[str] project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MongodbEmployeeAccessGrantArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: MongodbEmployeeAccessGrant

        `MongodbEmployeeAccessGrant` provides a MongoDB Employee Access Grant resource. The resource lets you create, delete, update and import a MongoDB employee access grant.

        ## Example Usage

        ### S

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        example = mongodbatlas.MongodbEmployeeAccessGrant("example",
            project_id=project_id,
            cluster_name=cluster_name,
            grant_type="CLUSTER_INFRASTRUCTURE_AND_APP_SERVICES_SYNC_DATA",
            expiration_time="2025-01-01T12:00:00Z")
        ds_example = mongodbatlas.get_mongodb_employee_access_grant(project_id=project_id,
            cluster_name=cluster_name)
        pulumi.export("grantType", ds_example.grant_type)
        pulumi.export("expirationTime", ds_example.expiration_time)
        ```

        :param str resource_name: The name of the resource.
        :param MongodbEmployeeAccessGrantArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MongodbEmployeeAccessGrantArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 expiration_time: Optional[pulumi.Input[str]] = None,
                 grant_type: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MongodbEmployeeAccessGrantArgs.__new__(MongodbEmployeeAccessGrantArgs)

            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            if expiration_time is None and not opts.urn:
                raise TypeError("Missing required property 'expiration_time'")
            __props__.__dict__["expiration_time"] = expiration_time
            if grant_type is None and not opts.urn:
                raise TypeError("Missing required property 'grant_type'")
            __props__.__dict__["grant_type"] = grant_type
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
        super(MongodbEmployeeAccessGrant, __self__).__init__(
            'mongodbatlas:index/mongodbEmployeeAccessGrant:MongodbEmployeeAccessGrant',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_name: Optional[pulumi.Input[str]] = None,
            expiration_time: Optional[pulumi.Input[str]] = None,
            grant_type: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None) -> 'MongodbEmployeeAccessGrant':
        """
        Get an existing MongodbEmployeeAccessGrant resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_name: Human-readable label that identifies this cluster.
        :param pulumi.Input[str] expiration_time: Expiration date for the employee access grant.
        :param pulumi.Input[str] grant_type: Level of access to grant to MongoDB Employees. Possible values are CLUSTER*DATABASE*LOGS, CLUSTER*INFRASTRUCTURE or CLUSTER*INFRASTRUCTURE*AND*APP*SERVICES*SYNC_DATA.
        :param pulumi.Input[str] project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MongodbEmployeeAccessGrantState.__new__(_MongodbEmployeeAccessGrantState)

        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["expiration_time"] = expiration_time
        __props__.__dict__["grant_type"] = grant_type
        __props__.__dict__["project_id"] = project_id
        return MongodbEmployeeAccessGrant(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[str]:
        """
        Human-readable label that identifies this cluster.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> pulumi.Output[str]:
        """
        Expiration date for the employee access grant.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="grantType")
    def grant_type(self) -> pulumi.Output[str]:
        """
        Level of access to grant to MongoDB Employees. Possible values are CLUSTER*DATABASE*LOGS, CLUSTER*INFRASTRUCTURE or CLUSTER*INFRASTRUCTURE*AND*APP*SERVICES*SYNC_DATA.
        """
        return pulumi.get(self, "grant_type")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        """
        return pulumi.get(self, "project_id")

