# Generated by Django 4.1.9 on 2023-06-28 12:21

from decimal import Decimal

import django.db.models.deletion
import wbcommission.models.rebate
from django.contrib.postgres.operations import BtreeGistExtension
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("wbcrm", "0005_account_accountrole_accountroletype_and_more"),
        ("wbportfolio", "0046_add_product_default_account"),
        ("directory", "0004_entry_is_draft_entry"),
    ]

    operations = [
        BtreeGistExtension(),
        migrations.CreateModel(
            name="AccountCustomer",
            fields=[
                (
                    "id",
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID"),
                ),
                (
                    "customer_type",
                    models.CharField(
                        choices=[("DIRECT", "Direct"), ("INDIRECT", "Indirect")],
                        default="DIRECT",
                        max_length=16,
                        verbose_name="Customer Type",
                    ),
                ),
                (
                    "account",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="customers",
                        to="wbcrm.account",
                        verbose_name="Account",
                    ),
                ),
                (
                    "entry",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="account_customers",
                        to="directory.entry",
                        verbose_name="Customer",
                    ),
                ),
            ],
            options={
                "verbose_name": "Customer",
                "verbose_name_plural": "Customers",
                "notification_types": [
                    (
                        "wbcommission.accountcustomer.notify",
                        "New Account Customer Notification",
                        "Notifies you when a new account customer has been created",
                        True,
                        True,
                        False,
                    )
                ],
            },
        ),
        migrations.CreateModel(
            name="CommissionAccountRole",
            fields=[
                (
                    "id",
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID"),
                ),
                (
                    "role_type",
                    models.CharField(
                        choices=[("SALES", "Sales"), ("CUSTOMER_MANAGER", "Customer Manager")],
                        default="SALES",
                        max_length=16,
                        verbose_name="Role Type",
                    ),
                ),
                ("start", models.DateField(blank=True, null=True, verbose_name="Start")),
                ("end", models.DateField(blank=True, null=True, verbose_name="End")),
                ("weighting", models.FloatField(default=1, verbose_name="Weight")),
                (
                    "account",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="rebates_roles",
                        to="wbcrm.account",
                        verbose_name="Account Rebate roles",
                    ),
                ),
                (
                    "customer",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="rebate_account_customer",
                        to="directory.entry",
                        verbose_name="Customer",
                    ),
                ),
                (
                    "person",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="rebates_account_roles",
                        to="directory.person",
                        verbose_name="Person",
                    ),
                ),
            ],
            options={
                "verbose_name": "Commission Account Role",
                "verbose_name_plural": "Commission Account Roles",
            },
        ),
        migrations.CreateModel(
            name="AccountCustomerCommissionConstraint",
            fields=[
                (
                    "id",
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID"),
                ),
                ("start_year", models.PositiveIntegerField(blank=True, null=True)),
                ("end_year", models.PositiveIntegerField(blank=True, null=True)),
                ("payable_year_end", models.BooleanField(default=True)),
                ("payable_continous", models.BooleanField(default=True)),
                (
                    "customer",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="constraints",
                        to="wbcommission.accountcustomer",
                    ),
                ),
                (
                    "products",
                    models.ManyToManyField(blank=True, related_name="customer_constraints", to="wbportfolio.product"),
                ),
            ],
            options={
                "verbose_name": "Account Customer Commission Constraint",
                "verbose_name_plural": "Account Customer Commission Constrains",
            },
        ),
        migrations.CreateModel(
            name="Rebate",
            fields=[
                (
                    "id",
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID"),
                ),
                ("date", models.DateField(verbose_name="Date")),
                (
                    "management_fees",
                    models.DecimalField(
                        decimal_places=4, default=Decimal(0.0), max_digits=16, verbose_name="Management Fees"
                    ),
                ),
                (
                    "pre_performance_fees",
                    models.DecimalField(
                        decimal_places=4,
                        default=Decimal(0.0),
                        max_digits=16,
                        verbose_name="Pre Performance Fees",
                    ),
                ),
                (
                    "performance_fees",
                    models.DecimalField(
                        decimal_places=4, default=Decimal(0.0), max_digits=16, verbose_name="Performance Fees"
                    ),
                ),
                (
                    "account",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="rebates",
                        to="wbcrm.account",
                        verbose_name="Account",
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="rebates",
                        to="wbportfolio.product",
                        verbose_name="Product",
                    ),
                ),
                (
                    "recipient",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="recipient_rebates",
                        to="directory.entry",
                        verbose_name="Recipient",
                    ),
                ),
            ],
            options={
                "verbose_name": "Rebate",
                "verbose_name_plural": "Rebates",
                "unique_together": {("date", "recipient", "account", "product")},
                "index_together": {("date", "recipient", "product")},
            },
            bases=(wbcommission.models.rebate.BookingEntryCalculatedValueMixin, models.Model),
        ),
        migrations.CreateModel(
            name="Commission",
            fields=[
                (
                    "id",
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID"),
                ),
                (
                    "role_recipient",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("portfolio_managers", "Portfolio Managers"),
                            ("analysts", "Analysts"),
                            ("sales", "Sales"),
                            ("customer_managers", "Customer Managers"),
                        ],
                        max_length=32,
                        null=True,
                        verbose_name="Recipient Role",
                    ),
                ),
                ("order", models.IntegerField()),
                (
                    "commission_type",
                    models.CharField(
                        choices=[
                            ("net_management_fees", "Net Management Fees"),
                            ("gross_management_fees", "Gross Management Fees"),
                            ("net_performance_fees", "Net Performance Fees"),
                            ("gross_performance_fees", "Gross Performance Fees"),
                        ],
                        default="net_management_fees",
                        max_length=32,
                        verbose_name="Type",
                    ),
                ),
                ("start_date", models.DateField(verbose_name="Start Date")),
                (
                    "minimum_assets_under_management",
                    models.IntegerField(default=0, verbose_name="Minimum AUM"),
                ),
                ("percent", models.FloatField(verbose_name="Percent")),
                (
                    "account",
                    models.ForeignKey(
                        limit_choices_to=models.Q(("is_terminal_account", True)),
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="account_commissions",
                        to="wbcrm.account",
                        verbose_name="Account",
                    ),
                ),
                (
                    "crm_recipient",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="recipient_commissions",
                        to="directory.entry",
                        verbose_name="Recipient",
                    ),
                ),
            ],
            options={
                "verbose_name": "Commission",
                "verbose_name_plural": "Commissions",
                "unique_together": {
                    (
                        "account",
                        "order",
                        "crm_recipient",
                        "role_recipient",
                        "start_date",
                        "commission_type",
                        "minimum_assets_under_management",
                    )
                },
            },
        ),
    ]
