"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import pydantic
from pydantic.functional_validators import AfterValidator
from ragie.types import BaseModel
from ragie.utils import validate_const
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CodeStepTypedDict(TypedDict):
    think: str
    current_question: str
    code_issue: str
    r"""The natural language description of the code issue you need to solve."""
    type: Literal["code"]
    code: NotRequired[str]
    r"""The code you generated to solve the code issue."""
    code_result: NotRequired[str]
    r"""The result of the code you generated after executing it."""


class CodeStep(BaseModel):
    think: str

    current_question: str

    code_issue: str
    r"""The natural language description of the code issue you need to solve."""

    TYPE: Annotated[
        Annotated[Optional[Literal["code"]], AfterValidator(validate_const("code"))],
        pydantic.Field(alias="type"),
    ] = "code"

    code: Optional[str] = ""
    r"""The code you generated to solve the code issue."""

    code_result: Optional[str] = ""
    r"""The result of the code you generated after executing it."""
