"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from enum import Enum
from pydantic import model_serializer
from ragie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from typing import Any, Dict, List, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


ConnectionMetadataTypedDict = TypeAliasType(
    "ConnectionMetadataTypedDict", Union[str, int, bool, List[str]]
)


ConnectionMetadata = TypeAliasType(
    "ConnectionMetadata", Union[str, int, bool, List[str]]
)


SourceTypedDict = TypeAliasType(
    "SourceTypedDict", Union[str, List[str], Dict[str, Any]]
)


Source = TypeAliasType("Source", Union[str, List[str], Dict[str, Any]])


class DisabledBySystemReason(str, Enum):
    CONNECTION_OVER_TOTAL_PAGE_LIMIT = "connection_over_total_page_limit"
    AUTHENTICATION_FAILED = "authentication_failed"


class ConnectionTypedDict(TypedDict):
    id: str
    created_at: datetime
    updated_at: datetime
    metadata: Dict[str, ConnectionMetadataTypedDict]
    type: str
    name: str
    source: Nullable[SourceTypedDict]
    enabled: bool
    disabled_by_system_reason: Nullable[DisabledBySystemReason]
    page_limit: Nullable[int]
    disabled_by_system: bool
    last_synced_at: NotRequired[Nullable[datetime]]
    syncing: NotRequired[Nullable[bool]]
    partition: NotRequired[Nullable[str]]


class Connection(BaseModel):
    id: str

    created_at: datetime

    updated_at: datetime

    metadata: Dict[str, ConnectionMetadata]

    type: str

    name: str

    source: Nullable[Source]

    enabled: bool

    disabled_by_system_reason: Nullable[DisabledBySystemReason]

    page_limit: Nullable[int]

    disabled_by_system: bool

    last_synced_at: OptionalNullable[datetime] = UNSET

    syncing: OptionalNullable[bool] = UNSET

    partition: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["last_synced_at", "syncing", "partition"]
        nullable_fields = [
            "source",
            "disabled_by_system_reason",
            "last_synced_at",
            "syncing",
            "partition",
            "page_limit",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
