"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from pydantic import model_serializer
from ragie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from typing import Any, Dict, List, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


MetadataSchemaTypedDict = TypeAliasType(
    "MetadataSchemaTypedDict", Union[str, int, bool, List[str], Dict[str, Any]]
)


MetadataSchema = TypeAliasType(
    "MetadataSchema", Union[str, int, bool, List[str], Dict[str, Any]]
)


class CreatePartitionParamsTypedDict(TypedDict):
    name: str
    pages_hosted_limit_monthly: NotRequired[Nullable[int]]
    r"""Monthly limit of hosted pages added in the current month in the partition."""
    pages_processed_limit_monthly: NotRequired[Nullable[int]]
    r"""Monthly limit, in pages, for processed documents in the partition."""
    pages_hosted_limit_max: NotRequired[Nullable[int]]
    r"""Maximum limit, in pages, for hosted documents in the partition."""
    pages_processed_limit_max: NotRequired[Nullable[int]]
    r"""Maximum limit, in pages, for processed documents in the partition."""
    audio_processed_limit_monthly: NotRequired[Nullable[int]]
    r"""Monthly limit, in minutes, for audio processing in the partition."""
    audio_processed_limit_max: NotRequired[Nullable[int]]
    r"""Maximum limit, in minutes, for audio processing in the partition."""
    video_processed_limit_monthly: NotRequired[Nullable[int]]
    r"""Monthly limit, in minutes, for video processing in the partition."""
    video_processed_limit_max: NotRequired[Nullable[int]]
    r"""Maximum limit, in minutes, for video processing in the partition."""
    media_streamed_limit_monthly: NotRequired[Nullable[int]]
    r"""Monthly limit, in MBs, for media streamed from the partition."""
    media_streamed_limit_max: NotRequired[Nullable[int]]
    r"""Maximum limit, in MBs, for media streamed from the partition."""
    media_hosted_limit_monthly: NotRequired[Nullable[int]]
    r"""Monthly limit, in MBs, for media hosted in the partition."""
    media_hosted_limit_max: NotRequired[Nullable[int]]
    r"""Maximum limit, in MBs, for media hosted in the partition."""
    metadata_schema: NotRequired[Nullable[Dict[str, MetadataSchemaTypedDict]]]
    r"""Metadata schema for the partition."""


class CreatePartitionParams(BaseModel):
    name: str

    pages_hosted_limit_monthly: OptionalNullable[int] = UNSET
    r"""Monthly limit of hosted pages added in the current month in the partition."""

    pages_processed_limit_monthly: OptionalNullable[int] = UNSET
    r"""Monthly limit, in pages, for processed documents in the partition."""

    pages_hosted_limit_max: OptionalNullable[int] = UNSET
    r"""Maximum limit, in pages, for hosted documents in the partition."""

    pages_processed_limit_max: OptionalNullable[int] = UNSET
    r"""Maximum limit, in pages, for processed documents in the partition."""

    audio_processed_limit_monthly: OptionalNullable[int] = UNSET
    r"""Monthly limit, in minutes, for audio processing in the partition."""

    audio_processed_limit_max: OptionalNullable[int] = UNSET
    r"""Maximum limit, in minutes, for audio processing in the partition."""

    video_processed_limit_monthly: OptionalNullable[int] = UNSET
    r"""Monthly limit, in minutes, for video processing in the partition."""

    video_processed_limit_max: OptionalNullable[int] = UNSET
    r"""Maximum limit, in minutes, for video processing in the partition."""

    media_streamed_limit_monthly: OptionalNullable[int] = UNSET
    r"""Monthly limit, in MBs, for media streamed from the partition."""

    media_streamed_limit_max: OptionalNullable[int] = UNSET
    r"""Maximum limit, in MBs, for media streamed from the partition."""

    media_hosted_limit_monthly: OptionalNullable[int] = UNSET
    r"""Monthly limit, in MBs, for media hosted in the partition."""

    media_hosted_limit_max: OptionalNullable[int] = UNSET
    r"""Maximum limit, in MBs, for media hosted in the partition."""

    metadata_schema: OptionalNullable[Dict[str, MetadataSchema]] = UNSET
    r"""Metadata schema for the partition."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "pages_hosted_limit_monthly",
            "pages_processed_limit_monthly",
            "pages_hosted_limit_max",
            "pages_processed_limit_max",
            "audio_processed_limit_monthly",
            "audio_processed_limit_max",
            "video_processed_limit_monthly",
            "video_processed_limit_max",
            "media_streamed_limit_monthly",
            "media_streamed_limit_max",
            "media_hosted_limit_monthly",
            "media_hosted_limit_max",
            "metadata_schema",
        ]
        nullable_fields = [
            "pages_hosted_limit_monthly",
            "pages_processed_limit_monthly",
            "pages_hosted_limit_max",
            "pages_processed_limit_max",
            "audio_processed_limit_monthly",
            "audio_processed_limit_max",
            "video_processed_limit_monthly",
            "video_processed_limit_max",
            "media_streamed_limit_monthly",
            "media_streamed_limit_max",
            "media_hosted_limit_monthly",
            "media_hosted_limit_max",
            "metadata_schema",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
