"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .audiomodalitydata import AudioModalityData, AudioModalityDataTypedDict
from .link import Link, LinkTypedDict
from .videomodalitydata import VideoModalityData, VideoModalityDataTypedDict
from pydantic import Discriminator, Tag, model_serializer
from ragie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from ragie.utils import get_discriminator
from typing import Any, Dict, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


ModalityDataTypedDict = TypeAliasType(
    "ModalityDataTypedDict",
    Union[AudioModalityDataTypedDict, VideoModalityDataTypedDict],
)


ModalityData = Annotated[
    Union[
        Annotated[AudioModalityData, Tag("audio")],
        Annotated[VideoModalityData, Tag("video")],
    ],
    Discriminator(lambda m: get_discriminator(m, "type", "type")),
]


class DocumentChunkDetailTypedDict(TypedDict):
    id: str
    text: str
    links: Dict[str, LinkTypedDict]
    index: NotRequired[int]
    metadata: NotRequired[Dict[str, Any]]
    modality_data: NotRequired[Nullable[ModalityDataTypedDict]]
    r"""Additional data specific to the modality of the chunk's source file, such as word level timestamps for chunks extracted from audio files."""


class DocumentChunkDetail(BaseModel):
    id: str

    text: str

    links: Dict[str, Link]

    index: Optional[int] = -1

    metadata: Optional[Dict[str, Any]] = None

    modality_data: OptionalNullable[ModalityData] = UNSET
    r"""Additional data specific to the modality of the chunk's source file, such as word level timestamps for chunks extracted from audio files."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["index", "metadata", "modality_data"]
        nullable_fields = ["modality_data"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
