"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from pydantic import model_serializer
from ragie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from typing import Any, Dict
from typing_extensions import NotRequired, TypedDict


class EntityTypedDict(TypedDict):
    id: str
    created_at: datetime
    updated_at: datetime
    instruction_id: str
    r"""The ID of the instruction which generated the entity."""
    document_id: str
    r"""The ID of the document which the entity was produced from."""
    data: Dict[str, Any]
    chunk_id: NotRequired[Nullable[str]]


class Entity(BaseModel):
    id: str

    created_at: datetime

    updated_at: datetime

    instruction_id: str
    r"""The ID of the instruction which generated the entity."""

    document_id: str
    r"""The ID of the document which the entity was produced from."""

    data: Dict[str, Any]

    chunk_id: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["chunk_id"]
        nullable_fields = ["chunk_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
