"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .answer import Answer, AnswerTypedDict
import pydantic
from pydantic.functional_validators import AfterValidator
from ragie.types import BaseModel
from ragie.utils import validate_const
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EvaluatedAnswerStepTypedDict(TypedDict):
    think: str
    current_question: str
    answer: AnswerTypedDict
    eval_passed: bool
    eval_reason: str
    type: Literal["evaluated_answer"]
    other_resolved_question_ids: NotRequired[List[str]]
    r"""A list of questions ids that are no longer relevant to the current answer referenced by their IDs."""


class EvaluatedAnswerStep(BaseModel):
    think: str

    current_question: str

    answer: Answer

    eval_passed: bool

    eval_reason: str

    TYPE: Annotated[
        Annotated[
            Optional[Literal["evaluated_answer"]],
            AfterValidator(validate_const("evaluated_answer")),
        ],
        pydantic.Field(alias="type"),
    ] = "evaluated_answer"

    other_resolved_question_ids: Optional[List[str]] = None
    r"""A list of questions ids that are no longer relevant to the current answer referenced by their IDs."""
