"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from pydantic import model_serializer
from ragie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from ragie.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class MediaType(str, Enum):
    r"""The desired media type of the content to return described as a mime type. An error will be returned if the requested media type is not supported for the chunk's document type."""

    TEXT_PLAIN = "text/plain"
    AUDIO_MPEG = "audio/mpeg"
    VIDEO_MP4 = "video/mp4"
    IMAGE_WEBP = "image/webp"
    IMAGE_HEIC = "image/heic"
    IMAGE_BMP = "image/bmp"
    IMAGE_PNG = "image/png"
    IMAGE_JPEG = "image/jpeg"
    IMAGE_TIFF = "image/tiff"


class GetDocumentChunkContentRequestTypedDict(TypedDict):
    document_id: str
    r"""The id of the document."""
    chunk_id: str
    r"""The ID of the chunk."""
    media_type: NotRequired[Nullable[MediaType]]
    r"""The desired media type of the content to return described as a mime type. An error will be returned if the requested media type is not supported for the chunk's document type."""
    download: NotRequired[bool]
    r"""Whether to return the content as a file download or a raw stream. If set to `true`, the content will be returned as a named file for download."""
    partition: NotRequired[Nullable[str]]
    r"""An optional partition to scope the request to. If omitted, accounts created after 1/9/2025 will have the request scoped to the default partition, while older accounts will have the request scoped to all partitions. Older accounts may opt in to strict partition scoping by contacting support@ragie.ai. Older accounts using the partitions feature are strongly recommended to scope the request to a partition."""
    range: NotRequired[Nullable[str]]


class GetDocumentChunkContentRequest(BaseModel):
    document_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The id of the document."""

    chunk_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The ID of the chunk."""

    media_type: Annotated[
        OptionalNullable[MediaType],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The desired media type of the content to return described as a mime type. An error will be returned if the requested media type is not supported for the chunk's document type."""

    download: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = False
    r"""Whether to return the content as a file download or a raw stream. If set to `true`, the content will be returned as a named file for download."""

    partition: Annotated[
        OptionalNullable[str],
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = UNSET
    r"""An optional partition to scope the request to. If omitted, accounts created after 1/9/2025 will have the request scoped to the default partition, while older accounts will have the request scoped to all partitions. Older accounts may opt in to strict partition scoping by contacting support@ragie.ai. Older accounts using the partitions feature are strongly recommended to scope the request to a partition."""

    range: Annotated[
        OptionalNullable[str],
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["media_type", "download", "partition", "range"]
        nullable_fields = ["media_type", "partition", "range"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
