"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from pydantic import model_serializer
from ragie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from typing_extensions import NotRequired, TypedDict


class Provider(str, Enum):
    ATLASSIAN = "atlassian"
    DROPBOX = "dropbox"
    MICROSOFT = "microsoft"
    SALESFORCE = "salesforce"
    SLACK = "slack"
    HUBSPOT = "hubspot"


class OAuthCredentialsTypedDict(TypedDict):
    provider: Provider
    name: str
    r"""The unique name of your authenticator, used to identify it and distinguish it from others. This name must be unique. Attempting to reuse the same name will result in an error."""
    client_id: str
    client_secret: str
    domain: NotRequired[Nullable[str]]


class OAuthCredentials(BaseModel):
    provider: Provider

    name: str
    r"""The unique name of your authenticator, used to identify it and distinguish it from others. This name must be unique. Attempting to reuse the same name will result in an error."""

    client_id: str

    client_secret: str

    domain: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["domain"]
        nullable_fields = ["domain"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
