"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .connectorsource import ConnectorSource
from .mediamodeparam import MediaModeParam, MediaModeParamTypedDict
from enum import Enum
from pydantic import model_serializer
from ragie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from typing import Any, Dict, List, Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


OAuthURLCreateMetadataTypedDict = TypeAliasType(
    "OAuthURLCreateMetadataTypedDict", Union[str, int, bool, List[str]]
)


OAuthURLCreateMetadata = TypeAliasType(
    "OAuthURLCreateMetadata", Union[str, int, bool, List[str]]
)


class OAuthURLCreateMode1(str, Enum):
    HI_RES = "hi_res"
    FAST = "fast"


OAuthURLCreateModeTypedDict = TypeAliasType(
    "OAuthURLCreateModeTypedDict", Union[MediaModeParamTypedDict, OAuthURLCreateMode1]
)


OAuthURLCreateMode = TypeAliasType(
    "OAuthURLCreateMode", Union[MediaModeParam, OAuthURLCreateMode1]
)


class Theme(str, Enum):
    LIGHT = "light"
    DARK = "dark"
    SYSTEM = "system"


class OAuthURLCreateTypedDict(TypedDict):
    redirect_uri: str
    partition: NotRequired[Nullable[str]]
    source_type: NotRequired[ConnectorSource]
    metadata: NotRequired[Dict[str, OAuthURLCreateMetadataTypedDict]]
    r"""Metadata for the document. Keys must be strings. Values may be strings, numbers, booleans, or lists of strings. Numbers may be integers or floating point and will be converted to 64 bit floating point. 1000 total values are allowed. Each item in an array counts towards the total. The following keys are reserved for internal use: `document_id`, `document_type`, `document_source`, `document_name`, `document_uploaded_at`, `start_time`, `end_time`."""
    mode: NotRequired[Nullable[OAuthURLCreateModeTypedDict]]
    theme: NotRequired[Nullable[Theme]]
    r"""Sets the theme of the Ragie Web UI when the user lands there. Can be light, dark, or system to use whatever the system value is. If omitted, system is used."""
    page_limit: NotRequired[Nullable[int]]
    r"""The maximum number of pages a connection will sync. The connection will be disabled after this limit is reached. Some in progress documents may continue processing after the limit is reached. The limit will be enforced at the start of the next document sync. Remove the limit by setting to null."""
    config: NotRequired[Dict[str, Any]]
    r"""Optional config per connector"""
    authenticator_id: NotRequired[Nullable[str]]


class OAuthURLCreate(BaseModel):
    redirect_uri: str

    partition: OptionalNullable[str] = UNSET

    source_type: Optional[ConnectorSource] = None

    metadata: Optional[Dict[str, OAuthURLCreateMetadata]] = None
    r"""Metadata for the document. Keys must be strings. Values may be strings, numbers, booleans, or lists of strings. Numbers may be integers or floating point and will be converted to 64 bit floating point. 1000 total values are allowed. Each item in an array counts towards the total. The following keys are reserved for internal use: `document_id`, `document_type`, `document_source`, `document_name`, `document_uploaded_at`, `start_time`, `end_time`."""

    mode: OptionalNullable[OAuthURLCreateMode] = UNSET

    theme: OptionalNullable[Theme] = UNSET
    r"""Sets the theme of the Ragie Web UI when the user lands there. Can be light, dark, or system to use whatever the system value is. If omitted, system is used."""

    page_limit: OptionalNullable[int] = UNSET
    r"""The maximum number of pages a connection will sync. The connection will be disabled after this limit is reached. Some in progress documents may continue processing after the limit is reached. The limit will be enforced at the start of the next document sync. Remove the limit by setting to null."""

    config: Optional[Dict[str, Any]] = None
    r"""Optional config per connector"""

    authenticator_id: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "partition",
            "source_type",
            "metadata",
            "mode",
            "theme",
            "page_limit",
            "config",
            "authenticator_id",
        ]
        nullable_fields = [
            "partition",
            "mode",
            "theme",
            "page_limit",
            "authenticator_id",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
