"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import pydantic
from ragie.types import BaseModel
from typing import Any, Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PatchDocumentMetadataParamsTypedDict(TypedDict):
    metadata: Dict[str, Any]
    r"""The metadata to update on the document. Performs a partial update of the document's metadata. Keys must be strings. Values may be strings, numbers, booleans, or lists of strings. Numbers may be integers or floating point and will be converted to 64 bit floating point. Keys set to `null` are deleted. 1000 total values are allowed, inclusive of existing metadata. Each item in an array counts towards the total. The following keys are reserved for internal use: `document_id`, `document_type`, `document_source`, `document_name`, `document_uploaded_at`. If the document is managed by a connection, this operation will extend a metadata overlay which is applied to the document any time the connection syncs the document."""
    async_: NotRequired[bool]
    r"""Whether to run the metadata update asynchronously. If true, the metadata update will be run in the background and the response will be 202. If false, the metadata update will be run synchronously and the response will be 200."""


class PatchDocumentMetadataParams(BaseModel):
    metadata: Dict[str, Any]
    r"""The metadata to update on the document. Performs a partial update of the document's metadata. Keys must be strings. Values may be strings, numbers, booleans, or lists of strings. Numbers may be integers or floating point and will be converted to 64 bit floating point. Keys set to `null` are deleted. 1000 total values are allowed, inclusive of existing metadata. Each item in an array counts towards the total. The following keys are reserved for internal use: `document_id`, `document_type`, `document_source`, `document_name`, `document_uploaded_at`. If the document is managed by a connection, this operation will extend a metadata overlay which is applied to the document any time the connection syncs the document."""

    async_: Annotated[Optional[bool], pydantic.Field(alias="async")] = False
    r"""Whether to run the metadata update asynchronously. If true, the metadata update will be run in the background and the response will be 202. If false, the metadata update will be run synchronously and the response will be 200."""
