"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .mediamodeparam import MediaModeParam, MediaModeParamTypedDict
from .publicbackblazeconnection import (
    PublicBackblazeConnection,
    PublicBackblazeConnectionTypedDict,
)
from .publicfreshdeskconnection import (
    PublicFreshdeskConnection,
    PublicFreshdeskConnectionTypedDict,
)
from .publicgcsconnection import PublicGCSConnection, PublicGCSConnectionTypedDict
from .publicintercomconnection import (
    PublicIntercomConnection,
    PublicIntercomConnectionTypedDict,
)
from .publics3compatibleconnection import (
    PublicS3CompatibleConnection,
    PublicS3CompatibleConnectionTypedDict,
)
from .publiczendeskconnection import (
    PublicZendeskConnection,
    PublicZendeskConnectionTypedDict,
)
from pydantic import Discriminator, Tag, model_serializer
from ragie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from ragie.utils import get_discriminator
from typing import Any, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


PublicCreateConnectionMetadataTypedDict = TypeAliasType(
    "PublicCreateConnectionMetadataTypedDict", Union[str, int, bool, List[str]]
)


PublicCreateConnectionMetadata = TypeAliasType(
    "PublicCreateConnectionMetadata", Union[str, int, bool, List[str]]
)


PublicCreateConnectionConnectionTypedDict = TypeAliasType(
    "PublicCreateConnectionConnectionTypedDict",
    Union[
        PublicBackblazeConnectionTypedDict,
        PublicGCSConnectionTypedDict,
        PublicIntercomConnectionTypedDict,
        PublicS3CompatibleConnectionTypedDict,
        PublicZendeskConnectionTypedDict,
        PublicFreshdeskConnectionTypedDict,
    ],
)


PublicCreateConnectionConnection = Annotated[
    Union[
        Annotated[PublicBackblazeConnection, Tag("backblaze")],
        Annotated[PublicFreshdeskConnection, Tag("freshdesk")],
        Annotated[PublicGCSConnection, Tag("gcs")],
        Annotated[PublicIntercomConnection, Tag("intercom")],
        Annotated[PublicS3CompatibleConnection, Tag("s3")],
        Annotated[PublicZendeskConnection, Tag("zendesk")],
    ],
    Discriminator(lambda m: get_discriminator(m, "provider", "provider")),
]


class PublicCreateConnectionTypedDict(TypedDict):
    partition_strategy: MediaModeParamTypedDict
    connection: PublicCreateConnectionConnectionTypedDict
    partition: NotRequired[Nullable[str]]
    page_limit: NotRequired[Nullable[int]]
    config: NotRequired[Nullable[Dict[str, Any]]]
    metadata: NotRequired[Dict[str, PublicCreateConnectionMetadataTypedDict]]
    r"""Metadata for the document. Keys must be strings. Values may be strings, numbers, booleans, or lists of strings. Numbers may be integers or floating point and will be converted to 64 bit floating point. 1000 total values are allowed. Each item in an array counts towards the total. The following keys are reserved for internal use: `document_id`, `document_type`, `document_source`, `document_name`, `document_uploaded_at`, `start_time`, `end_time`."""


class PublicCreateConnection(BaseModel):
    partition_strategy: MediaModeParam

    connection: PublicCreateConnectionConnection

    partition: OptionalNullable[str] = UNSET

    page_limit: OptionalNullable[int] = UNSET

    config: OptionalNullable[Dict[str, Any]] = UNSET

    metadata: Optional[Dict[str, PublicCreateConnectionMetadata]] = None
    r"""Metadata for the document. Keys must be strings. Values may be strings, numbers, booleans, or lists of strings. Numbers may be integers or floating point and will be converted to 64 bit floating point. 1000 total values are allowed. Each item in an array counts towards the total. The following keys are reserved for internal use: `document_id`, `document_type`, `document_source`, `document_name`, `document_uploaded_at`, `start_time`, `end_time`."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["partition", "page_limit", "config", "metadata"]
        nullable_fields = ["partition", "page_limit", "config"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
