"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .searchresultlink import SearchResultLink, SearchResultLinkTypedDict
import pydantic
from pydantic.functional_validators import AfterValidator
from ragie.types import BaseModel
from ragie.utils import validate_const
from typing import Any, Dict, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class RagieEvidenceTypedDict(TypedDict):
    text: str
    id: str
    r"""The chunk id of the evidence."""
    index: int
    r"""The index of the chunk in the document."""
    document_id: str
    r"""The document id of the document containing the chunk being used as evidence."""
    document_name: str
    r"""The name of the document that contains the chunk being used as evidence."""
    type: Literal["ragie"]
    metadata: NotRequired[Dict[str, Any]]
    r"""The metadata of the chunk being used as evidence."""
    document_metadata: NotRequired[Dict[str, Any]]
    r"""The metadata of the document that contains the evidence."""
    links: NotRequired[Dict[str, SearchResultLinkTypedDict]]
    r"""The links to the evidence."""


class RagieEvidence(BaseModel):
    text: str

    id: str
    r"""The chunk id of the evidence."""

    index: int
    r"""The index of the chunk in the document."""

    document_id: str
    r"""The document id of the document containing the chunk being used as evidence."""

    document_name: str
    r"""The name of the document that contains the chunk being used as evidence."""

    TYPE: Annotated[
        Annotated[Optional[Literal["ragie"]], AfterValidator(validate_const("ragie"))],
        pydantic.Field(alias="type"),
    ] = "ragie"

    metadata: Optional[Dict[str, Any]] = None
    r"""The metadata of the chunk being used as evidence."""

    document_metadata: Optional[Dict[str, Any]] = None
    r"""The metadata of the document that contains the evidence."""

    links: Optional[Dict[str, SearchResultLink]] = None
    r"""The links to the evidence."""
