"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .reasoning import Reasoning, ReasoningTypedDict
from .tool import Tool, ToolTypedDict
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from ragie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from ragie.utils import validate_const
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class RequestTypedDict(TypedDict):
    input: str
    r"""The text used to generate the response. Generally a question or a query."""
    instructions: NotRequired[Nullable[str]]
    r"""The instructions inserted in the prompt. For this agent, the instructions are injected during search related steps."""
    tools: NotRequired[List[ToolTypedDict]]
    r"""The tools available to the agent. Currently the only tool is retrieve. The `default` partition is used by default unless an other partition is specified."""
    model: Literal["deep-search"]
    r"""The model to use for the agent. Currently the only model is deep-search."""
    reasoning: NotRequired[ReasoningTypedDict]
    stream: NotRequired[bool]
    r"""Whether to stream the response"""


class Request(BaseModel):
    input: str
    r"""The text used to generate the response. Generally a question or a query."""

    instructions: OptionalNullable[str] = UNSET
    r"""The instructions inserted in the prompt. For this agent, the instructions are injected during search related steps."""

    tools: Optional[List[Tool]] = None
    r"""The tools available to the agent. Currently the only tool is retrieve. The `default` partition is used by default unless an other partition is specified."""

    MODEL: Annotated[
        Annotated[
            Optional[Literal["deep-search"]],
            AfterValidator(validate_const("deep-search")),
        ],
        pydantic.Field(alias="model"),
    ] = "deep-search"
    r"""The model to use for the agent. Currently the only model is deep-search."""

    reasoning: Optional[Reasoning] = None

    stream: Optional[bool] = False
    r"""Whether to stream the response"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["instructions", "tools", "model", "reasoning", "stream"]
        nullable_fields = ["instructions"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
