"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .finalanswer import FinalAnswer, FinalAnswerTypedDict
from .ragie_api_schema_response_usage import (
    RagieAPISchemaResponseUsage,
    RagieAPISchemaResponseUsageTypedDict,
)
from .reasoning import Reasoning, ReasoningTypedDict
from .responseoutput import ResponseOutput, ResponseOutputTypedDict
from .tool import Tool, ToolTypedDict
from enum import Enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from ragie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from ragie.utils import validate_const
from typing import Any, Dict, List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class Status(str, Enum):
    COMPLETED = "completed"
    FAILED = "failed"
    IN_PROGRESS = "in_progress"


class ResponseTypedDict(TypedDict):
    id: str
    created_at: int
    status: Status
    output: List[ResponseOutputTypedDict]
    tools: List[ToolTypedDict]
    reasoning: ReasoningTypedDict
    usage: RagieAPISchemaResponseUsageTypedDict
    object: Literal["response"]
    error: NotRequired[Nullable[str]]
    incomplete_details: NotRequired[Nullable[Any]]
    instructions: NotRequired[Nullable[str]]
    max_output_tokens: NotRequired[Nullable[Any]]
    model: Literal["deep-search"]
    output_parsed: NotRequired[Nullable[FinalAnswerTypedDict]]
    parallel_tool_calls: NotRequired[bool]
    store: NotRequired[bool]
    temperature: NotRequired[float]
    previous_response_id: NotRequired[Nullable[str]]
    tool_choice: Literal["auto"]
    top_p: NotRequired[float]
    truncation: Literal["disabled"]
    user: NotRequired[Nullable[Any]]
    metadata: NotRequired[Dict[str, Any]]


class Response(BaseModel):
    id: str

    created_at: int

    status: Status

    output: List[ResponseOutput]

    tools: List[Tool]

    reasoning: Reasoning

    usage: RagieAPISchemaResponseUsage

    OBJECT: Annotated[
        Annotated[
            Optional[Literal["response"]], AfterValidator(validate_const("response"))
        ],
        pydantic.Field(alias="object"),
    ] = "response"

    error: OptionalNullable[str] = UNSET

    incomplete_details: OptionalNullable[Any] = UNSET

    instructions: OptionalNullable[str] = UNSET

    max_output_tokens: OptionalNullable[Any] = UNSET

    MODEL: Annotated[
        Annotated[
            Optional[Literal["deep-search"]],
            AfterValidator(validate_const("deep-search")),
        ],
        pydantic.Field(alias="model"),
    ] = "deep-search"

    output_parsed: OptionalNullable[FinalAnswer] = UNSET

    parallel_tool_calls: Optional[bool] = False

    store: Optional[bool] = False

    temperature: Optional[float] = 1

    previous_response_id: OptionalNullable[str] = UNSET

    TOOL_CHOICE: Annotated[
        Annotated[Optional[Literal["auto"]], AfterValidator(validate_const("auto"))],
        pydantic.Field(alias="tool_choice"),
    ] = "auto"

    top_p: Optional[float] = 1

    TRUNCATION: Annotated[
        Annotated[
            Optional[Literal["disabled"]], AfterValidator(validate_const("disabled"))
        ],
        pydantic.Field(alias="truncation"),
    ] = "disabled"

    user: OptionalNullable[Any] = UNSET

    metadata: Optional[Dict[str, Any]] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "object",
            "error",
            "incomplete_details",
            "instructions",
            "max_output_tokens",
            "model",
            "output_parsed",
            "parallel_tool_calls",
            "store",
            "temperature",
            "previous_response_id",
            "tool_choice",
            "top_p",
            "truncation",
            "user",
            "metadata",
        ]
        nullable_fields = [
            "error",
            "incomplete_details",
            "instructions",
            "max_output_tokens",
            "output_parsed",
            "previous_response_id",
            "user",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
