# coding: utf-8

"""
    imandra-http-server

    Query Imandra via HTTP. See also https://github.com/aestheticIntegration/bs-imandra-client for a sample client implementation and OCaml API types.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from imandra_http_api_client.models.hints import Hints
from imandra_http_api_client.models.printer_details import PrinterDetails
from imandra_http_api_client.models.syntax import Syntax

class InstanceRequestSrc(BaseModel):
    """
    InstanceRequestSrc
    """
    src: StrictStr = Field(..., description="Source code string with a given syntax (default Iml)")
    syntax: Optional[Syntax] = None
    instance_printer: Optional[PrinterDetails] = None
    hints: Optional[Hints] = None
    __properties = ["src", "syntax", "instance_printer", "hints"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InstanceRequestSrc:
        """Create an instance of InstanceRequestSrc from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of instance_printer
        if self.instance_printer:
            _dict['instance_printer'] = self.instance_printer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of hints
        if self.hints:
            _dict['hints'] = self.hints.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InstanceRequestSrc:
        """Create an instance of InstanceRequestSrc from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InstanceRequestSrc.parse_obj(obj)

        _obj = InstanceRequestSrc.parse_obj({
            "src": obj.get("src"),
            "syntax": obj.get("syntax"),
            "instance_printer": PrinterDetails.from_dict(obj.get("instance_printer")) if obj.get("instance_printer") is not None else None,
            "hints": Hints.from_dict(obj.get("hints")) if obj.get("hints") is not None else None
        })
        return _obj

