# coding: utf-8

"""
    imandra-http-server

    Query Imandra via HTTP. See also https://github.com/aestheticIntegration/bs-imandra-client for a sample client implementation and OCaml API types.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional
from pydantic import BaseModel, Field, StrictStr, ValidationError, validator
from imandra_http_api_client.models.method_ext_solver_body import MethodExtSolverBody
from imandra_http_api_client.models.method_induct_body import MethodInductBody
from imandra_http_api_client.models.method_unroll_body import MethodUnrollBody
from typing import Any, List
from pydantic import StrictStr, Field

METHODBODY_ONE_OF_SCHEMAS = ["MethodExtSolverBody", "MethodInductBody", "MethodUnrollBody"]

class MethodBody(BaseModel):
    """
    MethodBody
    """
    # data type: MethodUnrollBody
    oneof_schema_1_validator: Optional[MethodUnrollBody] = None
    # data type: MethodExtSolverBody
    oneof_schema_2_validator: Optional[MethodExtSolverBody] = None
    # data type: MethodInductBody
    oneof_schema_3_validator: Optional[MethodInductBody] = None
    actual_instance: Any
    one_of_schemas: List[str] = Field(METHODBODY_ONE_OF_SCHEMAS, const=True)

    class Config:
        validate_assignment = True

    def __init__(self, *args, **kwargs):
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = MethodBody.construct()
        error_messages = []
        match = 0
        # validate data type: MethodUnrollBody
        if not isinstance(v, MethodUnrollBody):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MethodUnrollBody`")
        else:
            match += 1
        # validate data type: MethodExtSolverBody
        if not isinstance(v, MethodExtSolverBody):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MethodExtSolverBody`")
        else:
            match += 1
        # validate data type: MethodInductBody
        if not isinstance(v, MethodInductBody):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MethodInductBody`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in MethodBody with oneOf schemas: MethodExtSolverBody, MethodInductBody, MethodUnrollBody. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in MethodBody with oneOf schemas: MethodExtSolverBody, MethodInductBody, MethodUnrollBody. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> MethodBody:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> MethodBody:
        """Returns the object represented by the json string"""
        instance = MethodBody.construct()
        error_messages = []
        match = 0

        # deserialize data into MethodUnrollBody
        try:
            instance.actual_instance = MethodUnrollBody.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into MethodExtSolverBody
        try:
            instance.actual_instance = MethodExtSolverBody.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into MethodInductBody
        try:
            instance.actual_instance = MethodInductBody.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into MethodBody with oneOf schemas: MethodExtSolverBody, MethodInductBody, MethodUnrollBody. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into MethodBody with oneOf schemas: MethodExtSolverBody, MethodInductBody, MethodUnrollBody. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        to_json = getattr(self.actual_instance, "to_json", None)
        if callable(to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        to_dict = getattr(self.actual_instance, "to_dict", None)
        if callable(to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.dict())

