# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CustomConnectorPluginVersionArgs', 'CustomConnectorPluginVersion']

@pulumi.input_type
class CustomConnectorPluginVersionArgs:
    def __init__(__self__, *,
                 cloud: pulumi.Input[_builtins.str],
                 connector_classes: pulumi.Input[Sequence[pulumi.Input['CustomConnectorPluginVersionConnectorClassArgs']]],
                 environment: pulumi.Input['CustomConnectorPluginVersionEnvironmentArgs'],
                 filename: pulumi.Input[_builtins.str],
                 plugin_id: pulumi.Input[_builtins.str],
                 version: pulumi.Input[_builtins.str],
                 documentation_link: Optional[pulumi.Input[_builtins.str]] = None,
                 sensitive_config_properties: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a CustomConnectorPluginVersion resource.
        :param pulumi.Input[_builtins.str] cloud: Cloud provider where the Custom Connector Plugin Version archive is uploaded. Accepted values are: `AWS`, `AZURE`, `GCP`.
        :param pulumi.Input[Sequence[pulumi.Input['CustomConnectorPluginVersionConnectorClassArgs']]] connector_classes: The Java class name or alias for the connector. You can get the connector class from the connector documentation provided by the developer.
        :param pulumi.Input['CustomConnectorPluginVersionEnvironmentArgs'] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[_builtins.str] filename: The path to the Custom Connector Plugin Version archive to be uploaded. Accepted archive formats are: `.jar`, `.zip`.
        :param pulumi.Input[_builtins.str] plugin_id: The ID of the plugin created using `Plugin` resource, or through other ways.
        :param pulumi.Input[_builtins.str] version: The version number of the plugin version we want to create. This must start with the character `v` and follow semantic versioning.
        :param pulumi.Input[_builtins.str] documentation_link: The documentation link of the Custom Connector Plugin Version.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sensitive_config_properties: The list of sensitive properties. A sensitive property is a connector configuration property that must be hidden after a user enters the property value when setting up the connector, for example, passwords, keys, and tokens. Refer to the developer documentation and add all required and optional sensitive properties that a user could potentially configure for the connector. Marking a property as sensitive ensures that these fields are handled appropriately within the Confluent infrastructure. This includes masking fields, for example in exception logging, and encrypting field values in the underlying data store. You must identify all sensitive properties. Failure to identify sensitive properties can result in the sensitive property value being stored in plain text rather than in encrypted format. Only add connector-specific sensitive properties. Kafka keys, passwords, and service account information should not be entered here.
        """
        pulumi.set(__self__, "cloud", cloud)
        pulumi.set(__self__, "connector_classes", connector_classes)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "filename", filename)
        pulumi.set(__self__, "plugin_id", plugin_id)
        pulumi.set(__self__, "version", version)
        if documentation_link is not None:
            pulumi.set(__self__, "documentation_link", documentation_link)
        if sensitive_config_properties is not None:
            pulumi.set(__self__, "sensitive_config_properties", sensitive_config_properties)

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> pulumi.Input[_builtins.str]:
        """
        Cloud provider where the Custom Connector Plugin Version archive is uploaded. Accepted values are: `AWS`, `AZURE`, `GCP`.
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cloud", value)

    @_builtins.property
    @pulumi.getter(name="connectorClasses")
    def connector_classes(self) -> pulumi.Input[Sequence[pulumi.Input['CustomConnectorPluginVersionConnectorClassArgs']]]:
        """
        The Java class name or alias for the connector. You can get the connector class from the connector documentation provided by the developer.
        """
        return pulumi.get(self, "connector_classes")

    @connector_classes.setter
    def connector_classes(self, value: pulumi.Input[Sequence[pulumi.Input['CustomConnectorPluginVersionConnectorClassArgs']]]):
        pulumi.set(self, "connector_classes", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Input['CustomConnectorPluginVersionEnvironmentArgs']:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input['CustomConnectorPluginVersionEnvironmentArgs']):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def filename(self) -> pulumi.Input[_builtins.str]:
        """
        The path to the Custom Connector Plugin Version archive to be uploaded. Accepted archive formats are: `.jar`, `.zip`.
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "filename", value)

    @_builtins.property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the plugin created using `Plugin` resource, or through other ways.
        """
        return pulumi.get(self, "plugin_id")

    @plugin_id.setter
    def plugin_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "plugin_id", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        The version number of the plugin version we want to create. This must start with the character `v` and follow semantic versioning.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="documentationLink")
    def documentation_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The documentation link of the Custom Connector Plugin Version.
        """
        return pulumi.get(self, "documentation_link")

    @documentation_link.setter
    def documentation_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "documentation_link", value)

    @_builtins.property
    @pulumi.getter(name="sensitiveConfigProperties")
    def sensitive_config_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of sensitive properties. A sensitive property is a connector configuration property that must be hidden after a user enters the property value when setting up the connector, for example, passwords, keys, and tokens. Refer to the developer documentation and add all required and optional sensitive properties that a user could potentially configure for the connector. Marking a property as sensitive ensures that these fields are handled appropriately within the Confluent infrastructure. This includes masking fields, for example in exception logging, and encrypting field values in the underlying data store. You must identify all sensitive properties. Failure to identify sensitive properties can result in the sensitive property value being stored in plain text rather than in encrypted format. Only add connector-specific sensitive properties. Kafka keys, passwords, and service account information should not be entered here.
        """
        return pulumi.get(self, "sensitive_config_properties")

    @sensitive_config_properties.setter
    def sensitive_config_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sensitive_config_properties", value)


@pulumi.input_type
class _CustomConnectorPluginVersionState:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_classes: Optional[pulumi.Input[Sequence[pulumi.Input['CustomConnectorPluginVersionConnectorClassArgs']]]] = None,
                 documentation_link: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input['CustomConnectorPluginVersionEnvironmentArgs']] = None,
                 filename: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sensitive_config_properties: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CustomConnectorPluginVersion resources.
        :param pulumi.Input[_builtins.str] api_version: (Required String) The API Version of the schema version of the plugin version, for example, `ccpm/v1`.
        :param pulumi.Input[_builtins.str] cloud: Cloud provider where the Custom Connector Plugin Version archive is uploaded. Accepted values are: `AWS`, `AZURE`, `GCP`.
        :param pulumi.Input[Sequence[pulumi.Input['CustomConnectorPluginVersionConnectorClassArgs']]] connector_classes: The Java class name or alias for the connector. You can get the connector class from the connector documentation provided by the developer.
        :param pulumi.Input[_builtins.str] documentation_link: The documentation link of the Custom Connector Plugin Version.
        :param pulumi.Input['CustomConnectorPluginVersionEnvironmentArgs'] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[_builtins.str] filename: The path to the Custom Connector Plugin Version archive to be uploaded. Accepted archive formats are: `.jar`, `.zip`.
        :param pulumi.Input[_builtins.str] kind: (Required String) The kind of the Plugin Version, for example, `CustomConnectPluginVersion`.
        :param pulumi.Input[_builtins.str] plugin_id: The ID of the plugin created using `Plugin` resource, or through other ways.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sensitive_config_properties: The list of sensitive properties. A sensitive property is a connector configuration property that must be hidden after a user enters the property value when setting up the connector, for example, passwords, keys, and tokens. Refer to the developer documentation and add all required and optional sensitive properties that a user could potentially configure for the connector. Marking a property as sensitive ensures that these fields are handled appropriately within the Confluent infrastructure. This includes masking fields, for example in exception logging, and encrypting field values in the underlying data store. You must identify all sensitive properties. Failure to identify sensitive properties can result in the sensitive property value being stored in plain text rather than in encrypted format. Only add connector-specific sensitive properties. Kafka keys, passwords, and service account information should not be entered here.
        :param pulumi.Input[_builtins.str] version: The version number of the plugin version we want to create. This must start with the character `v` and follow semantic versioning.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if connector_classes is not None:
            pulumi.set(__self__, "connector_classes", connector_classes)
        if documentation_link is not None:
            pulumi.set(__self__, "documentation_link", documentation_link)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if filename is not None:
            pulumi.set(__self__, "filename", filename)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if plugin_id is not None:
            pulumi.set(__self__, "plugin_id", plugin_id)
        if sensitive_config_properties is not None:
            pulumi.set(__self__, "sensitive_config_properties", sensitive_config_properties)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Required String) The API Version of the schema version of the plugin version, for example, `ccpm/v1`.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloud provider where the Custom Connector Plugin Version archive is uploaded. Accepted values are: `AWS`, `AZURE`, `GCP`.
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud", value)

    @_builtins.property
    @pulumi.getter(name="connectorClasses")
    def connector_classes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomConnectorPluginVersionConnectorClassArgs']]]]:
        """
        The Java class name or alias for the connector. You can get the connector class from the connector documentation provided by the developer.
        """
        return pulumi.get(self, "connector_classes")

    @connector_classes.setter
    def connector_classes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomConnectorPluginVersionConnectorClassArgs']]]]):
        pulumi.set(self, "connector_classes", value)

    @_builtins.property
    @pulumi.getter(name="documentationLink")
    def documentation_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The documentation link of the Custom Connector Plugin Version.
        """
        return pulumi.get(self, "documentation_link")

    @documentation_link.setter
    def documentation_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "documentation_link", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['CustomConnectorPluginVersionEnvironmentArgs']]:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['CustomConnectorPluginVersionEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def filename(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the Custom Connector Plugin Version archive to be uploaded. Accepted archive formats are: `.jar`, `.zip`.
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filename", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Required String) The kind of the Plugin Version, for example, `CustomConnectPluginVersion`.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the plugin created using `Plugin` resource, or through other ways.
        """
        return pulumi.get(self, "plugin_id")

    @plugin_id.setter
    def plugin_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_id", value)

    @_builtins.property
    @pulumi.getter(name="sensitiveConfigProperties")
    def sensitive_config_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of sensitive properties. A sensitive property is a connector configuration property that must be hidden after a user enters the property value when setting up the connector, for example, passwords, keys, and tokens. Refer to the developer documentation and add all required and optional sensitive properties that a user could potentially configure for the connector. Marking a property as sensitive ensures that these fields are handled appropriately within the Confluent infrastructure. This includes masking fields, for example in exception logging, and encrypting field values in the underlying data store. You must identify all sensitive properties. Failure to identify sensitive properties can result in the sensitive property value being stored in plain text rather than in encrypted format. Only add connector-specific sensitive properties. Kafka keys, passwords, and service account information should not be entered here.
        """
        return pulumi.get(self, "sensitive_config_properties")

    @sensitive_config_properties.setter
    def sensitive_config_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sensitive_config_properties", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version number of the plugin version we want to create. This must start with the character `v` and follow semantic versioning.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("confluentcloud:index/customConnectorPluginVersion:CustomConnectorPluginVersion")
class CustomConnectorPluginVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_classes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomConnectorPluginVersionConnectorClassArgs', 'CustomConnectorPluginVersionConnectorClassArgsDict']]]]] = None,
                 documentation_link: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[Union['CustomConnectorPluginVersionEnvironmentArgs', 'CustomConnectorPluginVersionEnvironmentArgsDict']]] = None,
                 filename: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sensitive_config_properties: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        source = confluentcloud.CustomConnectorPluginVersion("source",
            version="v1.2.4",
            cloud="AWS",
            documentation_link="https://www.confluent.io/hub/confluentinc/kafka-connect-datagen",
            connector_classes=[{
                "connector_class_name": "io.confluent.kafka.connect.datagen.DatagenConnector",
                "connector_type": "SOURCE",
            }],
            sensitive_config_properties=[],
            filename="confluentinc-kafka-connect-datagen-0.6.2.zip",
            plugin_id="ccp-dev-123",
            environment={
                "id": "env-devc0k7oxp",
            },
            opts = pulumi.ResourceOptions(depends_on=[plugin]))
        ```

        ## Import

        You can import a Custom Connector Plugin by using a Custom Connector Plugin ID, in the format `<Environment ID>/<Plugin ID>/<Version ID>`. The following example shows how to import a Custom Connector Plugin:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/customConnectorPluginVersion:CustomConnectorPluginVersion main env-123/plug-123/ccp-ver123xyz
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cloud: Cloud provider where the Custom Connector Plugin Version archive is uploaded. Accepted values are: `AWS`, `AZURE`, `GCP`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomConnectorPluginVersionConnectorClassArgs', 'CustomConnectorPluginVersionConnectorClassArgsDict']]]] connector_classes: The Java class name or alias for the connector. You can get the connector class from the connector documentation provided by the developer.
        :param pulumi.Input[_builtins.str] documentation_link: The documentation link of the Custom Connector Plugin Version.
        :param pulumi.Input[Union['CustomConnectorPluginVersionEnvironmentArgs', 'CustomConnectorPluginVersionEnvironmentArgsDict']] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[_builtins.str] filename: The path to the Custom Connector Plugin Version archive to be uploaded. Accepted archive formats are: `.jar`, `.zip`.
        :param pulumi.Input[_builtins.str] plugin_id: The ID of the plugin created using `Plugin` resource, or through other ways.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sensitive_config_properties: The list of sensitive properties. A sensitive property is a connector configuration property that must be hidden after a user enters the property value when setting up the connector, for example, passwords, keys, and tokens. Refer to the developer documentation and add all required and optional sensitive properties that a user could potentially configure for the connector. Marking a property as sensitive ensures that these fields are handled appropriately within the Confluent infrastructure. This includes masking fields, for example in exception logging, and encrypting field values in the underlying data store. You must identify all sensitive properties. Failure to identify sensitive properties can result in the sensitive property value being stored in plain text rather than in encrypted format. Only add connector-specific sensitive properties. Kafka keys, passwords, and service account information should not be entered here.
        :param pulumi.Input[_builtins.str] version: The version number of the plugin version we want to create. This must start with the character `v` and follow semantic versioning.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomConnectorPluginVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        source = confluentcloud.CustomConnectorPluginVersion("source",
            version="v1.2.4",
            cloud="AWS",
            documentation_link="https://www.confluent.io/hub/confluentinc/kafka-connect-datagen",
            connector_classes=[{
                "connector_class_name": "io.confluent.kafka.connect.datagen.DatagenConnector",
                "connector_type": "SOURCE",
            }],
            sensitive_config_properties=[],
            filename="confluentinc-kafka-connect-datagen-0.6.2.zip",
            plugin_id="ccp-dev-123",
            environment={
                "id": "env-devc0k7oxp",
            },
            opts = pulumi.ResourceOptions(depends_on=[plugin]))
        ```

        ## Import

        You can import a Custom Connector Plugin by using a Custom Connector Plugin ID, in the format `<Environment ID>/<Plugin ID>/<Version ID>`. The following example shows how to import a Custom Connector Plugin:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/customConnectorPluginVersion:CustomConnectorPluginVersion main env-123/plug-123/ccp-ver123xyz
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param CustomConnectorPluginVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomConnectorPluginVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_classes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomConnectorPluginVersionConnectorClassArgs', 'CustomConnectorPluginVersionConnectorClassArgsDict']]]]] = None,
                 documentation_link: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[Union['CustomConnectorPluginVersionEnvironmentArgs', 'CustomConnectorPluginVersionEnvironmentArgsDict']]] = None,
                 filename: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sensitive_config_properties: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomConnectorPluginVersionArgs.__new__(CustomConnectorPluginVersionArgs)

            if cloud is None and not opts.urn:
                raise TypeError("Missing required property 'cloud'")
            __props__.__dict__["cloud"] = cloud
            if connector_classes is None and not opts.urn:
                raise TypeError("Missing required property 'connector_classes'")
            __props__.__dict__["connector_classes"] = connector_classes
            __props__.__dict__["documentation_link"] = documentation_link
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            if filename is None and not opts.urn:
                raise TypeError("Missing required property 'filename'")
            __props__.__dict__["filename"] = filename
            if plugin_id is None and not opts.urn:
                raise TypeError("Missing required property 'plugin_id'")
            __props__.__dict__["plugin_id"] = plugin_id
            __props__.__dict__["sensitive_config_properties"] = sensitive_config_properties
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["api_version"] = None
            __props__.__dict__["kind"] = None
        super(CustomConnectorPluginVersion, __self__).__init__(
            'confluentcloud:index/customConnectorPluginVersion:CustomConnectorPluginVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_version: Optional[pulumi.Input[_builtins.str]] = None,
            cloud: Optional[pulumi.Input[_builtins.str]] = None,
            connector_classes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomConnectorPluginVersionConnectorClassArgs', 'CustomConnectorPluginVersionConnectorClassArgsDict']]]]] = None,
            documentation_link: Optional[pulumi.Input[_builtins.str]] = None,
            environment: Optional[pulumi.Input[Union['CustomConnectorPluginVersionEnvironmentArgs', 'CustomConnectorPluginVersionEnvironmentArgsDict']]] = None,
            filename: Optional[pulumi.Input[_builtins.str]] = None,
            kind: Optional[pulumi.Input[_builtins.str]] = None,
            plugin_id: Optional[pulumi.Input[_builtins.str]] = None,
            sensitive_config_properties: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'CustomConnectorPluginVersion':
        """
        Get an existing CustomConnectorPluginVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_version: (Required String) The API Version of the schema version of the plugin version, for example, `ccpm/v1`.
        :param pulumi.Input[_builtins.str] cloud: Cloud provider where the Custom Connector Plugin Version archive is uploaded. Accepted values are: `AWS`, `AZURE`, `GCP`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomConnectorPluginVersionConnectorClassArgs', 'CustomConnectorPluginVersionConnectorClassArgsDict']]]] connector_classes: The Java class name or alias for the connector. You can get the connector class from the connector documentation provided by the developer.
        :param pulumi.Input[_builtins.str] documentation_link: The documentation link of the Custom Connector Plugin Version.
        :param pulumi.Input[Union['CustomConnectorPluginVersionEnvironmentArgs', 'CustomConnectorPluginVersionEnvironmentArgsDict']] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[_builtins.str] filename: The path to the Custom Connector Plugin Version archive to be uploaded. Accepted archive formats are: `.jar`, `.zip`.
        :param pulumi.Input[_builtins.str] kind: (Required String) The kind of the Plugin Version, for example, `CustomConnectPluginVersion`.
        :param pulumi.Input[_builtins.str] plugin_id: The ID of the plugin created using `Plugin` resource, or through other ways.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sensitive_config_properties: The list of sensitive properties. A sensitive property is a connector configuration property that must be hidden after a user enters the property value when setting up the connector, for example, passwords, keys, and tokens. Refer to the developer documentation and add all required and optional sensitive properties that a user could potentially configure for the connector. Marking a property as sensitive ensures that these fields are handled appropriately within the Confluent infrastructure. This includes masking fields, for example in exception logging, and encrypting field values in the underlying data store. You must identify all sensitive properties. Failure to identify sensitive properties can result in the sensitive property value being stored in plain text rather than in encrypted format. Only add connector-specific sensitive properties. Kafka keys, passwords, and service account information should not be entered here.
        :param pulumi.Input[_builtins.str] version: The version number of the plugin version we want to create. This must start with the character `v` and follow semantic versioning.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomConnectorPluginVersionState.__new__(_CustomConnectorPluginVersionState)

        __props__.__dict__["api_version"] = api_version
        __props__.__dict__["cloud"] = cloud
        __props__.__dict__["connector_classes"] = connector_classes
        __props__.__dict__["documentation_link"] = documentation_link
        __props__.__dict__["environment"] = environment
        __props__.__dict__["filename"] = filename
        __props__.__dict__["kind"] = kind
        __props__.__dict__["plugin_id"] = plugin_id
        __props__.__dict__["sensitive_config_properties"] = sensitive_config_properties
        __props__.__dict__["version"] = version
        return CustomConnectorPluginVersion(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> pulumi.Output[_builtins.str]:
        """
        (Required String) The API Version of the schema version of the plugin version, for example, `ccpm/v1`.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> pulumi.Output[_builtins.str]:
        """
        Cloud provider where the Custom Connector Plugin Version archive is uploaded. Accepted values are: `AWS`, `AZURE`, `GCP`.
        """
        return pulumi.get(self, "cloud")

    @_builtins.property
    @pulumi.getter(name="connectorClasses")
    def connector_classes(self) -> pulumi.Output[Sequence['outputs.CustomConnectorPluginVersionConnectorClass']]:
        """
        The Java class name or alias for the connector. You can get the connector class from the connector documentation provided by the developer.
        """
        return pulumi.get(self, "connector_classes")

    @_builtins.property
    @pulumi.getter(name="documentationLink")
    def documentation_link(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The documentation link of the Custom Connector Plugin Version.
        """
        return pulumi.get(self, "documentation_link")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output['outputs.CustomConnectorPluginVersionEnvironment']:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter
    def filename(self) -> pulumi.Output[_builtins.str]:
        """
        The path to the Custom Connector Plugin Version archive to be uploaded. Accepted archive formats are: `.jar`, `.zip`.
        """
        return pulumi.get(self, "filename")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> pulumi.Output[_builtins.str]:
        """
        (Required String) The kind of the Plugin Version, for example, `CustomConnectPluginVersion`.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the plugin created using `Plugin` resource, or through other ways.
        """
        return pulumi.get(self, "plugin_id")

    @_builtins.property
    @pulumi.getter(name="sensitiveConfigProperties")
    def sensitive_config_properties(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of sensitive properties. A sensitive property is a connector configuration property that must be hidden after a user enters the property value when setting up the connector, for example, passwords, keys, and tokens. Refer to the developer documentation and add all required and optional sensitive properties that a user could potentially configure for the connector. Marking a property as sensitive ensures that these fields are handled appropriately within the Confluent infrastructure. This includes masking fields, for example in exception logging, and encrypting field values in the underlying data store. You must identify all sensitive properties. Failure to identify sensitive properties can result in the sensitive property value being stored in plain text rather than in encrypted format. Only add connector-specific sensitive properties. Kafka keys, passwords, and service account information should not be entered here.
        """
        return pulumi.get(self, "sensitive_config_properties")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The version number of the plugin version we want to create. This must start with the character `v` and follow semantic versioning.
        """
        return pulumi.get(self, "version")

