# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FlinkConnectionArgs', 'FlinkConnection']

@pulumi.input_type
class FlinkConnectionArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 endpoint: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_session_token: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_pool: Optional[pulumi.Input['FlinkConnectionComputePoolArgs']] = None,
                 credentials: Optional[pulumi.Input['FlinkConnectionCredentialsArgs']] = None,
                 environment: Optional[pulumi.Input['FlinkConnectionEnvironmentArgs']] = None,
                 organization: Optional[pulumi.Input['FlinkConnectionOrganizationArgs']] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 principal: Optional[pulumi.Input['FlinkConnectionPrincipalArgs']] = None,
                 rest_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 service_key: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FlinkConnection resource.
        :param pulumi.Input[_builtins.str] display_name: The unique name of the Flink Connection per organization, environment scope.
        :param pulumi.Input[_builtins.str] endpoint: The endpoint of the flink connection.
        :param pulumi.Input[_builtins.str] type: The type of the flink connection.
        :param pulumi.Input[_builtins.str] api_key: API key for the type.
        :param pulumi.Input[_builtins.str] aws_access_key: Access key for the type.
        :param pulumi.Input[_builtins.str] aws_secret_key: Secret key for the type.
        :param pulumi.Input[_builtins.str] aws_session_token: Session token for the type.
        :param pulumi.Input['FlinkConnectionCredentialsArgs'] credentials: The Cluster API Credentials.
        :param pulumi.Input[_builtins.str] password: Password for the type.
        :param pulumi.Input[_builtins.str] rest_endpoint: The REST endpoint of the Flink Connection cluster, for example, `https://flink.us-east-1.aws.confluent.cloud/sql/v1/organizations/1111aaaa-11aa-11aa-11aa-111111aaaaaa/environments/env-abc123`).
        :param pulumi.Input[_builtins.str] service_key: Service Key for the type.
        :param pulumi.Input[_builtins.str] username: Username for the type.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "type", type)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if aws_access_key is not None:
            pulumi.set(__self__, "aws_access_key", aws_access_key)
        if aws_secret_key is not None:
            pulumi.set(__self__, "aws_secret_key", aws_secret_key)
        if aws_session_token is not None:
            pulumi.set(__self__, "aws_session_token", aws_session_token)
        if compute_pool is not None:
            pulumi.set(__self__, "compute_pool", compute_pool)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)
        if rest_endpoint is not None:
            pulumi.set(__self__, "rest_endpoint", rest_endpoint)
        if service_key is not None:
            pulumi.set(__self__, "service_key", service_key)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The unique name of the Flink Connection per organization, environment scope.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        The endpoint of the flink connection.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the flink connection.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API key for the type.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter(name="awsAccessKey")
    def aws_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access key for the type.
        """
        return pulumi.get(self, "aws_access_key")

    @aws_access_key.setter
    def aws_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_access_key", value)

    @_builtins.property
    @pulumi.getter(name="awsSecretKey")
    def aws_secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Secret key for the type.
        """
        return pulumi.get(self, "aws_secret_key")

    @aws_secret_key.setter
    def aws_secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_secret_key", value)

    @_builtins.property
    @pulumi.getter(name="awsSessionToken")
    def aws_session_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Session token for the type.
        """
        return pulumi.get(self, "aws_session_token")

    @aws_session_token.setter
    def aws_session_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_session_token", value)

    @_builtins.property
    @pulumi.getter(name="computePool")
    def compute_pool(self) -> Optional[pulumi.Input['FlinkConnectionComputePoolArgs']]:
        return pulumi.get(self, "compute_pool")

    @compute_pool.setter
    def compute_pool(self, value: Optional[pulumi.Input['FlinkConnectionComputePoolArgs']]):
        pulumi.set(self, "compute_pool", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['FlinkConnectionCredentialsArgs']]:
        """
        The Cluster API Credentials.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['FlinkConnectionCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['FlinkConnectionEnvironmentArgs']]:
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['FlinkConnectionEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input['FlinkConnectionOrganizationArgs']]:
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input['FlinkConnectionOrganizationArgs']]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password for the type.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def principal(self) -> Optional[pulumi.Input['FlinkConnectionPrincipalArgs']]:
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: Optional[pulumi.Input['FlinkConnectionPrincipalArgs']]):
        pulumi.set(self, "principal", value)

    @_builtins.property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The REST endpoint of the Flink Connection cluster, for example, `https://flink.us-east-1.aws.confluent.cloud/sql/v1/organizations/1111aaaa-11aa-11aa-11aa-111111aaaaaa/environments/env-abc123`).
        """
        return pulumi.get(self, "rest_endpoint")

    @rest_endpoint.setter
    def rest_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rest_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="serviceKey")
    def service_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service Key for the type.
        """
        return pulumi.get(self, "service_key")

    @service_key.setter
    def service_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_key", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username for the type.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class _FlinkConnectionState:
    def __init__(__self__, *,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_session_token: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_pool: Optional[pulumi.Input['FlinkConnectionComputePoolArgs']] = None,
                 credentials: Optional[pulumi.Input['FlinkConnectionCredentialsArgs']] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input['FlinkConnectionEnvironmentArgs']] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input['FlinkConnectionOrganizationArgs']] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 principal: Optional[pulumi.Input['FlinkConnectionPrincipalArgs']] = None,
                 rest_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 service_key: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FlinkConnection resources.
        :param pulumi.Input[_builtins.str] api_key: API key for the type.
        :param pulumi.Input[_builtins.str] api_version: The schema version of this representation of a resource.
        :param pulumi.Input[_builtins.str] aws_access_key: Access key for the type.
        :param pulumi.Input[_builtins.str] aws_secret_key: Secret key for the type.
        :param pulumi.Input[_builtins.str] aws_session_token: Session token for the type.
        :param pulumi.Input['FlinkConnectionCredentialsArgs'] credentials: The Cluster API Credentials.
        :param pulumi.Input[_builtins.str] display_name: The unique name of the Flink Connection per organization, environment scope.
        :param pulumi.Input[_builtins.str] endpoint: The endpoint of the flink connection.
        :param pulumi.Input[_builtins.str] kind: The object this REST resource represents.
        :param pulumi.Input[_builtins.str] password: Password for the type.
        :param pulumi.Input[_builtins.str] rest_endpoint: The REST endpoint of the Flink Connection cluster, for example, `https://flink.us-east-1.aws.confluent.cloud/sql/v1/organizations/1111aaaa-11aa-11aa-11aa-111111aaaaaa/environments/env-abc123`).
        :param pulumi.Input[_builtins.str] service_key: Service Key for the type.
        :param pulumi.Input[_builtins.str] type: The type of the flink connection.
        :param pulumi.Input[_builtins.str] username: Username for the type.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if aws_access_key is not None:
            pulumi.set(__self__, "aws_access_key", aws_access_key)
        if aws_secret_key is not None:
            pulumi.set(__self__, "aws_secret_key", aws_secret_key)
        if aws_session_token is not None:
            pulumi.set(__self__, "aws_session_token", aws_session_token)
        if compute_pool is not None:
            pulumi.set(__self__, "compute_pool", compute_pool)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)
        if rest_endpoint is not None:
            pulumi.set(__self__, "rest_endpoint", rest_endpoint)
        if service_key is not None:
            pulumi.set(__self__, "service_key", service_key)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API key for the type.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schema version of this representation of a resource.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter(name="awsAccessKey")
    def aws_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access key for the type.
        """
        return pulumi.get(self, "aws_access_key")

    @aws_access_key.setter
    def aws_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_access_key", value)

    @_builtins.property
    @pulumi.getter(name="awsSecretKey")
    def aws_secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Secret key for the type.
        """
        return pulumi.get(self, "aws_secret_key")

    @aws_secret_key.setter
    def aws_secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_secret_key", value)

    @_builtins.property
    @pulumi.getter(name="awsSessionToken")
    def aws_session_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Session token for the type.
        """
        return pulumi.get(self, "aws_session_token")

    @aws_session_token.setter
    def aws_session_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_session_token", value)

    @_builtins.property
    @pulumi.getter(name="computePool")
    def compute_pool(self) -> Optional[pulumi.Input['FlinkConnectionComputePoolArgs']]:
        return pulumi.get(self, "compute_pool")

    @compute_pool.setter
    def compute_pool(self, value: Optional[pulumi.Input['FlinkConnectionComputePoolArgs']]):
        pulumi.set(self, "compute_pool", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['FlinkConnectionCredentialsArgs']]:
        """
        The Cluster API Credentials.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['FlinkConnectionCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of the Flink Connection per organization, environment scope.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint of the flink connection.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['FlinkConnectionEnvironmentArgs']]:
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['FlinkConnectionEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The object this REST resource represents.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input['FlinkConnectionOrganizationArgs']]:
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input['FlinkConnectionOrganizationArgs']]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password for the type.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def principal(self) -> Optional[pulumi.Input['FlinkConnectionPrincipalArgs']]:
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: Optional[pulumi.Input['FlinkConnectionPrincipalArgs']]):
        pulumi.set(self, "principal", value)

    @_builtins.property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The REST endpoint of the Flink Connection cluster, for example, `https://flink.us-east-1.aws.confluent.cloud/sql/v1/organizations/1111aaaa-11aa-11aa-11aa-111111aaaaaa/environments/env-abc123`).
        """
        return pulumi.get(self, "rest_endpoint")

    @rest_endpoint.setter
    def rest_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rest_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="serviceKey")
    def service_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service Key for the type.
        """
        return pulumi.get(self, "service_key")

    @service_key.setter
    def service_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_key", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the flink connection.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username for the type.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("confluentcloud:index/flinkConnection:FlinkConnection")
class FlinkConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_session_token: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_pool: Optional[pulumi.Input[Union['FlinkConnectionComputePoolArgs', 'FlinkConnectionComputePoolArgsDict']]] = None,
                 credentials: Optional[pulumi.Input[Union['FlinkConnectionCredentialsArgs', 'FlinkConnectionCredentialsArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[Union['FlinkConnectionEnvironmentArgs', 'FlinkConnectionEnvironmentArgsDict']]] = None,
                 organization: Optional[pulumi.Input[Union['FlinkConnectionOrganizationArgs', 'FlinkConnectionOrganizationArgsDict']]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 principal: Optional[pulumi.Input[Union['FlinkConnectionPrincipalArgs', 'FlinkConnectionPrincipalArgsDict']]] = None,
                 rest_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 service_key: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        You can import a Flink connection by using the Flink Connection name, for example:

        Option #1: Manage multiple Flink Compute Pools in the same Pulumi Stack

        $ export IMPORT_CONFLUENT_ORGANIZATION_ID="<organization_id>"

        $ export IMPORT_CONFLUENT_ENVIRONMENT_ID="<environment_id>"

        $ export IMPORT_FLINK_COMPUTE_POOL_ID="<flink_compute_pool_id>"

        $ export IMPORT_FLINK_API_KEY="<flink_api_key>"

        $ export IMPORT_FLINK_API_SECRET="<flink_api_secret>"

        $ export IMPORT_FLINK_REST_ENDPOINT="<flink_rest_endpoint>"

        $ export IMPORT_FLINK_PRINCIPAL_ID="<flink_principal>"

        $ export API_KEY="<API_KEY>"

        ```sh
        $ pulumi import confluentcloud:index/flinkConnection:FlinkConnection example org-xyz123/env-abc123/connection1
        ```

        Option #2: Manage a single Flink Compute Pool in the same Pulumi Stack

        $ export API_KEY="<API_KEY>"

        ```sh
        $ pulumi import confluentcloud:index/flinkConnection:FlinkConnection example org-xyz123/env-abc123/connection1
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_key: API key for the type.
        :param pulumi.Input[_builtins.str] aws_access_key: Access key for the type.
        :param pulumi.Input[_builtins.str] aws_secret_key: Secret key for the type.
        :param pulumi.Input[_builtins.str] aws_session_token: Session token for the type.
        :param pulumi.Input[Union['FlinkConnectionCredentialsArgs', 'FlinkConnectionCredentialsArgsDict']] credentials: The Cluster API Credentials.
        :param pulumi.Input[_builtins.str] display_name: The unique name of the Flink Connection per organization, environment scope.
        :param pulumi.Input[_builtins.str] endpoint: The endpoint of the flink connection.
        :param pulumi.Input[_builtins.str] password: Password for the type.
        :param pulumi.Input[_builtins.str] rest_endpoint: The REST endpoint of the Flink Connection cluster, for example, `https://flink.us-east-1.aws.confluent.cloud/sql/v1/organizations/1111aaaa-11aa-11aa-11aa-111111aaaaaa/environments/env-abc123`).
        :param pulumi.Input[_builtins.str] service_key: Service Key for the type.
        :param pulumi.Input[_builtins.str] type: The type of the flink connection.
        :param pulumi.Input[_builtins.str] username: Username for the type.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlinkConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        You can import a Flink connection by using the Flink Connection name, for example:

        Option #1: Manage multiple Flink Compute Pools in the same Pulumi Stack

        $ export IMPORT_CONFLUENT_ORGANIZATION_ID="<organization_id>"

        $ export IMPORT_CONFLUENT_ENVIRONMENT_ID="<environment_id>"

        $ export IMPORT_FLINK_COMPUTE_POOL_ID="<flink_compute_pool_id>"

        $ export IMPORT_FLINK_API_KEY="<flink_api_key>"

        $ export IMPORT_FLINK_API_SECRET="<flink_api_secret>"

        $ export IMPORT_FLINK_REST_ENDPOINT="<flink_rest_endpoint>"

        $ export IMPORT_FLINK_PRINCIPAL_ID="<flink_principal>"

        $ export API_KEY="<API_KEY>"

        ```sh
        $ pulumi import confluentcloud:index/flinkConnection:FlinkConnection example org-xyz123/env-abc123/connection1
        ```

        Option #2: Manage a single Flink Compute Pool in the same Pulumi Stack

        $ export API_KEY="<API_KEY>"

        ```sh
        $ pulumi import confluentcloud:index/flinkConnection:FlinkConnection example org-xyz123/env-abc123/connection1
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param FlinkConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlinkConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_session_token: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_pool: Optional[pulumi.Input[Union['FlinkConnectionComputePoolArgs', 'FlinkConnectionComputePoolArgsDict']]] = None,
                 credentials: Optional[pulumi.Input[Union['FlinkConnectionCredentialsArgs', 'FlinkConnectionCredentialsArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[Union['FlinkConnectionEnvironmentArgs', 'FlinkConnectionEnvironmentArgsDict']]] = None,
                 organization: Optional[pulumi.Input[Union['FlinkConnectionOrganizationArgs', 'FlinkConnectionOrganizationArgsDict']]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 principal: Optional[pulumi.Input[Union['FlinkConnectionPrincipalArgs', 'FlinkConnectionPrincipalArgsDict']]] = None,
                 rest_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 service_key: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlinkConnectionArgs.__new__(FlinkConnectionArgs)

            __props__.__dict__["api_key"] = api_key
            __props__.__dict__["aws_access_key"] = aws_access_key
            __props__.__dict__["aws_secret_key"] = aws_secret_key
            __props__.__dict__["aws_session_token"] = aws_session_token
            __props__.__dict__["compute_pool"] = compute_pool
            __props__.__dict__["credentials"] = None if credentials is None else pulumi.Output.secret(credentials)
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint'")
            __props__.__dict__["endpoint"] = endpoint
            __props__.__dict__["environment"] = environment
            __props__.__dict__["organization"] = organization
            __props__.__dict__["password"] = password
            __props__.__dict__["principal"] = principal
            __props__.__dict__["rest_endpoint"] = rest_endpoint
            __props__.__dict__["service_key"] = service_key
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["username"] = username
            __props__.__dict__["api_version"] = None
            __props__.__dict__["kind"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["credentials"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(FlinkConnection, __self__).__init__(
            'confluentcloud:index/flinkConnection:FlinkConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_key: Optional[pulumi.Input[_builtins.str]] = None,
            api_version: Optional[pulumi.Input[_builtins.str]] = None,
            aws_access_key: Optional[pulumi.Input[_builtins.str]] = None,
            aws_secret_key: Optional[pulumi.Input[_builtins.str]] = None,
            aws_session_token: Optional[pulumi.Input[_builtins.str]] = None,
            compute_pool: Optional[pulumi.Input[Union['FlinkConnectionComputePoolArgs', 'FlinkConnectionComputePoolArgsDict']]] = None,
            credentials: Optional[pulumi.Input[Union['FlinkConnectionCredentialsArgs', 'FlinkConnectionCredentialsArgsDict']]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            environment: Optional[pulumi.Input[Union['FlinkConnectionEnvironmentArgs', 'FlinkConnectionEnvironmentArgsDict']]] = None,
            kind: Optional[pulumi.Input[_builtins.str]] = None,
            organization: Optional[pulumi.Input[Union['FlinkConnectionOrganizationArgs', 'FlinkConnectionOrganizationArgsDict']]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            principal: Optional[pulumi.Input[Union['FlinkConnectionPrincipalArgs', 'FlinkConnectionPrincipalArgsDict']]] = None,
            rest_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            service_key: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'FlinkConnection':
        """
        Get an existing FlinkConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_key: API key for the type.
        :param pulumi.Input[_builtins.str] api_version: The schema version of this representation of a resource.
        :param pulumi.Input[_builtins.str] aws_access_key: Access key for the type.
        :param pulumi.Input[_builtins.str] aws_secret_key: Secret key for the type.
        :param pulumi.Input[_builtins.str] aws_session_token: Session token for the type.
        :param pulumi.Input[Union['FlinkConnectionCredentialsArgs', 'FlinkConnectionCredentialsArgsDict']] credentials: The Cluster API Credentials.
        :param pulumi.Input[_builtins.str] display_name: The unique name of the Flink Connection per organization, environment scope.
        :param pulumi.Input[_builtins.str] endpoint: The endpoint of the flink connection.
        :param pulumi.Input[_builtins.str] kind: The object this REST resource represents.
        :param pulumi.Input[_builtins.str] password: Password for the type.
        :param pulumi.Input[_builtins.str] rest_endpoint: The REST endpoint of the Flink Connection cluster, for example, `https://flink.us-east-1.aws.confluent.cloud/sql/v1/organizations/1111aaaa-11aa-11aa-11aa-111111aaaaaa/environments/env-abc123`).
        :param pulumi.Input[_builtins.str] service_key: Service Key for the type.
        :param pulumi.Input[_builtins.str] type: The type of the flink connection.
        :param pulumi.Input[_builtins.str] username: Username for the type.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlinkConnectionState.__new__(_FlinkConnectionState)

        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["api_version"] = api_version
        __props__.__dict__["aws_access_key"] = aws_access_key
        __props__.__dict__["aws_secret_key"] = aws_secret_key
        __props__.__dict__["aws_session_token"] = aws_session_token
        __props__.__dict__["compute_pool"] = compute_pool
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["environment"] = environment
        __props__.__dict__["kind"] = kind
        __props__.__dict__["organization"] = organization
        __props__.__dict__["password"] = password
        __props__.__dict__["principal"] = principal
        __props__.__dict__["rest_endpoint"] = rest_endpoint
        __props__.__dict__["service_key"] = service_key
        __props__.__dict__["type"] = type
        __props__.__dict__["username"] = username
        return FlinkConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        API key for the type.
        """
        return pulumi.get(self, "api_key")

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> pulumi.Output[_builtins.str]:
        """
        The schema version of this representation of a resource.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter(name="awsAccessKey")
    def aws_access_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Access key for the type.
        """
        return pulumi.get(self, "aws_access_key")

    @_builtins.property
    @pulumi.getter(name="awsSecretKey")
    def aws_secret_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Secret key for the type.
        """
        return pulumi.get(self, "aws_secret_key")

    @_builtins.property
    @pulumi.getter(name="awsSessionToken")
    def aws_session_token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Session token for the type.
        """
        return pulumi.get(self, "aws_session_token")

    @_builtins.property
    @pulumi.getter(name="computePool")
    def compute_pool(self) -> pulumi.Output['outputs.FlinkConnectionComputePool']:
        return pulumi.get(self, "compute_pool")

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> pulumi.Output[Optional['outputs.FlinkConnectionCredentials']]:
        """
        The Cluster API Credentials.
        """
        return pulumi.get(self, "credentials")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The unique name of the Flink Connection per organization, environment scope.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The endpoint of the flink connection.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output['outputs.FlinkConnectionEnvironment']:
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> pulumi.Output[_builtins.str]:
        """
        The object this REST resource represents.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Output['outputs.FlinkConnectionOrganization']:
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Password for the type.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def principal(self) -> pulumi.Output['outputs.FlinkConnectionPrincipal']:
        return pulumi.get(self, "principal")

    @_builtins.property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The REST endpoint of the Flink Connection cluster, for example, `https://flink.us-east-1.aws.confluent.cloud/sql/v1/organizations/1111aaaa-11aa-11aa-11aa-111111aaaaaa/environments/env-abc123`).
        """
        return pulumi.get(self, "rest_endpoint")

    @_builtins.property
    @pulumi.getter(name="serviceKey")
    def service_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Service Key for the type.
        """
        return pulumi.get(self, "service_key")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the flink connection.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Username for the type.
        """
        return pulumi.get(self, "username")

