<img src="https://raw.githubusercontent.com/lshpaner/model_metrics/refs/heads/main/assets/mm_logo.svg" width="300" style="border: none; outline: none; box-shadow: none;" oncontextmenu="return false;">

<br> 

[![PyPI](https://img.shields.io/pypi/v/model_metrics)](https://pypi.org/project/model_metrics/)
[![Downloads](https://pepy.tech/badge/model_metrics)](https://pepy.tech/project/model_metrics)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://github.com/lshpaner/model_metrics/blob/main/LICENSE.md)


Welcome to Model Metrics! Model Metrics is a versatile Python library designed to streamline the evaluation and interpretation of machine learning models. It provides a robust framework for generating predictions, computing model metrics, analyzing feature importance, and visualizing results. Whether you're working with SHAP values, model coefficients, confusion matrices, ROC curves, precision-recall plots, and other key performance indicators.

---

## Prerequisites 

Before you install `model_metrics`, ensure your system meets the following requirements:

- `Python`: Version `3.7.4` or higher.

Additionally, `model_metrics` depends on the following packages, which will be automatically installed when you install `model_metrics`:

- `matplotlib`: version `3.5.3` or higher, but capped at `3.10.0`
- `numpy`: version `1.21.6` or higher, but capped at `2.1.0`
- `pandas`: version `1.3.5` or higher, but capped at `2.2.3`
- `plotly`: version `5.18.0` or higher, but capped at `5.24.1`
- `scikit-learn`: version `1.0.2` or higher, but capped at `1.5.2`
- `scipy`: version `1.8` or higher, but capped at `1.14.0`
- `shap`: version `0.41.0` or higher, but capped below `0.46.0`
- `statsmodels`: version `0.12.2` or higher, but capped below `0.14.4`
- `tqdm`: version `4.66.4` or higher, but capped below `4.67.1`


## 💾 Installation

To install `model_metrics`, simply run the following command in your terminal:


```bash
pip install model_metrics
```

## 📄 Official Documentation

https://lshpaner.github.io/model_metrics_docs 


## 🌐 Author's Website

1. [Leonid Shpaner](https://www.leonshpaner.com)

## 🙏 Acknowledgements

Gratitude goes to Dr. Ebrahim Tarshizi for his mentorship during the University of San Diego M.S. Applied Data Science Program, as well as the Shiley-Marcos School of Engineering for its support.

Special thanks to Dr. Alex Bui, and to Panayiotis Petousis, PhD, and Arthur Funnell for their invaluable guidance and their exceptional teamwork in maintaining a strong data science infrastructure at UCLA CTSI. Their leadership and support have helped foster the kind of collaborative environment that makes work like this possible. Additional thanks to all who offered guidance and encouragement throughout the development of this library. This project reflects a shared commitment to knowledge sharing, teamwork, and advancing model evaluation practices.


## ⚖️ License

`model_metrics` is distributed under the MIT License. See [LICENSE](https://github.com/lshpaner/model_metrics/blob/main/LICENSE.md) for more information.


## ⚓ Support

If you have any questions or issues with `model_metrics`, please open an issue on this [GitHub repository](https://github.com/lshpaner/model_metrics).


## 📚 Citing `model_metrics`

If you use `model_metrics` in your research or projects, please consider citing it.


```bibtex

@software{shpaner_2025_14879819,
  author       = {Shpaner, Leonid},
  title        = {Model Metrics},
  month        = feb,
  year         = 2025,
  publisher    = {Zenodo},
  version      = {0.0.4a2},
  doi          = {10.5281/zenodo.14879819},
  url          = {https://doi.org/10.5281/zenodo.14879819}
}
```
