"use strict";
// --------------------------------------------------------------------------------
// This file declares context keys that are used by the CLI to control the
// behavior of CDK apps. Contrary to feature flags (which are defined under
// `features.ts`) these options are not bound to be removed in the next major
// version.
// --------------------------------------------------------------------------------
Object.defineProperty(exports, "__esModule", { value: true });
exports.DISABLE_METADATA_STACK_TRACE = exports.DISABLE_ASSET_STAGING_CONTEXT = exports.DISABLE_VERSION_REPORTING = exports.PATH_METADATA_ENABLE_CONTEXT = void 0;
/**
 * Enables the embedding of the "aws:cdk:path" in CloudFormation template metadata.
 */
exports.PATH_METADATA_ENABLE_CONTEXT = 'aws:cdk:enable-path-metadata';
/**
 * Disable the collection and reporting of version information.
 */
exports.DISABLE_VERSION_REPORTING = 'aws:cdk:disable-version-reporting';
/**
 * If this is set, asset staging is disabled. This means that assets will not be copied to
 * the output directory and will be referenced with absolute source paths.
 */
exports.DISABLE_ASSET_STAGING_CONTEXT = 'aws:cdk:disable-asset-staging';
/**
 * If this context key is set, the CDK will stage assets under the specified
 * directory. Otherwise, assets will not be staged.
 * Omits stack traces from construct metadata entries.
 */
exports.DISABLE_METADATA_STACK_TRACE = 'aws:cdk:disable-stack-trace';
//# sourceMappingURL=data:application/json;base64,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