"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NestedCloudAssemblyArtifact = void 0;
const path = require("path");
const cloud_artifact_1 = require("../cloud-artifact");
const cloud_assembly_1 = require("../cloud-assembly");
/**
 * Asset manifest is a description of a set of assets which need to be built and published
 */
class NestedCloudAssemblyArtifact extends cloud_artifact_1.CloudArtifact {
    constructor(assembly, name, artifact) {
        var _a;
        super(assembly, name, artifact);
        const properties = (this.manifest.properties || {});
        this.directoryName = properties.directoryName;
        this.displayName = (_a = properties.displayName) !== null && _a !== void 0 ? _a : name;
    }
    /**
     * Full path to the nested assembly directory
     */
    get fullPath() {
        return path.join(this.assembly.directory, this.directoryName);
    }
    /**
     * The nested Assembly
     */
    get nestedAssembly() {
        if (!this._nestedAssembly) {
            this._nestedAssembly = new cloud_assembly_1.CloudAssembly(this.fullPath);
        }
        return this._nestedAssembly;
    }
}
exports.NestedCloudAssemblyArtifact = NestedCloudAssemblyArtifact;
//# sourceMappingURL=data:application/json;base64,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