"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnvironmentUtils = exports.UNKNOWN_REGION = exports.UNKNOWN_ACCOUNT = void 0;
/**
 * Parser for the artifact environment field.
 *
 * Account validation is relaxed to allow account aliasing in the future.
 */
const AWS_ENV_REGEX = /aws\:\/\/([a-z0-9A-Z\-\@\.\_]+)\/([a-z\-0-9]+)/;
exports.UNKNOWN_ACCOUNT = 'unknown-account';
exports.UNKNOWN_REGION = 'unknown-region';
class EnvironmentUtils {
    static parse(environment) {
        const env = AWS_ENV_REGEX.exec(environment);
        if (!env) {
            throw new Error(`Unable to parse environment specification "${environment}". ` +
                'Expected format: aws://account/region');
        }
        const [, account, region] = env;
        if (!account || !region) {
            throw new Error(`Invalid environment specification: ${environment}`);
        }
        return { account, region, name: environment };
    }
    /**
     * Build an environment object from an account and region
     */
    static make(account, region) {
        return { account, region, name: this.format(account, region) };
    }
    /**
     * Format an environment string from an account and region
     */
    static format(account, region) {
        return `aws://${account}/${region}`;
    }
}
exports.EnvironmentUtils = EnvironmentUtils;
//# sourceMappingURL=data:application/json;base64,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