"use strict";
// --------------------------------------------------------------------------------
// This file defines context keys that enable certain features that are
// implemented behind a flag in order to preserve backwards compatibility for
// existing apps. When a new app is initialized through `cdk init`, the CLI will
// automatically add enable these features by adding them to the generated
// `cdk.json` file. In the next major release of the CDK, these feature flags
// will be removed and will become the default behavior.
// See https://github.com/aws/aws-cdk-rfcs/blob/master/text/0055-feature-flags.md
// --------------------------------------------------------------------------------
Object.defineProperty(exports, "__esModule", { value: true });
exports.FUTURE_FLAGS = exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = exports.ENABLE_DIFF_NO_FAIL = exports.ENABLE_DIFF_NO_FAIL_CONTEXT = exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = void 0;
/**
 * If this is set, multiple stacks can use the same stack name (e.g. deployed to
 * different environments). This means that the name of the synthesized template
 * file will be based on the construct path and not on the defined `stackName`
 * of the stack.
 *
 * This is a "future flag": the feature is disabled by default for backwards
 * compatibility, but new projects created using `cdk init` will have this
 * enabled through the generated `cdk.json`.
 */
exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = '@aws-cdk/core:enableStackNameDuplicates';
/**
 * IF this is set, `cdk diff` will always exit with 0.
 *
 * Use `cdk diff --fail` to exit with 1 if there's a diff.
 */
exports.ENABLE_DIFF_NO_FAIL_CONTEXT = 'aws-cdk:enableDiffNoFail';
/** @deprecated use `ENABLE_DIFF_NO_FAIL_CONTEXT` */
exports.ENABLE_DIFF_NO_FAIL = exports.ENABLE_DIFF_NO_FAIL_CONTEXT;
/**
 * Switch to new stack synthesis method which enable CI/CD
 */
exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = '@aws-cdk/core:newStyleStackSynthesis';
/**
 * This map includes context keys and values for feature flags that enable
 * capabilities "from the future", which we could not introduce as the default
 * behavior due to backwards compatibility for existing projects.
 *
 * New projects generated through `cdk init` will include these flags in their
 * generated `cdk.json` file.
 *
 * When we release the next major version of the CDK, we will flip the logic of
 * these features and clean up the `cdk.json` generated by `cdk init`.
 *
 * Tests must cover the default (disabled) case and the future (enabled) case.
 */
exports.FUTURE_FLAGS = {
    [exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT]: 'true',
    [exports.ENABLE_DIFF_NO_FAIL_CONTEXT]: 'true',
};
//# sourceMappingURL=data:application/json;base64,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