# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class BlobStorageIntegrationType(str, enum.Enum):
    S_3 = "S3"
    S_3_COMPATIBLE = "S3_COMPATIBLE"
    AZURE_BLOB_STORAGE = "AZURE_BLOB_STORAGE"

    def visit(
        self,
        s_3: typing.Callable[[], T_Result],
        s_3_compatible: typing.Callable[[], T_Result],
        azure_blob_storage: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is BlobStorageIntegrationType.S_3:
            return s_3()
        if self is BlobStorageIntegrationType.S_3_COMPATIBLE:
            return s_3_compatible()
        if self is BlobStorageIntegrationType.AZURE_BLOB_STORAGE:
            return azure_blob_storage()
