# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ....core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from .llm_adapter import LlmAdapter


class UpsertLlmConnectionRequest(pydantic_v1.BaseModel):
    """
    Request to create or update an LLM connection (upsert)
    """

    provider: str = pydantic_v1.Field()
    """
    Provider name (e.g., 'openai', 'my-gateway'). Must be unique in project, used for upserting.
    """

    adapter: LlmAdapter = pydantic_v1.Field()
    """
    The adapter used to interface with the LLM
    """

    secret_key: str = pydantic_v1.Field(alias="secretKey")
    """
    Secret key for the LLM API.
    """

    base_url: typing.Optional[str] = pydantic_v1.Field(alias="baseURL", default=None)
    """
    Custom base URL for the LLM API
    """

    custom_models: typing.Optional[typing.List[str]] = pydantic_v1.Field(
        alias="customModels", default=None
    )
    """
    List of custom model names
    """

    with_default_models: typing.Optional[bool] = pydantic_v1.Field(
        alias="withDefaultModels", default=None
    )
    """
    Whether to include default models. Default is true.
    """

    extra_headers: typing.Optional[typing.Dict[str, str]] = pydantic_v1.Field(
        alias="extraHeaders", default=None
    )
    """
    Extra headers to send with requests
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {
            "by_alias": True,
            "exclude_unset": True,
            **kwargs,
        }
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {
            "by_alias": True,
            "exclude_unset": True,
            **kwargs,
        }
        kwargs_with_defaults_exclude_none: typing.Any = {
            "by_alias": True,
            "exclude_none": True,
            **kwargs,
        }

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset),
            super().dict(**kwargs_with_defaults_exclude_none),
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
