# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OperatorPolicyArgs', 'OperatorPolicy']

@pulumi.input_type
class OperatorPolicyArgs:
    def __init__(__self__, *,
                 policy: pulumi.Input['OperatorPolicyPolicyArgs'],
                 vhost: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a OperatorPolicy resource.
        :param pulumi.Input['OperatorPolicyPolicyArgs'] policy: The settings of the operator policy. The structure is
               described below.
        :param pulumi.Input[str] vhost: The vhost to create the resource in.
        :param pulumi.Input[str] name: The name of the operator policy.
        """
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "vhost", vhost)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Input['OperatorPolicyPolicyArgs']:
        """
        The settings of the operator policy. The structure is
        described below.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: pulumi.Input['OperatorPolicyPolicyArgs']):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter
    def vhost(self) -> pulumi.Input[str]:
        """
        The vhost to create the resource in.
        """
        return pulumi.get(self, "vhost")

    @vhost.setter
    def vhost(self, value: pulumi.Input[str]):
        pulumi.set(self, "vhost", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the operator policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _OperatorPolicyState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input['OperatorPolicyPolicyArgs']] = None,
                 vhost: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OperatorPolicy resources.
        :param pulumi.Input[str] name: The name of the operator policy.
        :param pulumi.Input['OperatorPolicyPolicyArgs'] policy: The settings of the operator policy. The structure is
               described below.
        :param pulumi.Input[str] vhost: The vhost to create the resource in.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if vhost is not None:
            pulumi.set(__self__, "vhost", vhost)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the operator policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input['OperatorPolicyPolicyArgs']]:
        """
        The settings of the operator policy. The structure is
        described below.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input['OperatorPolicyPolicyArgs']]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter
    def vhost(self) -> Optional[pulumi.Input[str]]:
        """
        The vhost to create the resource in.
        """
        return pulumi.get(self, "vhost")

    @vhost.setter
    def vhost(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vhost", value)


class OperatorPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[pulumi.InputType['OperatorPolicyPolicyArgs']]] = None,
                 vhost: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The ``OperatorPolicy`` resource creates and manages operator policies for queues.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_rabbitmq as rabbitmq

        test_v_host = rabbitmq.VHost("testVHost")
        guest = rabbitmq.Permissions("guest",
            permissions=rabbitmq.PermissionsPermissionsArgs(
                configure=".*",
                read=".*",
                write=".*",
            ),
            user="guest",
            vhost=test_v_host.name)
        test_operator_policy = rabbitmq.OperatorPolicy("testOperatorPolicy",
            policy=rabbitmq.OperatorPolicyPolicyArgs(
                apply_to="queues",
                definition={
                    "expires": 1800000,
                    "message-ttl": 3600000,
                },
                pattern=".*",
                priority=0,
            ),
            vhost=guest.vhost)
        ```

        ## Import

        Operator policies can be imported using the `id` which is composed of `name@vhost`. E.g.

        ```sh
         $ pulumi import rabbitmq:index/operatorPolicy:OperatorPolicy test name@vhost
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name of the operator policy.
        :param pulumi.Input[pulumi.InputType['OperatorPolicyPolicyArgs']] policy: The settings of the operator policy. The structure is
               described below.
        :param pulumi.Input[str] vhost: The vhost to create the resource in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OperatorPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The ``OperatorPolicy`` resource creates and manages operator policies for queues.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_rabbitmq as rabbitmq

        test_v_host = rabbitmq.VHost("testVHost")
        guest = rabbitmq.Permissions("guest",
            permissions=rabbitmq.PermissionsPermissionsArgs(
                configure=".*",
                read=".*",
                write=".*",
            ),
            user="guest",
            vhost=test_v_host.name)
        test_operator_policy = rabbitmq.OperatorPolicy("testOperatorPolicy",
            policy=rabbitmq.OperatorPolicyPolicyArgs(
                apply_to="queues",
                definition={
                    "expires": 1800000,
                    "message-ttl": 3600000,
                },
                pattern=".*",
                priority=0,
            ),
            vhost=guest.vhost)
        ```

        ## Import

        Operator policies can be imported using the `id` which is composed of `name@vhost`. E.g.

        ```sh
         $ pulumi import rabbitmq:index/operatorPolicy:OperatorPolicy test name@vhost
        ```

        :param str resource_name: The name of the resource.
        :param OperatorPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OperatorPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[pulumi.InputType['OperatorPolicyPolicyArgs']]] = None,
                 vhost: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OperatorPolicyArgs.__new__(OperatorPolicyArgs)

            __props__.__dict__["name"] = name
            if policy is None and not opts.urn:
                raise TypeError("Missing required property 'policy'")
            __props__.__dict__["policy"] = policy
            if vhost is None and not opts.urn:
                raise TypeError("Missing required property 'vhost'")
            __props__.__dict__["vhost"] = vhost
        super(OperatorPolicy, __self__).__init__(
            'rabbitmq:index/operatorPolicy:OperatorPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[str]] = None,
            policy: Optional[pulumi.Input[pulumi.InputType['OperatorPolicyPolicyArgs']]] = None,
            vhost: Optional[pulumi.Input[str]] = None) -> 'OperatorPolicy':
        """
        Get an existing OperatorPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name of the operator policy.
        :param pulumi.Input[pulumi.InputType['OperatorPolicyPolicyArgs']] policy: The settings of the operator policy. The structure is
               described below.
        :param pulumi.Input[str] vhost: The vhost to create the resource in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OperatorPolicyState.__new__(_OperatorPolicyState)

        __props__.__dict__["name"] = name
        __props__.__dict__["policy"] = policy
        __props__.__dict__["vhost"] = vhost
        return OperatorPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the operator policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Output['outputs.OperatorPolicyPolicy']:
        """
        The settings of the operator policy. The structure is
        described below.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def vhost(self) -> pulumi.Output[str]:
        """
        The vhost to create the resource in.
        """
        return pulumi.get(self, "vhost")

