# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BranchProtectionArgs', 'BranchProtection']

@pulumi.input_type
class BranchProtectionArgs:
    def __init__(__self__, *,
                 branch: pulumi.Input[_builtins.str],
                 project: pulumi.Input[_builtins.str],
                 allow_force_push: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_to_merges: Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionAllowedToMergeArgs']]]] = None,
                 allowed_to_pushes: Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionAllowedToPushArgs']]]] = None,
                 allowed_to_unprotects: Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionAllowedToUnprotectArgs']]]] = None,
                 code_owner_approval_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 merge_access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 push_access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 unprotect_access_level: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BranchProtection resource.
        :param pulumi.Input[_builtins.str] branch: Name of the branch.
        :param pulumi.Input[_builtins.str] project: The id of the project.
        :param pulumi.Input[_builtins.bool] allow_force_push: Can be set to true to allow users with push access to force push.
        :param pulumi.Input[Sequence[pulumi.Input['BranchProtectionAllowedToMergeArgs']]] allowed_to_merges: Array of access levels and user(s)/group(s) allowed to merge to protected branch.
        :param pulumi.Input[Sequence[pulumi.Input['BranchProtectionAllowedToPushArgs']]] allowed_to_pushes: Array of access levels and user(s)/group(s) allowed to push to protected branch.
        :param pulumi.Input[Sequence[pulumi.Input['BranchProtectionAllowedToUnprotectArgs']]] allowed_to_unprotects: Array of access levels and user(s)/group(s) allowed to unprotect push to protected branch.
        :param pulumi.Input[_builtins.bool] code_owner_approval_required: Can be set to true to require code owner approval before merging. Only available for Premium and Ultimate instances.
        :param pulumi.Input[_builtins.str] merge_access_level: Access levels allowed to merge. Valid values are: `no one`, `developer`, `maintainer`, `admin`.
        :param pulumi.Input[_builtins.str] push_access_level: Access levels allowed to push. Valid values are: `no one`, `developer`, `maintainer`, `admin`.
        :param pulumi.Input[_builtins.str] unprotect_access_level: Access levels allowed to unprotect. Valid values are: `developer`, `maintainer`, `admin`.
        """
        pulumi.set(__self__, "branch", branch)
        pulumi.set(__self__, "project", project)
        if allow_force_push is not None:
            pulumi.set(__self__, "allow_force_push", allow_force_push)
        if allowed_to_merges is not None:
            pulumi.set(__self__, "allowed_to_merges", allowed_to_merges)
        if allowed_to_pushes is not None:
            pulumi.set(__self__, "allowed_to_pushes", allowed_to_pushes)
        if allowed_to_unprotects is not None:
            pulumi.set(__self__, "allowed_to_unprotects", allowed_to_unprotects)
        if code_owner_approval_required is not None:
            pulumi.set(__self__, "code_owner_approval_required", code_owner_approval_required)
        if merge_access_level is not None:
            pulumi.set(__self__, "merge_access_level", merge_access_level)
        if push_access_level is not None:
            pulumi.set(__self__, "push_access_level", push_access_level)
        if unprotect_access_level is not None:
            pulumi.set(__self__, "unprotect_access_level", unprotect_access_level)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the branch.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "branch", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="allowForcePush")
    def allow_force_push(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Can be set to true to allow users with push access to force push.
        """
        return pulumi.get(self, "allow_force_push")

    @allow_force_push.setter
    def allow_force_push(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_force_push", value)

    @_builtins.property
    @pulumi.getter(name="allowedToMerges")
    def allowed_to_merges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionAllowedToMergeArgs']]]]:
        """
        Array of access levels and user(s)/group(s) allowed to merge to protected branch.
        """
        return pulumi.get(self, "allowed_to_merges")

    @allowed_to_merges.setter
    def allowed_to_merges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionAllowedToMergeArgs']]]]):
        pulumi.set(self, "allowed_to_merges", value)

    @_builtins.property
    @pulumi.getter(name="allowedToPushes")
    def allowed_to_pushes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionAllowedToPushArgs']]]]:
        """
        Array of access levels and user(s)/group(s) allowed to push to protected branch.
        """
        return pulumi.get(self, "allowed_to_pushes")

    @allowed_to_pushes.setter
    def allowed_to_pushes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionAllowedToPushArgs']]]]):
        pulumi.set(self, "allowed_to_pushes", value)

    @_builtins.property
    @pulumi.getter(name="allowedToUnprotects")
    def allowed_to_unprotects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionAllowedToUnprotectArgs']]]]:
        """
        Array of access levels and user(s)/group(s) allowed to unprotect push to protected branch.
        """
        return pulumi.get(self, "allowed_to_unprotects")

    @allowed_to_unprotects.setter
    def allowed_to_unprotects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionAllowedToUnprotectArgs']]]]):
        pulumi.set(self, "allowed_to_unprotects", value)

    @_builtins.property
    @pulumi.getter(name="codeOwnerApprovalRequired")
    def code_owner_approval_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Can be set to true to require code owner approval before merging. Only available for Premium and Ultimate instances.
        """
        return pulumi.get(self, "code_owner_approval_required")

    @code_owner_approval_required.setter
    def code_owner_approval_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "code_owner_approval_required", value)

    @_builtins.property
    @pulumi.getter(name="mergeAccessLevel")
    def merge_access_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access levels allowed to merge. Valid values are: `no one`, `developer`, `maintainer`, `admin`.
        """
        return pulumi.get(self, "merge_access_level")

    @merge_access_level.setter
    def merge_access_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "merge_access_level", value)

    @_builtins.property
    @pulumi.getter(name="pushAccessLevel")
    def push_access_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access levels allowed to push. Valid values are: `no one`, `developer`, `maintainer`, `admin`.
        """
        return pulumi.get(self, "push_access_level")

    @push_access_level.setter
    def push_access_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "push_access_level", value)

    @_builtins.property
    @pulumi.getter(name="unprotectAccessLevel")
    def unprotect_access_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access levels allowed to unprotect. Valid values are: `developer`, `maintainer`, `admin`.
        """
        return pulumi.get(self, "unprotect_access_level")

    @unprotect_access_level.setter
    def unprotect_access_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unprotect_access_level", value)


@pulumi.input_type
class _BranchProtectionState:
    def __init__(__self__, *,
                 allow_force_push: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_to_merges: Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionAllowedToMergeArgs']]]] = None,
                 allowed_to_pushes: Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionAllowedToPushArgs']]]] = None,
                 allowed_to_unprotects: Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionAllowedToUnprotectArgs']]]] = None,
                 branch: Optional[pulumi.Input[_builtins.str]] = None,
                 branch_protection_id: Optional[pulumi.Input[_builtins.int]] = None,
                 code_owner_approval_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 merge_access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 push_access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 unprotect_access_level: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BranchProtection resources.
        :param pulumi.Input[_builtins.bool] allow_force_push: Can be set to true to allow users with push access to force push.
        :param pulumi.Input[Sequence[pulumi.Input['BranchProtectionAllowedToMergeArgs']]] allowed_to_merges: Array of access levels and user(s)/group(s) allowed to merge to protected branch.
        :param pulumi.Input[Sequence[pulumi.Input['BranchProtectionAllowedToPushArgs']]] allowed_to_pushes: Array of access levels and user(s)/group(s) allowed to push to protected branch.
        :param pulumi.Input[Sequence[pulumi.Input['BranchProtectionAllowedToUnprotectArgs']]] allowed_to_unprotects: Array of access levels and user(s)/group(s) allowed to unprotect push to protected branch.
        :param pulumi.Input[_builtins.str] branch: Name of the branch.
        :param pulumi.Input[_builtins.int] branch_protection_id: The ID of the branch protection (not the branch name).
        :param pulumi.Input[_builtins.bool] code_owner_approval_required: Can be set to true to require code owner approval before merging. Only available for Premium and Ultimate instances.
        :param pulumi.Input[_builtins.str] merge_access_level: Access levels allowed to merge. Valid values are: `no one`, `developer`, `maintainer`, `admin`.
        :param pulumi.Input[_builtins.str] project: The id of the project.
        :param pulumi.Input[_builtins.str] push_access_level: Access levels allowed to push. Valid values are: `no one`, `developer`, `maintainer`, `admin`.
        :param pulumi.Input[_builtins.str] unprotect_access_level: Access levels allowed to unprotect. Valid values are: `developer`, `maintainer`, `admin`.
        """
        if allow_force_push is not None:
            pulumi.set(__self__, "allow_force_push", allow_force_push)
        if allowed_to_merges is not None:
            pulumi.set(__self__, "allowed_to_merges", allowed_to_merges)
        if allowed_to_pushes is not None:
            pulumi.set(__self__, "allowed_to_pushes", allowed_to_pushes)
        if allowed_to_unprotects is not None:
            pulumi.set(__self__, "allowed_to_unprotects", allowed_to_unprotects)
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if branch_protection_id is not None:
            pulumi.set(__self__, "branch_protection_id", branch_protection_id)
        if code_owner_approval_required is not None:
            pulumi.set(__self__, "code_owner_approval_required", code_owner_approval_required)
        if merge_access_level is not None:
            pulumi.set(__self__, "merge_access_level", merge_access_level)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if push_access_level is not None:
            pulumi.set(__self__, "push_access_level", push_access_level)
        if unprotect_access_level is not None:
            pulumi.set(__self__, "unprotect_access_level", unprotect_access_level)

    @_builtins.property
    @pulumi.getter(name="allowForcePush")
    def allow_force_push(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Can be set to true to allow users with push access to force push.
        """
        return pulumi.get(self, "allow_force_push")

    @allow_force_push.setter
    def allow_force_push(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_force_push", value)

    @_builtins.property
    @pulumi.getter(name="allowedToMerges")
    def allowed_to_merges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionAllowedToMergeArgs']]]]:
        """
        Array of access levels and user(s)/group(s) allowed to merge to protected branch.
        """
        return pulumi.get(self, "allowed_to_merges")

    @allowed_to_merges.setter
    def allowed_to_merges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionAllowedToMergeArgs']]]]):
        pulumi.set(self, "allowed_to_merges", value)

    @_builtins.property
    @pulumi.getter(name="allowedToPushes")
    def allowed_to_pushes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionAllowedToPushArgs']]]]:
        """
        Array of access levels and user(s)/group(s) allowed to push to protected branch.
        """
        return pulumi.get(self, "allowed_to_pushes")

    @allowed_to_pushes.setter
    def allowed_to_pushes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionAllowedToPushArgs']]]]):
        pulumi.set(self, "allowed_to_pushes", value)

    @_builtins.property
    @pulumi.getter(name="allowedToUnprotects")
    def allowed_to_unprotects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionAllowedToUnprotectArgs']]]]:
        """
        Array of access levels and user(s)/group(s) allowed to unprotect push to protected branch.
        """
        return pulumi.get(self, "allowed_to_unprotects")

    @allowed_to_unprotects.setter
    def allowed_to_unprotects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionAllowedToUnprotectArgs']]]]):
        pulumi.set(self, "allowed_to_unprotects", value)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the branch.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "branch", value)

    @_builtins.property
    @pulumi.getter(name="branchProtectionId")
    def branch_protection_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the branch protection (not the branch name).
        """
        return pulumi.get(self, "branch_protection_id")

    @branch_protection_id.setter
    def branch_protection_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "branch_protection_id", value)

    @_builtins.property
    @pulumi.getter(name="codeOwnerApprovalRequired")
    def code_owner_approval_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Can be set to true to require code owner approval before merging. Only available for Premium and Ultimate instances.
        """
        return pulumi.get(self, "code_owner_approval_required")

    @code_owner_approval_required.setter
    def code_owner_approval_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "code_owner_approval_required", value)

    @_builtins.property
    @pulumi.getter(name="mergeAccessLevel")
    def merge_access_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access levels allowed to merge. Valid values are: `no one`, `developer`, `maintainer`, `admin`.
        """
        return pulumi.get(self, "merge_access_level")

    @merge_access_level.setter
    def merge_access_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "merge_access_level", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pushAccessLevel")
    def push_access_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access levels allowed to push. Valid values are: `no one`, `developer`, `maintainer`, `admin`.
        """
        return pulumi.get(self, "push_access_level")

    @push_access_level.setter
    def push_access_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "push_access_level", value)

    @_builtins.property
    @pulumi.getter(name="unprotectAccessLevel")
    def unprotect_access_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access levels allowed to unprotect. Valid values are: `developer`, `maintainer`, `admin`.
        """
        return pulumi.get(self, "unprotect_access_level")

    @unprotect_access_level.setter
    def unprotect_access_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unprotect_access_level", value)


@pulumi.type_token("gitlab:index/branchProtection:BranchProtection")
class BranchProtection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_force_push: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_to_merges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionAllowedToMergeArgs', 'BranchProtectionAllowedToMergeArgsDict']]]]] = None,
                 allowed_to_pushes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionAllowedToPushArgs', 'BranchProtectionAllowedToPushArgsDict']]]]] = None,
                 allowed_to_unprotects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionAllowedToUnprotectArgs', 'BranchProtectionAllowedToUnprotectArgsDict']]]]] = None,
                 branch: Optional[pulumi.Input[_builtins.str]] = None,
                 code_owner_approval_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 merge_access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 push_access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 unprotect_access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        branch_protect = gitlab.BranchProtection("BranchProtect",
            project="12345",
            branch="BranchProtected",
            push_access_level="developer",
            merge_access_level="developer",
            unprotect_access_level="developer",
            allow_force_push=True,
            code_owner_approval_required=True,
            allowed_to_pushes=[
                {
                    "user_id": 5,
                },
                {
                    "user_id": 521,
                },
            ],
            allowed_to_merges=[
                {
                    "user_id": 15,
                },
                {
                    "user_id": 37,
                },
            ],
            allowed_to_unprotects=[
                {
                    "user_id": 15,
                },
                {
                    "group_id": 42,
                },
            ])
        # Example using dynamic block
        main = gitlab.BranchProtection("main",
            allowed_to_pushes=[{
                "user_id": entry["value"],
            } for entry in [{"key": k, "value": v} for k, v in [
                50,
                55,
                60,
            ]]],
            project="12345",
            branch="main",
            push_access_level="maintainer",
            merge_access_level="maintainer",
            unprotect_access_level="maintainer")
        # Example with admin push access level
        admin_push = gitlab.BranchProtection("admin_push",
            project="12345",
            branch="admin-protected",
            push_access_level="admin",
            merge_access_level="maintainer",
            unprotect_access_level="maintainer")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_branch_protection`. For example:

        terraform

        import {

          to = gitlab_branch_protection.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        Gitlab protected branches can be imported with a key composed of `<project_id>:<branch>`, e.g.

        ```sh
        $ pulumi import gitlab:index/branchProtection:BranchProtection BranchProtect "12345:main"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_force_push: Can be set to true to allow users with push access to force push.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionAllowedToMergeArgs', 'BranchProtectionAllowedToMergeArgsDict']]]] allowed_to_merges: Array of access levels and user(s)/group(s) allowed to merge to protected branch.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionAllowedToPushArgs', 'BranchProtectionAllowedToPushArgsDict']]]] allowed_to_pushes: Array of access levels and user(s)/group(s) allowed to push to protected branch.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionAllowedToUnprotectArgs', 'BranchProtectionAllowedToUnprotectArgsDict']]]] allowed_to_unprotects: Array of access levels and user(s)/group(s) allowed to unprotect push to protected branch.
        :param pulumi.Input[_builtins.str] branch: Name of the branch.
        :param pulumi.Input[_builtins.bool] code_owner_approval_required: Can be set to true to require code owner approval before merging. Only available for Premium and Ultimate instances.
        :param pulumi.Input[_builtins.str] merge_access_level: Access levels allowed to merge. Valid values are: `no one`, `developer`, `maintainer`, `admin`.
        :param pulumi.Input[_builtins.str] project: The id of the project.
        :param pulumi.Input[_builtins.str] push_access_level: Access levels allowed to push. Valid values are: `no one`, `developer`, `maintainer`, `admin`.
        :param pulumi.Input[_builtins.str] unprotect_access_level: Access levels allowed to unprotect. Valid values are: `developer`, `maintainer`, `admin`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BranchProtectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        branch_protect = gitlab.BranchProtection("BranchProtect",
            project="12345",
            branch="BranchProtected",
            push_access_level="developer",
            merge_access_level="developer",
            unprotect_access_level="developer",
            allow_force_push=True,
            code_owner_approval_required=True,
            allowed_to_pushes=[
                {
                    "user_id": 5,
                },
                {
                    "user_id": 521,
                },
            ],
            allowed_to_merges=[
                {
                    "user_id": 15,
                },
                {
                    "user_id": 37,
                },
            ],
            allowed_to_unprotects=[
                {
                    "user_id": 15,
                },
                {
                    "group_id": 42,
                },
            ])
        # Example using dynamic block
        main = gitlab.BranchProtection("main",
            allowed_to_pushes=[{
                "user_id": entry["value"],
            } for entry in [{"key": k, "value": v} for k, v in [
                50,
                55,
                60,
            ]]],
            project="12345",
            branch="main",
            push_access_level="maintainer",
            merge_access_level="maintainer",
            unprotect_access_level="maintainer")
        # Example with admin push access level
        admin_push = gitlab.BranchProtection("admin_push",
            project="12345",
            branch="admin-protected",
            push_access_level="admin",
            merge_access_level="maintainer",
            unprotect_access_level="maintainer")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_branch_protection`. For example:

        terraform

        import {

          to = gitlab_branch_protection.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        Gitlab protected branches can be imported with a key composed of `<project_id>:<branch>`, e.g.

        ```sh
        $ pulumi import gitlab:index/branchProtection:BranchProtection BranchProtect "12345:main"
        ```

        :param str resource_name: The name of the resource.
        :param BranchProtectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BranchProtectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_force_push: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_to_merges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionAllowedToMergeArgs', 'BranchProtectionAllowedToMergeArgsDict']]]]] = None,
                 allowed_to_pushes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionAllowedToPushArgs', 'BranchProtectionAllowedToPushArgsDict']]]]] = None,
                 allowed_to_unprotects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionAllowedToUnprotectArgs', 'BranchProtectionAllowedToUnprotectArgsDict']]]]] = None,
                 branch: Optional[pulumi.Input[_builtins.str]] = None,
                 code_owner_approval_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 merge_access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 push_access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 unprotect_access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BranchProtectionArgs.__new__(BranchProtectionArgs)

            __props__.__dict__["allow_force_push"] = allow_force_push
            __props__.__dict__["allowed_to_merges"] = allowed_to_merges
            __props__.__dict__["allowed_to_pushes"] = allowed_to_pushes
            __props__.__dict__["allowed_to_unprotects"] = allowed_to_unprotects
            if branch is None and not opts.urn:
                raise TypeError("Missing required property 'branch'")
            __props__.__dict__["branch"] = branch
            __props__.__dict__["code_owner_approval_required"] = code_owner_approval_required
            __props__.__dict__["merge_access_level"] = merge_access_level
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["push_access_level"] = push_access_level
            __props__.__dict__["unprotect_access_level"] = unprotect_access_level
            __props__.__dict__["branch_protection_id"] = None
        super(BranchProtection, __self__).__init__(
            'gitlab:index/branchProtection:BranchProtection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_force_push: Optional[pulumi.Input[_builtins.bool]] = None,
            allowed_to_merges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionAllowedToMergeArgs', 'BranchProtectionAllowedToMergeArgsDict']]]]] = None,
            allowed_to_pushes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionAllowedToPushArgs', 'BranchProtectionAllowedToPushArgsDict']]]]] = None,
            allowed_to_unprotects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionAllowedToUnprotectArgs', 'BranchProtectionAllowedToUnprotectArgsDict']]]]] = None,
            branch: Optional[pulumi.Input[_builtins.str]] = None,
            branch_protection_id: Optional[pulumi.Input[_builtins.int]] = None,
            code_owner_approval_required: Optional[pulumi.Input[_builtins.bool]] = None,
            merge_access_level: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            push_access_level: Optional[pulumi.Input[_builtins.str]] = None,
            unprotect_access_level: Optional[pulumi.Input[_builtins.str]] = None) -> 'BranchProtection':
        """
        Get an existing BranchProtection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_force_push: Can be set to true to allow users with push access to force push.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionAllowedToMergeArgs', 'BranchProtectionAllowedToMergeArgsDict']]]] allowed_to_merges: Array of access levels and user(s)/group(s) allowed to merge to protected branch.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionAllowedToPushArgs', 'BranchProtectionAllowedToPushArgsDict']]]] allowed_to_pushes: Array of access levels and user(s)/group(s) allowed to push to protected branch.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionAllowedToUnprotectArgs', 'BranchProtectionAllowedToUnprotectArgsDict']]]] allowed_to_unprotects: Array of access levels and user(s)/group(s) allowed to unprotect push to protected branch.
        :param pulumi.Input[_builtins.str] branch: Name of the branch.
        :param pulumi.Input[_builtins.int] branch_protection_id: The ID of the branch protection (not the branch name).
        :param pulumi.Input[_builtins.bool] code_owner_approval_required: Can be set to true to require code owner approval before merging. Only available for Premium and Ultimate instances.
        :param pulumi.Input[_builtins.str] merge_access_level: Access levels allowed to merge. Valid values are: `no one`, `developer`, `maintainer`, `admin`.
        :param pulumi.Input[_builtins.str] project: The id of the project.
        :param pulumi.Input[_builtins.str] push_access_level: Access levels allowed to push. Valid values are: `no one`, `developer`, `maintainer`, `admin`.
        :param pulumi.Input[_builtins.str] unprotect_access_level: Access levels allowed to unprotect. Valid values are: `developer`, `maintainer`, `admin`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BranchProtectionState.__new__(_BranchProtectionState)

        __props__.__dict__["allow_force_push"] = allow_force_push
        __props__.__dict__["allowed_to_merges"] = allowed_to_merges
        __props__.__dict__["allowed_to_pushes"] = allowed_to_pushes
        __props__.__dict__["allowed_to_unprotects"] = allowed_to_unprotects
        __props__.__dict__["branch"] = branch
        __props__.__dict__["branch_protection_id"] = branch_protection_id
        __props__.__dict__["code_owner_approval_required"] = code_owner_approval_required
        __props__.__dict__["merge_access_level"] = merge_access_level
        __props__.__dict__["project"] = project
        __props__.__dict__["push_access_level"] = push_access_level
        __props__.__dict__["unprotect_access_level"] = unprotect_access_level
        return BranchProtection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowForcePush")
    def allow_force_push(self) -> pulumi.Output[_builtins.bool]:
        """
        Can be set to true to allow users with push access to force push.
        """
        return pulumi.get(self, "allow_force_push")

    @_builtins.property
    @pulumi.getter(name="allowedToMerges")
    def allowed_to_merges(self) -> pulumi.Output[Optional[Sequence['outputs.BranchProtectionAllowedToMerge']]]:
        """
        Array of access levels and user(s)/group(s) allowed to merge to protected branch.
        """
        return pulumi.get(self, "allowed_to_merges")

    @_builtins.property
    @pulumi.getter(name="allowedToPushes")
    def allowed_to_pushes(self) -> pulumi.Output[Optional[Sequence['outputs.BranchProtectionAllowedToPush']]]:
        """
        Array of access levels and user(s)/group(s) allowed to push to protected branch.
        """
        return pulumi.get(self, "allowed_to_pushes")

    @_builtins.property
    @pulumi.getter(name="allowedToUnprotects")
    def allowed_to_unprotects(self) -> pulumi.Output[Optional[Sequence['outputs.BranchProtectionAllowedToUnprotect']]]:
        """
        Array of access levels and user(s)/group(s) allowed to unprotect push to protected branch.
        """
        return pulumi.get(self, "allowed_to_unprotects")

    @_builtins.property
    @pulumi.getter
    def branch(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the branch.
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter(name="branchProtectionId")
    def branch_protection_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the branch protection (not the branch name).
        """
        return pulumi.get(self, "branch_protection_id")

    @_builtins.property
    @pulumi.getter(name="codeOwnerApprovalRequired")
    def code_owner_approval_required(self) -> pulumi.Output[_builtins.bool]:
        """
        Can be set to true to require code owner approval before merging. Only available for Premium and Ultimate instances.
        """
        return pulumi.get(self, "code_owner_approval_required")

    @_builtins.property
    @pulumi.getter(name="mergeAccessLevel")
    def merge_access_level(self) -> pulumi.Output[_builtins.str]:
        """
        Access levels allowed to merge. Valid values are: `no one`, `developer`, `maintainer`, `admin`.
        """
        return pulumi.get(self, "merge_access_level")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the project.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pushAccessLevel")
    def push_access_level(self) -> pulumi.Output[_builtins.str]:
        """
        Access levels allowed to push. Valid values are: `no one`, `developer`, `maintainer`, `admin`.
        """
        return pulumi.get(self, "push_access_level")

    @_builtins.property
    @pulumi.getter(name="unprotectAccessLevel")
    def unprotect_access_level(self) -> pulumi.Output[_builtins.str]:
        """
        Access levels allowed to unprotect. Valid values are: `developer`, `maintainer`, `admin`.
        """
        return pulumi.get(self, "unprotect_access_level")

