# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['MemberRoleArgs', 'MemberRole']

@pulumi.input_type
class MemberRoleArgs:
    def __init__(__self__, *,
                 base_access_level: pulumi.Input[_builtins.str],
                 enabled_permissions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 group_path: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MemberRole resource.
        :param pulumi.Input[_builtins.str] base_access_level: The base access level for the custom role. Valid values are: `DEVELOPER`, `GUEST`, `MAINTAINER`, `MINIMAL_ACCESS`, `OWNER`, `REPORTER`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_permissions: All permissions enabled for the custom role. Valid values are: `ADMIN_CICD_VARIABLES`, `ADMIN_COMPLIANCE_FRAMEWORK`, `ADMIN_GROUP_MEMBER`, `ADMIN_INTEGRATIONS`, `ADMIN_MERGE_REQUEST`, `ADMIN_PROTECTED_BRANCH`, `ADMIN_PUSH_RULES`, `ADMIN_RUNNERS`, `ADMIN_TERRAFORM_STATE`, `ADMIN_VULNERABILITY`, `ADMIN_WEB_HOOK`, `ARCHIVE_PROJECT`, `MANAGE_DEPLOY_TOKENS`, `MANAGE_GROUP_ACCESS_TOKENS`, `MANAGE_MERGE_REQUEST_SETTINGS`, `MANAGE_PROJECT_ACCESS_TOKENS`, `MANAGE_SECURITY_POLICY_LINK`, `READ_ADMIN_CICD`, `READ_ADMIN_DASHBOARD`, `READ_CODE`, `READ_COMPLIANCE_DASHBOARD`, `READ_CRM_CONTACT`, `READ_DEPENDENCY`, `READ_RUNNERS`, `READ_VULNERABILITY`, `REMOVE_GROUP`, `REMOVE_PROJECT`
        :param pulumi.Input[_builtins.str] description: Description for the member role.
        :param pulumi.Input[_builtins.str] group_path: Full path of the namespace to create the member role in. **Required for SAAS** **Not allowed for self-managed**
        :param pulumi.Input[_builtins.str] name: Name for the member role.
        """
        pulumi.set(__self__, "base_access_level", base_access_level)
        pulumi.set(__self__, "enabled_permissions", enabled_permissions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if group_path is not None:
            pulumi.set(__self__, "group_path", group_path)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="baseAccessLevel")
    def base_access_level(self) -> pulumi.Input[_builtins.str]:
        """
        The base access level for the custom role. Valid values are: `DEVELOPER`, `GUEST`, `MAINTAINER`, `MINIMAL_ACCESS`, `OWNER`, `REPORTER`
        """
        return pulumi.get(self, "base_access_level")

    @base_access_level.setter
    def base_access_level(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "base_access_level", value)

    @_builtins.property
    @pulumi.getter(name="enabledPermissions")
    def enabled_permissions(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        All permissions enabled for the custom role. Valid values are: `ADMIN_CICD_VARIABLES`, `ADMIN_COMPLIANCE_FRAMEWORK`, `ADMIN_GROUP_MEMBER`, `ADMIN_INTEGRATIONS`, `ADMIN_MERGE_REQUEST`, `ADMIN_PROTECTED_BRANCH`, `ADMIN_PUSH_RULES`, `ADMIN_RUNNERS`, `ADMIN_TERRAFORM_STATE`, `ADMIN_VULNERABILITY`, `ADMIN_WEB_HOOK`, `ARCHIVE_PROJECT`, `MANAGE_DEPLOY_TOKENS`, `MANAGE_GROUP_ACCESS_TOKENS`, `MANAGE_MERGE_REQUEST_SETTINGS`, `MANAGE_PROJECT_ACCESS_TOKENS`, `MANAGE_SECURITY_POLICY_LINK`, `READ_ADMIN_CICD`, `READ_ADMIN_DASHBOARD`, `READ_CODE`, `READ_COMPLIANCE_DASHBOARD`, `READ_CRM_CONTACT`, `READ_DEPENDENCY`, `READ_RUNNERS`, `READ_VULNERABILITY`, `REMOVE_GROUP`, `REMOVE_PROJECT`
        """
        return pulumi.get(self, "enabled_permissions")

    @enabled_permissions.setter
    def enabled_permissions(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "enabled_permissions", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the member role.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="groupPath")
    def group_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full path of the namespace to create the member role in. **Required for SAAS** **Not allowed for self-managed**
        """
        return pulumi.get(self, "group_path")

    @group_path.setter
    def group_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_path", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name for the member role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _MemberRoleState:
    def __init__(__self__, *,
                 base_access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 edit_path: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 group_path: Optional[pulumi.Input[_builtins.str]] = None,
                 iid: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MemberRole resources.
        :param pulumi.Input[_builtins.str] base_access_level: The base access level for the custom role. Valid values are: `DEVELOPER`, `GUEST`, `MAINTAINER`, `MINIMAL_ACCESS`, `OWNER`, `REPORTER`
        :param pulumi.Input[_builtins.str] created_at: Timestamp of when the member role was created.
        :param pulumi.Input[_builtins.str] description: Description for the member role.
        :param pulumi.Input[_builtins.str] edit_path: The Web UI path to edit the member role
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_permissions: All permissions enabled for the custom role. Valid values are: `ADMIN_CICD_VARIABLES`, `ADMIN_COMPLIANCE_FRAMEWORK`, `ADMIN_GROUP_MEMBER`, `ADMIN_INTEGRATIONS`, `ADMIN_MERGE_REQUEST`, `ADMIN_PROTECTED_BRANCH`, `ADMIN_PUSH_RULES`, `ADMIN_RUNNERS`, `ADMIN_TERRAFORM_STATE`, `ADMIN_VULNERABILITY`, `ADMIN_WEB_HOOK`, `ARCHIVE_PROJECT`, `MANAGE_DEPLOY_TOKENS`, `MANAGE_GROUP_ACCESS_TOKENS`, `MANAGE_MERGE_REQUEST_SETTINGS`, `MANAGE_PROJECT_ACCESS_TOKENS`, `MANAGE_SECURITY_POLICY_LINK`, `READ_ADMIN_CICD`, `READ_ADMIN_DASHBOARD`, `READ_CODE`, `READ_COMPLIANCE_DASHBOARD`, `READ_CRM_CONTACT`, `READ_DEPENDENCY`, `READ_RUNNERS`, `READ_VULNERABILITY`, `REMOVE_GROUP`, `REMOVE_PROJECT`
        :param pulumi.Input[_builtins.str] group_path: Full path of the namespace to create the member role in. **Required for SAAS** **Not allowed for self-managed**
        :param pulumi.Input[_builtins.int] iid: The id integer value extracted from the `id` attribute
        :param pulumi.Input[_builtins.str] name: Name for the member role.
        """
        if base_access_level is not None:
            pulumi.set(__self__, "base_access_level", base_access_level)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if edit_path is not None:
            pulumi.set(__self__, "edit_path", edit_path)
        if enabled_permissions is not None:
            pulumi.set(__self__, "enabled_permissions", enabled_permissions)
        if group_path is not None:
            pulumi.set(__self__, "group_path", group_path)
        if iid is not None:
            pulumi.set(__self__, "iid", iid)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="baseAccessLevel")
    def base_access_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base access level for the custom role. Valid values are: `DEVELOPER`, `GUEST`, `MAINTAINER`, `MINIMAL_ACCESS`, `OWNER`, `REPORTER`
        """
        return pulumi.get(self, "base_access_level")

    @base_access_level.setter
    def base_access_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "base_access_level", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp of when the member role was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the member role.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="editPath")
    def edit_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Web UI path to edit the member role
        """
        return pulumi.get(self, "edit_path")

    @edit_path.setter
    def edit_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edit_path", value)

    @_builtins.property
    @pulumi.getter(name="enabledPermissions")
    def enabled_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        All permissions enabled for the custom role. Valid values are: `ADMIN_CICD_VARIABLES`, `ADMIN_COMPLIANCE_FRAMEWORK`, `ADMIN_GROUP_MEMBER`, `ADMIN_INTEGRATIONS`, `ADMIN_MERGE_REQUEST`, `ADMIN_PROTECTED_BRANCH`, `ADMIN_PUSH_RULES`, `ADMIN_RUNNERS`, `ADMIN_TERRAFORM_STATE`, `ADMIN_VULNERABILITY`, `ADMIN_WEB_HOOK`, `ARCHIVE_PROJECT`, `MANAGE_DEPLOY_TOKENS`, `MANAGE_GROUP_ACCESS_TOKENS`, `MANAGE_MERGE_REQUEST_SETTINGS`, `MANAGE_PROJECT_ACCESS_TOKENS`, `MANAGE_SECURITY_POLICY_LINK`, `READ_ADMIN_CICD`, `READ_ADMIN_DASHBOARD`, `READ_CODE`, `READ_COMPLIANCE_DASHBOARD`, `READ_CRM_CONTACT`, `READ_DEPENDENCY`, `READ_RUNNERS`, `READ_VULNERABILITY`, `REMOVE_GROUP`, `REMOVE_PROJECT`
        """
        return pulumi.get(self, "enabled_permissions")

    @enabled_permissions.setter
    def enabled_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enabled_permissions", value)

    @_builtins.property
    @pulumi.getter(name="groupPath")
    def group_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full path of the namespace to create the member role in. **Required for SAAS** **Not allowed for self-managed**
        """
        return pulumi.get(self, "group_path")

    @group_path.setter
    def group_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_path", value)

    @_builtins.property
    @pulumi.getter
    def iid(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The id integer value extracted from the `id` attribute
        """
        return pulumi.get(self, "iid")

    @iid.setter
    def iid(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "iid", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name for the member role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("gitlab:index/memberRole:MemberRole")
class MemberRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 group_path: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The `MemberRole` resource allows to manage the lifecycle of a custom member role.

        Custom roles allow an organization to create user roles with the precise privileges and permissions required for that organization’s needs.

        > This resource requires an Ultimate license.

        > Most custom roles are considered billable users that use a seat. [Custom roles billing and seat usage](https://docs.gitlab.com/user/custom_roles/#billing-and-seat-usage)

        > There can be only 10 custom roles on your instance or namespace. See [issue 450929](https://gitlab.com/gitlab-org/gitlab/-/issues/450929) for more details.

        **Upstream API**: [GitLab GraphQL API docs](https://docs.gitlab.com/api/graphql/reference/#mutationmemberrolecreate)

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_member_role`. For example:

        terraform

        import {

          to = gitlab_member_role.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        GitLab member role can be imported using the id made up of `gid://gitlab/MemberRole/<ID>` e.g.

        ```sh
        $ pulumi import gitlab:index/memberRole:MemberRole example 'gid://gitlab/MemberRole/123'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] base_access_level: The base access level for the custom role. Valid values are: `DEVELOPER`, `GUEST`, `MAINTAINER`, `MINIMAL_ACCESS`, `OWNER`, `REPORTER`
        :param pulumi.Input[_builtins.str] description: Description for the member role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_permissions: All permissions enabled for the custom role. Valid values are: `ADMIN_CICD_VARIABLES`, `ADMIN_COMPLIANCE_FRAMEWORK`, `ADMIN_GROUP_MEMBER`, `ADMIN_INTEGRATIONS`, `ADMIN_MERGE_REQUEST`, `ADMIN_PROTECTED_BRANCH`, `ADMIN_PUSH_RULES`, `ADMIN_RUNNERS`, `ADMIN_TERRAFORM_STATE`, `ADMIN_VULNERABILITY`, `ADMIN_WEB_HOOK`, `ARCHIVE_PROJECT`, `MANAGE_DEPLOY_TOKENS`, `MANAGE_GROUP_ACCESS_TOKENS`, `MANAGE_MERGE_REQUEST_SETTINGS`, `MANAGE_PROJECT_ACCESS_TOKENS`, `MANAGE_SECURITY_POLICY_LINK`, `READ_ADMIN_CICD`, `READ_ADMIN_DASHBOARD`, `READ_CODE`, `READ_COMPLIANCE_DASHBOARD`, `READ_CRM_CONTACT`, `READ_DEPENDENCY`, `READ_RUNNERS`, `READ_VULNERABILITY`, `REMOVE_GROUP`, `REMOVE_PROJECT`
        :param pulumi.Input[_builtins.str] group_path: Full path of the namespace to create the member role in. **Required for SAAS** **Not allowed for self-managed**
        :param pulumi.Input[_builtins.str] name: Name for the member role.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MemberRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `MemberRole` resource allows to manage the lifecycle of a custom member role.

        Custom roles allow an organization to create user roles with the precise privileges and permissions required for that organization’s needs.

        > This resource requires an Ultimate license.

        > Most custom roles are considered billable users that use a seat. [Custom roles billing and seat usage](https://docs.gitlab.com/user/custom_roles/#billing-and-seat-usage)

        > There can be only 10 custom roles on your instance or namespace. See [issue 450929](https://gitlab.com/gitlab-org/gitlab/-/issues/450929) for more details.

        **Upstream API**: [GitLab GraphQL API docs](https://docs.gitlab.com/api/graphql/reference/#mutationmemberrolecreate)

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_member_role`. For example:

        terraform

        import {

          to = gitlab_member_role.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        GitLab member role can be imported using the id made up of `gid://gitlab/MemberRole/<ID>` e.g.

        ```sh
        $ pulumi import gitlab:index/memberRole:MemberRole example 'gid://gitlab/MemberRole/123'
        ```

        :param str resource_name: The name of the resource.
        :param MemberRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MemberRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 group_path: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MemberRoleArgs.__new__(MemberRoleArgs)

            if base_access_level is None and not opts.urn:
                raise TypeError("Missing required property 'base_access_level'")
            __props__.__dict__["base_access_level"] = base_access_level
            __props__.__dict__["description"] = description
            if enabled_permissions is None and not opts.urn:
                raise TypeError("Missing required property 'enabled_permissions'")
            __props__.__dict__["enabled_permissions"] = enabled_permissions
            __props__.__dict__["group_path"] = group_path
            __props__.__dict__["name"] = name
            __props__.__dict__["created_at"] = None
            __props__.__dict__["edit_path"] = None
            __props__.__dict__["iid"] = None
        super(MemberRole, __self__).__init__(
            'gitlab:index/memberRole:MemberRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            base_access_level: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            edit_path: Optional[pulumi.Input[_builtins.str]] = None,
            enabled_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            group_path: Optional[pulumi.Input[_builtins.str]] = None,
            iid: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'MemberRole':
        """
        Get an existing MemberRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] base_access_level: The base access level for the custom role. Valid values are: `DEVELOPER`, `GUEST`, `MAINTAINER`, `MINIMAL_ACCESS`, `OWNER`, `REPORTER`
        :param pulumi.Input[_builtins.str] created_at: Timestamp of when the member role was created.
        :param pulumi.Input[_builtins.str] description: Description for the member role.
        :param pulumi.Input[_builtins.str] edit_path: The Web UI path to edit the member role
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_permissions: All permissions enabled for the custom role. Valid values are: `ADMIN_CICD_VARIABLES`, `ADMIN_COMPLIANCE_FRAMEWORK`, `ADMIN_GROUP_MEMBER`, `ADMIN_INTEGRATIONS`, `ADMIN_MERGE_REQUEST`, `ADMIN_PROTECTED_BRANCH`, `ADMIN_PUSH_RULES`, `ADMIN_RUNNERS`, `ADMIN_TERRAFORM_STATE`, `ADMIN_VULNERABILITY`, `ADMIN_WEB_HOOK`, `ARCHIVE_PROJECT`, `MANAGE_DEPLOY_TOKENS`, `MANAGE_GROUP_ACCESS_TOKENS`, `MANAGE_MERGE_REQUEST_SETTINGS`, `MANAGE_PROJECT_ACCESS_TOKENS`, `MANAGE_SECURITY_POLICY_LINK`, `READ_ADMIN_CICD`, `READ_ADMIN_DASHBOARD`, `READ_CODE`, `READ_COMPLIANCE_DASHBOARD`, `READ_CRM_CONTACT`, `READ_DEPENDENCY`, `READ_RUNNERS`, `READ_VULNERABILITY`, `REMOVE_GROUP`, `REMOVE_PROJECT`
        :param pulumi.Input[_builtins.str] group_path: Full path of the namespace to create the member role in. **Required for SAAS** **Not allowed for self-managed**
        :param pulumi.Input[_builtins.int] iid: The id integer value extracted from the `id` attribute
        :param pulumi.Input[_builtins.str] name: Name for the member role.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MemberRoleState.__new__(_MemberRoleState)

        __props__.__dict__["base_access_level"] = base_access_level
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["edit_path"] = edit_path
        __props__.__dict__["enabled_permissions"] = enabled_permissions
        __props__.__dict__["group_path"] = group_path
        __props__.__dict__["iid"] = iid
        __props__.__dict__["name"] = name
        return MemberRole(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="baseAccessLevel")
    def base_access_level(self) -> pulumi.Output[_builtins.str]:
        """
        The base access level for the custom role. Valid values are: `DEVELOPER`, `GUEST`, `MAINTAINER`, `MINIMAL_ACCESS`, `OWNER`, `REPORTER`
        """
        return pulumi.get(self, "base_access_level")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp of when the member role was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description for the member role.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="editPath")
    def edit_path(self) -> pulumi.Output[_builtins.str]:
        """
        The Web UI path to edit the member role
        """
        return pulumi.get(self, "edit_path")

    @_builtins.property
    @pulumi.getter(name="enabledPermissions")
    def enabled_permissions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        All permissions enabled for the custom role. Valid values are: `ADMIN_CICD_VARIABLES`, `ADMIN_COMPLIANCE_FRAMEWORK`, `ADMIN_GROUP_MEMBER`, `ADMIN_INTEGRATIONS`, `ADMIN_MERGE_REQUEST`, `ADMIN_PROTECTED_BRANCH`, `ADMIN_PUSH_RULES`, `ADMIN_RUNNERS`, `ADMIN_TERRAFORM_STATE`, `ADMIN_VULNERABILITY`, `ADMIN_WEB_HOOK`, `ARCHIVE_PROJECT`, `MANAGE_DEPLOY_TOKENS`, `MANAGE_GROUP_ACCESS_TOKENS`, `MANAGE_MERGE_REQUEST_SETTINGS`, `MANAGE_PROJECT_ACCESS_TOKENS`, `MANAGE_SECURITY_POLICY_LINK`, `READ_ADMIN_CICD`, `READ_ADMIN_DASHBOARD`, `READ_CODE`, `READ_COMPLIANCE_DASHBOARD`, `READ_CRM_CONTACT`, `READ_DEPENDENCY`, `READ_RUNNERS`, `READ_VULNERABILITY`, `REMOVE_GROUP`, `REMOVE_PROJECT`
        """
        return pulumi.get(self, "enabled_permissions")

    @_builtins.property
    @pulumi.getter(name="groupPath")
    def group_path(self) -> pulumi.Output[_builtins.str]:
        """
        Full path of the namespace to create the member role in. **Required for SAAS** **Not allowed for self-managed**
        """
        return pulumi.get(self, "group_path")

    @_builtins.property
    @pulumi.getter
    def iid(self) -> pulumi.Output[_builtins.int]:
        """
        The id integer value extracted from the `id` attribute
        """
        return pulumi.get(self, "iid")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name for the member role.
        """
        return pulumi.get(self, "name")

