# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserRunnerArgs', 'UserRunner']

@pulumi.input_type
class UserRunnerArgs:
    def __init__(__self__, *,
                 runner_type: pulumi.Input[_builtins.str],
                 access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 maintenance_note: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 paused: Optional[pulumi.Input[_builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 untagged: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a UserRunner resource.
        :param pulumi.Input[_builtins.str] runner_type: The scope of the runner. Valid values are: `instance_type`, `group_type`, `project_type`.
        :param pulumi.Input[_builtins.str] access_level: The access level of the runner. Valid values are: `not_protected`, `ref_protected`.
        :param pulumi.Input[_builtins.str] description: Description of the runner.
        :param pulumi.Input[_builtins.int] group_id: The ID of the group that the runner is created in. Required if runner*type is group*type.
        :param pulumi.Input[_builtins.bool] locked: Specifies if the runner should be locked for the current project.
        :param pulumi.Input[_builtins.str] maintenance_note: Free-form maintenance notes for the runner (1024 characters)
        :param pulumi.Input[_builtins.int] maximum_timeout: Maximum timeout that limits the amount of time (in seconds) that runners can run jobs. Must be at least 600 (10 minutes).
        :param pulumi.Input[_builtins.bool] paused: Specifies if the runner should ignore new jobs.
        :param pulumi.Input[_builtins.int] project_id: The ID of the project that the runner is created in. Required if runner*type is project*type.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tag_lists: A list of runner tags.
        :param pulumi.Input[_builtins.bool] untagged: Specifies if the runner should handle untagged jobs.
        """
        pulumi.set(__self__, "runner_type", runner_type)
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if maintenance_note is not None:
            pulumi.set(__self__, "maintenance_note", maintenance_note)
        if maximum_timeout is not None:
            pulumi.set(__self__, "maximum_timeout", maximum_timeout)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tag_lists is not None:
            pulumi.set(__self__, "tag_lists", tag_lists)
        if untagged is not None:
            pulumi.set(__self__, "untagged", untagged)

    @_builtins.property
    @pulumi.getter(name="runnerType")
    def runner_type(self) -> pulumi.Input[_builtins.str]:
        """
        The scope of the runner. Valid values are: `instance_type`, `group_type`, `project_type`.
        """
        return pulumi.get(self, "runner_type")

    @runner_type.setter
    def runner_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "runner_type", value)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access level of the runner. Valid values are: `not_protected`, `ref_protected`.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_level", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the runner.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the group that the runner is created in. Required if runner*type is group*type.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the runner should be locked for the current project.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "locked", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceNote")
    def maintenance_note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Free-form maintenance notes for the runner (1024 characters)
        """
        return pulumi.get(self, "maintenance_note")

    @maintenance_note.setter
    def maintenance_note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_note", value)

    @_builtins.property
    @pulumi.getter(name="maximumTimeout")
    def maximum_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum timeout that limits the amount of time (in seconds) that runners can run jobs. Must be at least 600 (10 minutes).
        """
        return pulumi.get(self, "maximum_timeout")

    @maximum_timeout.setter
    def maximum_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_timeout", value)

    @_builtins.property
    @pulumi.getter
    def paused(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the runner should ignore new jobs.
        """
        return pulumi.get(self, "paused")

    @paused.setter
    def paused(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "paused", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the project that the runner is created in. Required if runner*type is project*type.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="tagLists")
    def tag_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of runner tags.
        """
        return pulumi.get(self, "tag_lists")

    @tag_lists.setter
    def tag_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tag_lists", value)

    @_builtins.property
    @pulumi.getter
    def untagged(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the runner should handle untagged jobs.
        """
        return pulumi.get(self, "untagged")

    @untagged.setter
    def untagged(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "untagged", value)


@pulumi.input_type
class _UserRunnerState:
    def __init__(__self__, *,
                 access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 maintenance_note: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 paused: Optional[pulumi.Input[_builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 runner_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 untagged: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering UserRunner resources.
        :param pulumi.Input[_builtins.str] access_level: The access level of the runner. Valid values are: `not_protected`, `ref_protected`.
        :param pulumi.Input[_builtins.str] description: Description of the runner.
        :param pulumi.Input[_builtins.int] group_id: The ID of the group that the runner is created in. Required if runner*type is group*type.
        :param pulumi.Input[_builtins.bool] locked: Specifies if the runner should be locked for the current project.
        :param pulumi.Input[_builtins.str] maintenance_note: Free-form maintenance notes for the runner (1024 characters)
        :param pulumi.Input[_builtins.int] maximum_timeout: Maximum timeout that limits the amount of time (in seconds) that runners can run jobs. Must be at least 600 (10 minutes).
        :param pulumi.Input[_builtins.bool] paused: Specifies if the runner should ignore new jobs.
        :param pulumi.Input[_builtins.int] project_id: The ID of the project that the runner is created in. Required if runner*type is project*type.
        :param pulumi.Input[_builtins.str] runner_type: The scope of the runner. Valid values are: `instance_type`, `group_type`, `project_type`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tag_lists: A list of runner tags.
        :param pulumi.Input[_builtins.str] token: The authentication token to use when setting up a new runner with this configuration. This value cannot be imported.
        :param pulumi.Input[_builtins.bool] untagged: Specifies if the runner should handle untagged jobs.
        """
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if maintenance_note is not None:
            pulumi.set(__self__, "maintenance_note", maintenance_note)
        if maximum_timeout is not None:
            pulumi.set(__self__, "maximum_timeout", maximum_timeout)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if runner_type is not None:
            pulumi.set(__self__, "runner_type", runner_type)
        if tag_lists is not None:
            pulumi.set(__self__, "tag_lists", tag_lists)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if untagged is not None:
            pulumi.set(__self__, "untagged", untagged)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access level of the runner. Valid values are: `not_protected`, `ref_protected`.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_level", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the runner.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the group that the runner is created in. Required if runner*type is group*type.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the runner should be locked for the current project.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "locked", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceNote")
    def maintenance_note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Free-form maintenance notes for the runner (1024 characters)
        """
        return pulumi.get(self, "maintenance_note")

    @maintenance_note.setter
    def maintenance_note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_note", value)

    @_builtins.property
    @pulumi.getter(name="maximumTimeout")
    def maximum_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum timeout that limits the amount of time (in seconds) that runners can run jobs. Must be at least 600 (10 minutes).
        """
        return pulumi.get(self, "maximum_timeout")

    @maximum_timeout.setter
    def maximum_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_timeout", value)

    @_builtins.property
    @pulumi.getter
    def paused(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the runner should ignore new jobs.
        """
        return pulumi.get(self, "paused")

    @paused.setter
    def paused(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "paused", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the project that the runner is created in. Required if runner*type is project*type.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="runnerType")
    def runner_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scope of the runner. Valid values are: `instance_type`, `group_type`, `project_type`.
        """
        return pulumi.get(self, "runner_type")

    @runner_type.setter
    def runner_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runner_type", value)

    @_builtins.property
    @pulumi.getter(name="tagLists")
    def tag_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of runner tags.
        """
        return pulumi.get(self, "tag_lists")

    @tag_lists.setter
    def tag_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tag_lists", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication token to use when setting up a new runner with this configuration. This value cannot be imported.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)

    @_builtins.property
    @pulumi.getter
    def untagged(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the runner should handle untagged jobs.
        """
        return pulumi.get(self, "untagged")

    @untagged.setter
    def untagged(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "untagged", value)


@pulumi.type_token("gitlab:index/userRunner:UserRunner")
class UserRunner(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 maintenance_note: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 paused: Optional[pulumi.Input[_builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 runner_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 untagged: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        The `UserRunner` resource allows creating a GitLab runner using the new [GitLab Runner Registration Flow](https://docs.gitlab.com/ci/runners/new_creation_workflow/).

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/users/#create-a-runner)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        # Create a project runner
        project_runner = gitlab.UserRunner("project_runner",
            runner_type="project_type",
            project_id=123456,
            description="A runner created using a user access token instead of a registration token",
            tag_lists=[
                "a-tag",
                "other-tag",
            ],
            untagged=True)
        # Create a group runner
        group_runner = gitlab.UserRunner("group_runner",
            runner_type="group_type",
            group_id=123456)
        # Create a instance runner
        instance_runner = gitlab.UserRunner("instance_runner", runner_type="instance_type")
        config_toml = group_runner.token.apply(lambda token: f\"\"\"concurrent = 1
        check_interval = 0

        [session_server]
          session_timeout = 1800

        [[runners]]
          name = "my_gitlab_runner"
          url = "https://example.gitlab.com"
          token = "{token}"
          executor = "docker"

          [runners.custom_build_dir]
          [runners.cache]
            [runners.cache.s3]
            [runners.cache.gcs]
            [runners.cache.azure]
          [runners.docker]
            tls_verify = false
            image = "ubuntu"
            privileged = true
            disable_entrypoint_overwrite = false
            oom_kill_disable = false
            disable_cache = false
            volumes = ["/cache", "/certs/client"]
            shm_size = 0
        \"\"\")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_user_runner`. For example:

        terraform

        import {

          to = gitlab_user_runner.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        You can import a gitlab runner using its ID

        Note: Importing a runner will not provide access to the `token` attribute

        ```sh
        $ pulumi import gitlab:index/userRunner:UserRunner example 12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_level: The access level of the runner. Valid values are: `not_protected`, `ref_protected`.
        :param pulumi.Input[_builtins.str] description: Description of the runner.
        :param pulumi.Input[_builtins.int] group_id: The ID of the group that the runner is created in. Required if runner*type is group*type.
        :param pulumi.Input[_builtins.bool] locked: Specifies if the runner should be locked for the current project.
        :param pulumi.Input[_builtins.str] maintenance_note: Free-form maintenance notes for the runner (1024 characters)
        :param pulumi.Input[_builtins.int] maximum_timeout: Maximum timeout that limits the amount of time (in seconds) that runners can run jobs. Must be at least 600 (10 minutes).
        :param pulumi.Input[_builtins.bool] paused: Specifies if the runner should ignore new jobs.
        :param pulumi.Input[_builtins.int] project_id: The ID of the project that the runner is created in. Required if runner*type is project*type.
        :param pulumi.Input[_builtins.str] runner_type: The scope of the runner. Valid values are: `instance_type`, `group_type`, `project_type`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tag_lists: A list of runner tags.
        :param pulumi.Input[_builtins.bool] untagged: Specifies if the runner should handle untagged jobs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserRunnerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `UserRunner` resource allows creating a GitLab runner using the new [GitLab Runner Registration Flow](https://docs.gitlab.com/ci/runners/new_creation_workflow/).

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/users/#create-a-runner)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        # Create a project runner
        project_runner = gitlab.UserRunner("project_runner",
            runner_type="project_type",
            project_id=123456,
            description="A runner created using a user access token instead of a registration token",
            tag_lists=[
                "a-tag",
                "other-tag",
            ],
            untagged=True)
        # Create a group runner
        group_runner = gitlab.UserRunner("group_runner",
            runner_type="group_type",
            group_id=123456)
        # Create a instance runner
        instance_runner = gitlab.UserRunner("instance_runner", runner_type="instance_type")
        config_toml = group_runner.token.apply(lambda token: f\"\"\"concurrent = 1
        check_interval = 0

        [session_server]
          session_timeout = 1800

        [[runners]]
          name = "my_gitlab_runner"
          url = "https://example.gitlab.com"
          token = "{token}"
          executor = "docker"

          [runners.custom_build_dir]
          [runners.cache]
            [runners.cache.s3]
            [runners.cache.gcs]
            [runners.cache.azure]
          [runners.docker]
            tls_verify = false
            image = "ubuntu"
            privileged = true
            disable_entrypoint_overwrite = false
            oom_kill_disable = false
            disable_cache = false
            volumes = ["/cache", "/certs/client"]
            shm_size = 0
        \"\"\")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_user_runner`. For example:

        terraform

        import {

          to = gitlab_user_runner.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        You can import a gitlab runner using its ID

        Note: Importing a runner will not provide access to the `token` attribute

        ```sh
        $ pulumi import gitlab:index/userRunner:UserRunner example 12345
        ```

        :param str resource_name: The name of the resource.
        :param UserRunnerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserRunnerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 maintenance_note: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 paused: Optional[pulumi.Input[_builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 runner_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 untagged: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserRunnerArgs.__new__(UserRunnerArgs)

            __props__.__dict__["access_level"] = access_level
            __props__.__dict__["description"] = description
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["locked"] = locked
            __props__.__dict__["maintenance_note"] = maintenance_note
            __props__.__dict__["maximum_timeout"] = maximum_timeout
            __props__.__dict__["paused"] = paused
            __props__.__dict__["project_id"] = project_id
            if runner_type is None and not opts.urn:
                raise TypeError("Missing required property 'runner_type'")
            __props__.__dict__["runner_type"] = runner_type
            __props__.__dict__["tag_lists"] = tag_lists
            __props__.__dict__["untagged"] = untagged
            __props__.__dict__["token"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(UserRunner, __self__).__init__(
            'gitlab:index/userRunner:UserRunner',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_level: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            group_id: Optional[pulumi.Input[_builtins.int]] = None,
            locked: Optional[pulumi.Input[_builtins.bool]] = None,
            maintenance_note: Optional[pulumi.Input[_builtins.str]] = None,
            maximum_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            paused: Optional[pulumi.Input[_builtins.bool]] = None,
            project_id: Optional[pulumi.Input[_builtins.int]] = None,
            runner_type: Optional[pulumi.Input[_builtins.str]] = None,
            tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            token: Optional[pulumi.Input[_builtins.str]] = None,
            untagged: Optional[pulumi.Input[_builtins.bool]] = None) -> 'UserRunner':
        """
        Get an existing UserRunner resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_level: The access level of the runner. Valid values are: `not_protected`, `ref_protected`.
        :param pulumi.Input[_builtins.str] description: Description of the runner.
        :param pulumi.Input[_builtins.int] group_id: The ID of the group that the runner is created in. Required if runner*type is group*type.
        :param pulumi.Input[_builtins.bool] locked: Specifies if the runner should be locked for the current project.
        :param pulumi.Input[_builtins.str] maintenance_note: Free-form maintenance notes for the runner (1024 characters)
        :param pulumi.Input[_builtins.int] maximum_timeout: Maximum timeout that limits the amount of time (in seconds) that runners can run jobs. Must be at least 600 (10 minutes).
        :param pulumi.Input[_builtins.bool] paused: Specifies if the runner should ignore new jobs.
        :param pulumi.Input[_builtins.int] project_id: The ID of the project that the runner is created in. Required if runner*type is project*type.
        :param pulumi.Input[_builtins.str] runner_type: The scope of the runner. Valid values are: `instance_type`, `group_type`, `project_type`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tag_lists: A list of runner tags.
        :param pulumi.Input[_builtins.str] token: The authentication token to use when setting up a new runner with this configuration. This value cannot be imported.
        :param pulumi.Input[_builtins.bool] untagged: Specifies if the runner should handle untagged jobs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserRunnerState.__new__(_UserRunnerState)

        __props__.__dict__["access_level"] = access_level
        __props__.__dict__["description"] = description
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["locked"] = locked
        __props__.__dict__["maintenance_note"] = maintenance_note
        __props__.__dict__["maximum_timeout"] = maximum_timeout
        __props__.__dict__["paused"] = paused
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["runner_type"] = runner_type
        __props__.__dict__["tag_lists"] = tag_lists
        __props__.__dict__["token"] = token
        __props__.__dict__["untagged"] = untagged
        return UserRunner(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> pulumi.Output[_builtins.str]:
        """
        The access level of the runner. Valid values are: `not_protected`, `ref_protected`.
        """
        return pulumi.get(self, "access_level")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description of the runner.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The ID of the group that the runner is created in. Required if runner*type is group*type.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def locked(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies if the runner should be locked for the current project.
        """
        return pulumi.get(self, "locked")

    @_builtins.property
    @pulumi.getter(name="maintenanceNote")
    def maintenance_note(self) -> pulumi.Output[_builtins.str]:
        """
        Free-form maintenance notes for the runner (1024 characters)
        """
        return pulumi.get(self, "maintenance_note")

    @_builtins.property
    @pulumi.getter(name="maximumTimeout")
    def maximum_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum timeout that limits the amount of time (in seconds) that runners can run jobs. Must be at least 600 (10 minutes).
        """
        return pulumi.get(self, "maximum_timeout")

    @_builtins.property
    @pulumi.getter
    def paused(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies if the runner should ignore new jobs.
        """
        return pulumi.get(self, "paused")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The ID of the project that the runner is created in. Required if runner*type is project*type.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="runnerType")
    def runner_type(self) -> pulumi.Output[_builtins.str]:
        """
        The scope of the runner. Valid values are: `instance_type`, `group_type`, `project_type`.
        """
        return pulumi.get(self, "runner_type")

    @_builtins.property
    @pulumi.getter(name="tagLists")
    def tag_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of runner tags.
        """
        return pulumi.get(self, "tag_lists")

    @_builtins.property
    @pulumi.getter
    def token(self) -> pulumi.Output[_builtins.str]:
        """
        The authentication token to use when setting up a new runner with this configuration. This value cannot be imported.
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def untagged(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies if the runner should handle untagged jobs.
        """
        return pulumi.get(self, "untagged")

