---
name: Bug
about: Something is wrong with 'gt_extras'.
title: ""
labels: "Type: ☹︎ Bug"
---

## Prework

- [ ] Read and agree to the [code of conduct](https://www.contributor-covenant.org/version/2/1/code_of_conduct/) and [contributing guidelines](https://github.com/posit-dev/gt_extras/blob/main/.github/CONTRIBUTING.md).
- [ ] If there is [already a relevant issue](https://github.com/posit-dev/gt_extras/issues), whether open or closed, comment on the existing thread instead of posting a new issue.

## Description

Describe the bug clearly and concisely.

## Reproducible example

- [ ] Post a minimal reproducible example (MRE) so the maintainer can troubleshoot the problems you identify. A reproducible example is:
  - [ ] **Runnable**: post enough code and data so any onlooker can create the error on their own computer.
  - [ ] **Minimal**: reduce runtime wherever possible and remove complicated details that are irrelevant to the issue at hand.
  - [ ] **Readable**: format your code according to the [Style Guide for Python Code](https://peps.python.org/pep-0008/).

## Expected result

What should have happened? Please be as specific as possible.

## Development environment

- Operating System: [e.g., Linux, macOS, Windows]
- **gt_extras** Version: [e.g., 0.0.1]

## Additional context

Add any other context about the problem here.
