from pathlib import Path
from setuptools import setup
from setuptools import find_packages


HERE = Path(__file__).absolute().parent

with (HERE / 'README.md').open() as f:
    README = f.read()


# Setup
# ----------------------------

setup(name='feedancy',
      version='1.0.0',
      description='feedancy',
      long_description=README,
      classifiers=[
          'Intended Audience :: Developers',
          'Programming Language :: Python',
          'Programming Language :: Python :: 3',
          'Operating System :: POSIX',
          'Topic :: Internet :: WWW/HTTP',
      ],
      keywords='web',
      packages=find_packages(exclude=['tests', 'tests.*']),
      include_package_data=True,
      zip_safe=False,
      test_suite='tests',
      tests_require=['pytest', 'coverage', 'wheel'],
      install_requires=['pydantic', 'multidict', 'schemathesis'],
      extras_require={
          'asyncio': ['aiohttp'],
          'sync': ['requests'],
      },
      entry_points={}
    )