# coding: utf-8

"""
    Equinix Fabric API v4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictInt, StrictStr
from typing import Optional
from typing_extensions import Annotated
from equinix.services.fabricv4.models.get_metrics_by_asset_response import GetMetricsByAssetResponse
from equinix.services.fabricv4.models.metric_asset_type import MetricAssetType
from equinix.services.fabricv4.models.metrics_search_request import MetricsSearchRequest

from equinix.services.fabricv4.api_client import ApiClient, RequestSerialized
from equinix.services.fabricv4.api_response import ApiResponse
from equinix.services.fabricv4.rest import RESTResponseType


class MetricsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_metric_by_asset_id(
        self,
        asset: Annotated[MetricAssetType, Field(description="asset")],
        asset_id: Annotated[StrictStr, Field(description="asset UUID")],
        name: Annotated[StrictStr, Field(description="Name of the metric types: <br> - equinix.fabric.connection.bandwidth_rx.usage <br> - equinix.fabric.connection.bandwidth_tx.usage <br> - equinix.fabric.connection.packets_dropped_rx_aside_rateexceeded.count <br> - equinix.fabric.connection.packets_dropped_tx_aside_rateexceeded.count <br> - equinix.fabric.connection.packets_dropped_rx_zside_rateexceeded.count <br> - equinix.fabric.connection.packets_dropped_tx_zside_rateexceeded.count <br> - equinix.fabric.port.bandwidth_rx.usage <br> - equinix.fabric.port.bandwidth_tx.usage <br> - equinix.fabric.port.packets_dropped_rx.count <br> - equinix.fabric.port.packets_dropped_tx.count <br> - equinix.fabric.port.packets_erred_rx.count <br> - equinix.fabric.port.packets_erred_tx.count <br> - equinix.fabric.metro.{source_metro_code}_{destination_metro_code}.latency <br> - equinix.fabric.metro.{source_metro_code}_{destination_metro_code}.jitter_avg <br> ")],
        from_date_time: Annotated[Optional[datetime], Field(description="Start date and time")] = None,
        to_date_time: Annotated[Optional[datetime], Field(description="End date and time")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="offset")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="limit")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetMetricsByAssetResponse:
        """Get Metrics by Asset Id

        This API provides capability to retrieve Metrics of an asset id

        :param asset: asset (required)
        :type asset: MetricAssetType
        :param asset_id: asset UUID (required)
        :type asset_id: str
        :param name: Name of the metric types: <br> - equinix.fabric.connection.bandwidth_rx.usage <br> - equinix.fabric.connection.bandwidth_tx.usage <br> - equinix.fabric.connection.packets_dropped_rx_aside_rateexceeded.count <br> - equinix.fabric.connection.packets_dropped_tx_aside_rateexceeded.count <br> - equinix.fabric.connection.packets_dropped_rx_zside_rateexceeded.count <br> - equinix.fabric.connection.packets_dropped_tx_zside_rateexceeded.count <br> - equinix.fabric.port.bandwidth_rx.usage <br> - equinix.fabric.port.bandwidth_tx.usage <br> - equinix.fabric.port.packets_dropped_rx.count <br> - equinix.fabric.port.packets_dropped_tx.count <br> - equinix.fabric.port.packets_erred_rx.count <br> - equinix.fabric.port.packets_erred_tx.count <br> - equinix.fabric.metro.{source_metro_code}_{destination_metro_code}.latency <br> - equinix.fabric.metro.{source_metro_code}_{destination_metro_code}.jitter_avg <br>  (required)
        :type name: str
        :param from_date_time: Start date and time
        :type from_date_time: datetime
        :param to_date_time: End date and time
        :type to_date_time: datetime
        :param offset: offset
        :type offset: int
        :param limit: limit
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metric_by_asset_id_serialize(
            asset=asset,
            asset_id=asset_id,
            name=name,
            from_date_time=from_date_time,
            to_date_time=to_date_time,
            offset=offset,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricsByAssetResponse",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_metric_by_asset_id_with_http_info(
        self,
        asset: Annotated[MetricAssetType, Field(description="asset")],
        asset_id: Annotated[StrictStr, Field(description="asset UUID")],
        name: Annotated[StrictStr, Field(description="Name of the metric types: <br> - equinix.fabric.connection.bandwidth_rx.usage <br> - equinix.fabric.connection.bandwidth_tx.usage <br> - equinix.fabric.connection.packets_dropped_rx_aside_rateexceeded.count <br> - equinix.fabric.connection.packets_dropped_tx_aside_rateexceeded.count <br> - equinix.fabric.connection.packets_dropped_rx_zside_rateexceeded.count <br> - equinix.fabric.connection.packets_dropped_tx_zside_rateexceeded.count <br> - equinix.fabric.port.bandwidth_rx.usage <br> - equinix.fabric.port.bandwidth_tx.usage <br> - equinix.fabric.port.packets_dropped_rx.count <br> - equinix.fabric.port.packets_dropped_tx.count <br> - equinix.fabric.port.packets_erred_rx.count <br> - equinix.fabric.port.packets_erred_tx.count <br> - equinix.fabric.metro.{source_metro_code}_{destination_metro_code}.latency <br> - equinix.fabric.metro.{source_metro_code}_{destination_metro_code}.jitter_avg <br> ")],
        from_date_time: Annotated[Optional[datetime], Field(description="Start date and time")] = None,
        to_date_time: Annotated[Optional[datetime], Field(description="End date and time")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="offset")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="limit")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMetricsByAssetResponse]:
        """Get Metrics by Asset Id

        This API provides capability to retrieve Metrics of an asset id

        :param asset: asset (required)
        :type asset: MetricAssetType
        :param asset_id: asset UUID (required)
        :type asset_id: str
        :param name: Name of the metric types: <br> - equinix.fabric.connection.bandwidth_rx.usage <br> - equinix.fabric.connection.bandwidth_tx.usage <br> - equinix.fabric.connection.packets_dropped_rx_aside_rateexceeded.count <br> - equinix.fabric.connection.packets_dropped_tx_aside_rateexceeded.count <br> - equinix.fabric.connection.packets_dropped_rx_zside_rateexceeded.count <br> - equinix.fabric.connection.packets_dropped_tx_zside_rateexceeded.count <br> - equinix.fabric.port.bandwidth_rx.usage <br> - equinix.fabric.port.bandwidth_tx.usage <br> - equinix.fabric.port.packets_dropped_rx.count <br> - equinix.fabric.port.packets_dropped_tx.count <br> - equinix.fabric.port.packets_erred_rx.count <br> - equinix.fabric.port.packets_erred_tx.count <br> - equinix.fabric.metro.{source_metro_code}_{destination_metro_code}.latency <br> - equinix.fabric.metro.{source_metro_code}_{destination_metro_code}.jitter_avg <br>  (required)
        :type name: str
        :param from_date_time: Start date and time
        :type from_date_time: datetime
        :param to_date_time: End date and time
        :type to_date_time: datetime
        :param offset: offset
        :type offset: int
        :param limit: limit
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metric_by_asset_id_serialize(
            asset=asset,
            asset_id=asset_id,
            name=name,
            from_date_time=from_date_time,
            to_date_time=to_date_time,
            offset=offset,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricsByAssetResponse",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_metric_by_asset_id_without_preload_content(
        self,
        asset: Annotated[MetricAssetType, Field(description="asset")],
        asset_id: Annotated[StrictStr, Field(description="asset UUID")],
        name: Annotated[StrictStr, Field(description="Name of the metric types: <br> - equinix.fabric.connection.bandwidth_rx.usage <br> - equinix.fabric.connection.bandwidth_tx.usage <br> - equinix.fabric.connection.packets_dropped_rx_aside_rateexceeded.count <br> - equinix.fabric.connection.packets_dropped_tx_aside_rateexceeded.count <br> - equinix.fabric.connection.packets_dropped_rx_zside_rateexceeded.count <br> - equinix.fabric.connection.packets_dropped_tx_zside_rateexceeded.count <br> - equinix.fabric.port.bandwidth_rx.usage <br> - equinix.fabric.port.bandwidth_tx.usage <br> - equinix.fabric.port.packets_dropped_rx.count <br> - equinix.fabric.port.packets_dropped_tx.count <br> - equinix.fabric.port.packets_erred_rx.count <br> - equinix.fabric.port.packets_erred_tx.count <br> - equinix.fabric.metro.{source_metro_code}_{destination_metro_code}.latency <br> - equinix.fabric.metro.{source_metro_code}_{destination_metro_code}.jitter_avg <br> ")],
        from_date_time: Annotated[Optional[datetime], Field(description="Start date and time")] = None,
        to_date_time: Annotated[Optional[datetime], Field(description="End date and time")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="offset")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="limit")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Metrics by Asset Id

        This API provides capability to retrieve Metrics of an asset id

        :param asset: asset (required)
        :type asset: MetricAssetType
        :param asset_id: asset UUID (required)
        :type asset_id: str
        :param name: Name of the metric types: <br> - equinix.fabric.connection.bandwidth_rx.usage <br> - equinix.fabric.connection.bandwidth_tx.usage <br> - equinix.fabric.connection.packets_dropped_rx_aside_rateexceeded.count <br> - equinix.fabric.connection.packets_dropped_tx_aside_rateexceeded.count <br> - equinix.fabric.connection.packets_dropped_rx_zside_rateexceeded.count <br> - equinix.fabric.connection.packets_dropped_tx_zside_rateexceeded.count <br> - equinix.fabric.port.bandwidth_rx.usage <br> - equinix.fabric.port.bandwidth_tx.usage <br> - equinix.fabric.port.packets_dropped_rx.count <br> - equinix.fabric.port.packets_dropped_tx.count <br> - equinix.fabric.port.packets_erred_rx.count <br> - equinix.fabric.port.packets_erred_tx.count <br> - equinix.fabric.metro.{source_metro_code}_{destination_metro_code}.latency <br> - equinix.fabric.metro.{source_metro_code}_{destination_metro_code}.jitter_avg <br>  (required)
        :type name: str
        :param from_date_time: Start date and time
        :type from_date_time: datetime
        :param to_date_time: End date and time
        :type to_date_time: datetime
        :param offset: offset
        :type offset: int
        :param limit: limit
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metric_by_asset_id_serialize(
            asset=asset,
            asset_id=asset_id,
            name=name,
            from_date_time=from_date_time,
            to_date_time=to_date_time,
            offset=offset,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricsByAssetResponse",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_metric_by_asset_id_serialize(
        self,
        asset,
        asset_id,
        name,
        from_date_time,
        to_date_time,
        offset,
        limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if asset is not None:
            _path_params['asset'] = asset.value
        if asset_id is not None:
            _path_params['assetId'] = asset_id
        # process the query parameters
        if name is not None:
            
            _query_params.append(('name', name))
            
        if from_date_time is not None:
            if isinstance(from_date_time, datetime):
                _query_params.append(
                    (
                        'fromDateTime',
                        from_date_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('fromDateTime', from_date_time))
            
        if to_date_time is not None:
            if isinstance(to_date_time, datetime):
                _query_params.append(
                    (
                        'toDateTime',
                        to_date_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('toDateTime', to_date_time))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/fabric/v4/{asset}/{assetId}/metrics',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def search_metrics(
        self,
        metrics_search_request: MetricsSearchRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetMetricsByAssetResponse:
        """Search Metrics

        This API provides capability to search metrics from a filtered query

        :param metrics_search_request: (required)
        :type metrics_search_request: MetricsSearchRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_metrics_serialize(
            metrics_search_request=metrics_search_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricsByAssetResponse",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def search_metrics_with_http_info(
        self,
        metrics_search_request: MetricsSearchRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMetricsByAssetResponse]:
        """Search Metrics

        This API provides capability to search metrics from a filtered query

        :param metrics_search_request: (required)
        :type metrics_search_request: MetricsSearchRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_metrics_serialize(
            metrics_search_request=metrics_search_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricsByAssetResponse",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def search_metrics_without_preload_content(
        self,
        metrics_search_request: MetricsSearchRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Search Metrics

        This API provides capability to search metrics from a filtered query

        :param metrics_search_request: (required)
        :type metrics_search_request: MetricsSearchRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_metrics_serialize(
            metrics_search_request=metrics_search_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricsByAssetResponse",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _search_metrics_serialize(
        self,
        metrics_search_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if metrics_search_request is not None:
            _body_params = metrics_search_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/fabric/v4/metrics/search',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


