# coding: utf-8

"""
    Equinix Fabric API v4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from equinix.services.fabricv4.models.get_route_aggregation_rules_response import GetRouteAggregationRulesResponse
from equinix.services.fabricv4.models.route_aggregation_rules_base import RouteAggregationRulesBase
from equinix.services.fabricv4.models.route_aggregation_rules_change_data import RouteAggregationRulesChangeData
from equinix.services.fabricv4.models.route_aggregation_rules_change_data_response import RouteAggregationRulesChangeDataResponse
from equinix.services.fabricv4.models.route_aggregation_rules_data import RouteAggregationRulesData
from equinix.services.fabricv4.models.route_aggregation_rules_patch_request_item import RouteAggregationRulesPatchRequestItem
from equinix.services.fabricv4.models.route_aggregation_rules_post_request import RouteAggregationRulesPostRequest

from equinix.services.fabricv4.api_client import ApiClient, RequestSerialized
from equinix.services.fabricv4.api_response import ApiResponse
from equinix.services.fabricv4.rest import RESTResponseType


class RouteAggregationRulesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create_route_aggregation_rule(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        route_aggregation_rules_base: RouteAggregationRulesBase,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RouteAggregationRulesData:
        """Create RARule

        This API provides capability to create a Route Aggregation Rule

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param route_aggregation_rules_base: (required)
        :type route_aggregation_rules_base: RouteAggregationRulesBase
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_route_aggregation_rule_serialize(
            route_aggregation_id=route_aggregation_id,
            route_aggregation_rules_base=route_aggregation_rules_base,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "RouteAggregationRulesData",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '415': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_route_aggregation_rule_with_http_info(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        route_aggregation_rules_base: RouteAggregationRulesBase,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RouteAggregationRulesData]:
        """Create RARule

        This API provides capability to create a Route Aggregation Rule

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param route_aggregation_rules_base: (required)
        :type route_aggregation_rules_base: RouteAggregationRulesBase
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_route_aggregation_rule_serialize(
            route_aggregation_id=route_aggregation_id,
            route_aggregation_rules_base=route_aggregation_rules_base,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "RouteAggregationRulesData",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '415': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_route_aggregation_rule_without_preload_content(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        route_aggregation_rules_base: RouteAggregationRulesBase,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create RARule

        This API provides capability to create a Route Aggregation Rule

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param route_aggregation_rules_base: (required)
        :type route_aggregation_rules_base: RouteAggregationRulesBase
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_route_aggregation_rule_serialize(
            route_aggregation_id=route_aggregation_id,
            route_aggregation_rules_base=route_aggregation_rules_base,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "RouteAggregationRulesData",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '415': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_route_aggregation_rule_serialize(
        self,
        route_aggregation_id,
        route_aggregation_rules_base,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if route_aggregation_id is not None:
            _path_params['routeAggregationId'] = route_aggregation_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if route_aggregation_rules_base is not None:
            _body_params = route_aggregation_rules_base


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/fabric/v4/routeAggregations/{routeAggregationId}/routeAggregationRules',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_route_aggregation_rules_in_bulk(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        route_aggregation_rules_post_request: RouteAggregationRulesPostRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetRouteAggregationRulesResponse:
        """Bulk RARules

        This API provides capability to create bulk route aggregation rules

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param route_aggregation_rules_post_request: (required)
        :type route_aggregation_rules_post_request: RouteAggregationRulesPostRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_route_aggregation_rules_in_bulk_serialize(
            route_aggregation_id=route_aggregation_id,
            route_aggregation_rules_post_request=route_aggregation_rules_post_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "GetRouteAggregationRulesResponse",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '415': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_route_aggregation_rules_in_bulk_with_http_info(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        route_aggregation_rules_post_request: RouteAggregationRulesPostRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetRouteAggregationRulesResponse]:
        """Bulk RARules

        This API provides capability to create bulk route aggregation rules

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param route_aggregation_rules_post_request: (required)
        :type route_aggregation_rules_post_request: RouteAggregationRulesPostRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_route_aggregation_rules_in_bulk_serialize(
            route_aggregation_id=route_aggregation_id,
            route_aggregation_rules_post_request=route_aggregation_rules_post_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "GetRouteAggregationRulesResponse",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '415': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_route_aggregation_rules_in_bulk_without_preload_content(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        route_aggregation_rules_post_request: RouteAggregationRulesPostRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Bulk RARules

        This API provides capability to create bulk route aggregation rules

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param route_aggregation_rules_post_request: (required)
        :type route_aggregation_rules_post_request: RouteAggregationRulesPostRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_route_aggregation_rules_in_bulk_serialize(
            route_aggregation_id=route_aggregation_id,
            route_aggregation_rules_post_request=route_aggregation_rules_post_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "GetRouteAggregationRulesResponse",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '415': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_route_aggregation_rules_in_bulk_serialize(
        self,
        route_aggregation_id,
        route_aggregation_rules_post_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if route_aggregation_id is not None:
            _path_params['routeAggregationId'] = route_aggregation_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if route_aggregation_rules_post_request is not None:
            _body_params = route_aggregation_rules_post_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/fabric/v4/routeAggregations/{routeAggregationId}/routeAggregationRules/bulk',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_route_aggregation_rule_by_uuid(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        route_aggregation_rule_id: Annotated[StrictStr, Field(description="Route Aggregation Rules Id")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RouteAggregationRulesData:
        """DeleteRARule

        This API provides capability to delete a Route aggregation Rule

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param route_aggregation_rule_id: Route Aggregation Rules Id (required)
        :type route_aggregation_rule_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_route_aggregation_rule_by_uuid_serialize(
            route_aggregation_id=route_aggregation_id,
            route_aggregation_rule_id=route_aggregation_rule_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "RouteAggregationRulesData",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '415': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_route_aggregation_rule_by_uuid_with_http_info(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        route_aggregation_rule_id: Annotated[StrictStr, Field(description="Route Aggregation Rules Id")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RouteAggregationRulesData]:
        """DeleteRARule

        This API provides capability to delete a Route aggregation Rule

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param route_aggregation_rule_id: Route Aggregation Rules Id (required)
        :type route_aggregation_rule_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_route_aggregation_rule_by_uuid_serialize(
            route_aggregation_id=route_aggregation_id,
            route_aggregation_rule_id=route_aggregation_rule_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "RouteAggregationRulesData",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '415': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_route_aggregation_rule_by_uuid_without_preload_content(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        route_aggregation_rule_id: Annotated[StrictStr, Field(description="Route Aggregation Rules Id")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """DeleteRARule

        This API provides capability to delete a Route aggregation Rule

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param route_aggregation_rule_id: Route Aggregation Rules Id (required)
        :type route_aggregation_rule_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_route_aggregation_rule_by_uuid_serialize(
            route_aggregation_id=route_aggregation_id,
            route_aggregation_rule_id=route_aggregation_rule_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "RouteAggregationRulesData",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '415': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_route_aggregation_rule_by_uuid_serialize(
        self,
        route_aggregation_id,
        route_aggregation_rule_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if route_aggregation_id is not None:
            _path_params['routeAggregationId'] = route_aggregation_id
        if route_aggregation_rule_id is not None:
            _path_params['routeAggregationRuleId'] = route_aggregation_rule_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/fabric/v4/routeAggregations/{routeAggregationId}/routeAggregationRules/{routeAggregationRuleId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_route_aggregation_rule_by_uuid(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        route_aggregation_rule_id: Annotated[StrictStr, Field(description="Route Aggregation Rules Id")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RouteAggregationRulesData:
        """GetRARule By UUID

        This API provides capability to view a Route Aggregation Rule by UUID

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param route_aggregation_rule_id: Route Aggregation Rules Id (required)
        :type route_aggregation_rule_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_route_aggregation_rule_by_uuid_serialize(
            route_aggregation_id=route_aggregation_id,
            route_aggregation_rule_id=route_aggregation_rule_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "RouteAggregationRulesData",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '415': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_route_aggregation_rule_by_uuid_with_http_info(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        route_aggregation_rule_id: Annotated[StrictStr, Field(description="Route Aggregation Rules Id")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RouteAggregationRulesData]:
        """GetRARule By UUID

        This API provides capability to view a Route Aggregation Rule by UUID

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param route_aggregation_rule_id: Route Aggregation Rules Id (required)
        :type route_aggregation_rule_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_route_aggregation_rule_by_uuid_serialize(
            route_aggregation_id=route_aggregation_id,
            route_aggregation_rule_id=route_aggregation_rule_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "RouteAggregationRulesData",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '415': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_route_aggregation_rule_by_uuid_without_preload_content(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        route_aggregation_rule_id: Annotated[StrictStr, Field(description="Route Aggregation Rules Id")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """GetRARule By UUID

        This API provides capability to view a Route Aggregation Rule by UUID

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param route_aggregation_rule_id: Route Aggregation Rules Id (required)
        :type route_aggregation_rule_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_route_aggregation_rule_by_uuid_serialize(
            route_aggregation_id=route_aggregation_id,
            route_aggregation_rule_id=route_aggregation_rule_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "RouteAggregationRulesData",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '415': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_route_aggregation_rule_by_uuid_serialize(
        self,
        route_aggregation_id,
        route_aggregation_rule_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if route_aggregation_id is not None:
            _path_params['routeAggregationId'] = route_aggregation_id
        if route_aggregation_rule_id is not None:
            _path_params['routeAggregationRuleId'] = route_aggregation_rule_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/fabric/v4/routeAggregations/{routeAggregationId}/routeAggregationRules/{routeAggregationRuleId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_route_aggregation_rule_change_by_uuid(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        route_aggregation_rule_id: Annotated[StrictStr, Field(description="Route Aggregation Rules Id")],
        change_id: Annotated[StrictStr, Field(description="Route Aggregation Rule Change UUID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RouteAggregationRulesChangeData:
        """Get Change By ID

        This API provides capability to retrieve a specific Route Aggregation Rule's Changes

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param route_aggregation_rule_id: Route Aggregation Rules Id (required)
        :type route_aggregation_rule_id: str
        :param change_id: Route Aggregation Rule Change UUID (required)
        :type change_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_route_aggregation_rule_change_by_uuid_serialize(
            route_aggregation_id=route_aggregation_id,
            route_aggregation_rule_id=route_aggregation_rule_id,
            change_id=change_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RouteAggregationRulesChangeData",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_route_aggregation_rule_change_by_uuid_with_http_info(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        route_aggregation_rule_id: Annotated[StrictStr, Field(description="Route Aggregation Rules Id")],
        change_id: Annotated[StrictStr, Field(description="Route Aggregation Rule Change UUID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RouteAggregationRulesChangeData]:
        """Get Change By ID

        This API provides capability to retrieve a specific Route Aggregation Rule's Changes

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param route_aggregation_rule_id: Route Aggregation Rules Id (required)
        :type route_aggregation_rule_id: str
        :param change_id: Route Aggregation Rule Change UUID (required)
        :type change_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_route_aggregation_rule_change_by_uuid_serialize(
            route_aggregation_id=route_aggregation_id,
            route_aggregation_rule_id=route_aggregation_rule_id,
            change_id=change_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RouteAggregationRulesChangeData",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_route_aggregation_rule_change_by_uuid_without_preload_content(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        route_aggregation_rule_id: Annotated[StrictStr, Field(description="Route Aggregation Rules Id")],
        change_id: Annotated[StrictStr, Field(description="Route Aggregation Rule Change UUID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Change By ID

        This API provides capability to retrieve a specific Route Aggregation Rule's Changes

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param route_aggregation_rule_id: Route Aggregation Rules Id (required)
        :type route_aggregation_rule_id: str
        :param change_id: Route Aggregation Rule Change UUID (required)
        :type change_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_route_aggregation_rule_change_by_uuid_serialize(
            route_aggregation_id=route_aggregation_id,
            route_aggregation_rule_id=route_aggregation_rule_id,
            change_id=change_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RouteAggregationRulesChangeData",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_route_aggregation_rule_change_by_uuid_serialize(
        self,
        route_aggregation_id,
        route_aggregation_rule_id,
        change_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if route_aggregation_id is not None:
            _path_params['routeAggregationId'] = route_aggregation_id
        if route_aggregation_rule_id is not None:
            _path_params['routeAggregationRuleId'] = route_aggregation_rule_id
        if change_id is not None:
            _path_params['changeId'] = change_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/fabric/v4/routeAggregations/{routeAggregationId}/routeAggregationRules/{routeAggregationRuleId}/changes/{changeId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_route_aggregation_rule_changes(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        route_aggregation_rule_id: Annotated[StrictStr, Field(description="Route Aggregation Rules Id")],
        offset: Annotated[Optional[StrictInt], Field(description="offset")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="number of records to fetch")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RouteAggregationRulesChangeDataResponse:
        """Get All Changes

        This API provides capability to retrieve all of a Route Aggregation Rule's Changes

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param route_aggregation_rule_id: Route Aggregation Rules Id (required)
        :type route_aggregation_rule_id: str
        :param offset: offset
        :type offset: int
        :param limit: number of records to fetch
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_route_aggregation_rule_changes_serialize(
            route_aggregation_id=route_aggregation_id,
            route_aggregation_rule_id=route_aggregation_rule_id,
            offset=offset,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RouteAggregationRulesChangeDataResponse",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_route_aggregation_rule_changes_with_http_info(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        route_aggregation_rule_id: Annotated[StrictStr, Field(description="Route Aggregation Rules Id")],
        offset: Annotated[Optional[StrictInt], Field(description="offset")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="number of records to fetch")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RouteAggregationRulesChangeDataResponse]:
        """Get All Changes

        This API provides capability to retrieve all of a Route Aggregation Rule's Changes

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param route_aggregation_rule_id: Route Aggregation Rules Id (required)
        :type route_aggregation_rule_id: str
        :param offset: offset
        :type offset: int
        :param limit: number of records to fetch
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_route_aggregation_rule_changes_serialize(
            route_aggregation_id=route_aggregation_id,
            route_aggregation_rule_id=route_aggregation_rule_id,
            offset=offset,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RouteAggregationRulesChangeDataResponse",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_route_aggregation_rule_changes_without_preload_content(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        route_aggregation_rule_id: Annotated[StrictStr, Field(description="Route Aggregation Rules Id")],
        offset: Annotated[Optional[StrictInt], Field(description="offset")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="number of records to fetch")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get All Changes

        This API provides capability to retrieve all of a Route Aggregation Rule's Changes

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param route_aggregation_rule_id: Route Aggregation Rules Id (required)
        :type route_aggregation_rule_id: str
        :param offset: offset
        :type offset: int
        :param limit: number of records to fetch
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_route_aggregation_rule_changes_serialize(
            route_aggregation_id=route_aggregation_id,
            route_aggregation_rule_id=route_aggregation_rule_id,
            offset=offset,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RouteAggregationRulesChangeDataResponse",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_route_aggregation_rule_changes_serialize(
        self,
        route_aggregation_id,
        route_aggregation_rule_id,
        offset,
        limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if route_aggregation_id is not None:
            _path_params['routeAggregationId'] = route_aggregation_id
        if route_aggregation_rule_id is not None:
            _path_params['routeAggregationRuleId'] = route_aggregation_rule_id
        # process the query parameters
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/fabric/v4/routeAggregations/{routeAggregationId}/routeAggregationRules/{routeAggregationRuleId}/changes',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_route_aggregation_rules(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        offset: Annotated[Optional[StrictInt], Field(description="offset")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="number of records to fetch")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetRouteAggregationRulesResponse:
        """GetRARules

        This API provides capability to get all Route Aggregations Rules for Fabric

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param offset: offset
        :type offset: int
        :param limit: number of records to fetch
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_route_aggregation_rules_serialize(
            route_aggregation_id=route_aggregation_id,
            offset=offset,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetRouteAggregationRulesResponse",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_route_aggregation_rules_with_http_info(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        offset: Annotated[Optional[StrictInt], Field(description="offset")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="number of records to fetch")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetRouteAggregationRulesResponse]:
        """GetRARules

        This API provides capability to get all Route Aggregations Rules for Fabric

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param offset: offset
        :type offset: int
        :param limit: number of records to fetch
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_route_aggregation_rules_serialize(
            route_aggregation_id=route_aggregation_id,
            offset=offset,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetRouteAggregationRulesResponse",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_route_aggregation_rules_without_preload_content(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        offset: Annotated[Optional[StrictInt], Field(description="offset")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="number of records to fetch")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """GetRARules

        This API provides capability to get all Route Aggregations Rules for Fabric

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param offset: offset
        :type offset: int
        :param limit: number of records to fetch
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_route_aggregation_rules_serialize(
            route_aggregation_id=route_aggregation_id,
            offset=offset,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetRouteAggregationRulesResponse",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_route_aggregation_rules_serialize(
        self,
        route_aggregation_id,
        offset,
        limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if route_aggregation_id is not None:
            _path_params['routeAggregationId'] = route_aggregation_id
        # process the query parameters
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/fabric/v4/routeAggregations/{routeAggregationId}/routeAggregationRules',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def patch_route_aggregation_rule_by_uuid(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        route_aggregation_rule_id: Annotated[StrictStr, Field(description="Route Aggregation Rules Id")],
        route_aggregation_rules_patch_request_item: Annotated[List[RouteAggregationRulesPatchRequestItem], Field(min_length=1)],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RouteAggregationRulesData:
        """PatchRARule

        This API provides capability to partially update a Route Aggregation Rule

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param route_aggregation_rule_id: Route Aggregation Rules Id (required)
        :type route_aggregation_rule_id: str
        :param route_aggregation_rules_patch_request_item: (required)
        :type route_aggregation_rules_patch_request_item: List[RouteAggregationRulesPatchRequestItem]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._patch_route_aggregation_rule_by_uuid_serialize(
            route_aggregation_id=route_aggregation_id,
            route_aggregation_rule_id=route_aggregation_rule_id,
            route_aggregation_rules_patch_request_item=route_aggregation_rules_patch_request_item,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "RouteAggregationRulesData",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '415': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def patch_route_aggregation_rule_by_uuid_with_http_info(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        route_aggregation_rule_id: Annotated[StrictStr, Field(description="Route Aggregation Rules Id")],
        route_aggregation_rules_patch_request_item: Annotated[List[RouteAggregationRulesPatchRequestItem], Field(min_length=1)],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RouteAggregationRulesData]:
        """PatchRARule

        This API provides capability to partially update a Route Aggregation Rule

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param route_aggregation_rule_id: Route Aggregation Rules Id (required)
        :type route_aggregation_rule_id: str
        :param route_aggregation_rules_patch_request_item: (required)
        :type route_aggregation_rules_patch_request_item: List[RouteAggregationRulesPatchRequestItem]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._patch_route_aggregation_rule_by_uuid_serialize(
            route_aggregation_id=route_aggregation_id,
            route_aggregation_rule_id=route_aggregation_rule_id,
            route_aggregation_rules_patch_request_item=route_aggregation_rules_patch_request_item,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "RouteAggregationRulesData",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '415': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def patch_route_aggregation_rule_by_uuid_without_preload_content(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        route_aggregation_rule_id: Annotated[StrictStr, Field(description="Route Aggregation Rules Id")],
        route_aggregation_rules_patch_request_item: Annotated[List[RouteAggregationRulesPatchRequestItem], Field(min_length=1)],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """PatchRARule

        This API provides capability to partially update a Route Aggregation Rule

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param route_aggregation_rule_id: Route Aggregation Rules Id (required)
        :type route_aggregation_rule_id: str
        :param route_aggregation_rules_patch_request_item: (required)
        :type route_aggregation_rules_patch_request_item: List[RouteAggregationRulesPatchRequestItem]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._patch_route_aggregation_rule_by_uuid_serialize(
            route_aggregation_id=route_aggregation_id,
            route_aggregation_rule_id=route_aggregation_rule_id,
            route_aggregation_rules_patch_request_item=route_aggregation_rules_patch_request_item,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "RouteAggregationRulesData",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '415': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _patch_route_aggregation_rule_by_uuid_serialize(
        self,
        route_aggregation_id,
        route_aggregation_rule_id,
        route_aggregation_rules_patch_request_item,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'RouteAggregationRulesPatchRequestItem': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if route_aggregation_id is not None:
            _path_params['routeAggregationId'] = route_aggregation_id
        if route_aggregation_rule_id is not None:
            _path_params['routeAggregationRuleId'] = route_aggregation_rule_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if route_aggregation_rules_patch_request_item is not None:
            _body_params = route_aggregation_rules_patch_request_item


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/fabric/v4/routeAggregations/{routeAggregationId}/routeAggregationRules/{routeAggregationRuleId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def replace_route_aggregation_rule_by_uuid(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        route_aggregation_rule_id: Annotated[StrictStr, Field(description="Route Aggregation Rules Id")],
        route_aggregation_rules_base: RouteAggregationRulesBase,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RouteAggregationRulesData:
        """ReplaceRARule

        This API provides capability to replace a Route Aggregation Rule completely

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param route_aggregation_rule_id: Route Aggregation Rules Id (required)
        :type route_aggregation_rule_id: str
        :param route_aggregation_rules_base: (required)
        :type route_aggregation_rules_base: RouteAggregationRulesBase
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._replace_route_aggregation_rule_by_uuid_serialize(
            route_aggregation_id=route_aggregation_id,
            route_aggregation_rule_id=route_aggregation_rule_id,
            route_aggregation_rules_base=route_aggregation_rules_base,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "RouteAggregationRulesData",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '415': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def replace_route_aggregation_rule_by_uuid_with_http_info(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        route_aggregation_rule_id: Annotated[StrictStr, Field(description="Route Aggregation Rules Id")],
        route_aggregation_rules_base: RouteAggregationRulesBase,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RouteAggregationRulesData]:
        """ReplaceRARule

        This API provides capability to replace a Route Aggregation Rule completely

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param route_aggregation_rule_id: Route Aggregation Rules Id (required)
        :type route_aggregation_rule_id: str
        :param route_aggregation_rules_base: (required)
        :type route_aggregation_rules_base: RouteAggregationRulesBase
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._replace_route_aggregation_rule_by_uuid_serialize(
            route_aggregation_id=route_aggregation_id,
            route_aggregation_rule_id=route_aggregation_rule_id,
            route_aggregation_rules_base=route_aggregation_rules_base,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "RouteAggregationRulesData",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '415': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def replace_route_aggregation_rule_by_uuid_without_preload_content(
        self,
        route_aggregation_id: Annotated[StrictStr, Field(description="Route Aggregations Id")],
        route_aggregation_rule_id: Annotated[StrictStr, Field(description="Route Aggregation Rules Id")],
        route_aggregation_rules_base: RouteAggregationRulesBase,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ReplaceRARule

        This API provides capability to replace a Route Aggregation Rule completely

        :param route_aggregation_id: Route Aggregations Id (required)
        :type route_aggregation_id: str
        :param route_aggregation_rule_id: Route Aggregation Rules Id (required)
        :type route_aggregation_rule_id: str
        :param route_aggregation_rules_base: (required)
        :type route_aggregation_rules_base: RouteAggregationRulesBase
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._replace_route_aggregation_rule_by_uuid_serialize(
            route_aggregation_id=route_aggregation_id,
            route_aggregation_rule_id=route_aggregation_rule_id,
            route_aggregation_rules_base=route_aggregation_rules_base,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "RouteAggregationRulesData",
            '400': "List[Error]",
            '401': "List[Error]",
            '403': "List[Error]",
            '404': "List[Error]",
            '415': "List[Error]",
            '500': "List[Error]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _replace_route_aggregation_rule_by_uuid_serialize(
        self,
        route_aggregation_id,
        route_aggregation_rule_id,
        route_aggregation_rules_base,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if route_aggregation_id is not None:
            _path_params['routeAggregationId'] = route_aggregation_id
        if route_aggregation_rule_id is not None:
            _path_params['routeAggregationRuleId'] = route_aggregation_rule_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if route_aggregation_rules_base is not None:
            _body_params = route_aggregation_rules_base


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/fabric/v4/routeAggregations/{routeAggregationId}/routeAggregationRules/{routeAggregationRuleId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


