# coding: utf-8

"""
    Equinix Fabric API v4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.fabricv4.models.access_point_role import AccessPointRole
from equinix.services.fabricv4.models.access_point_type import AccessPointType
from equinix.services.fabricv4.models.cloud_router import CloudRouter
from equinix.services.fabricv4.models.interface import Interface
from equinix.services.fabricv4.models.metal_interconnection import MetalInterconnection
from equinix.services.fabricv4.models.peering_type import PeeringType
from equinix.services.fabricv4.models.simplified_account import SimplifiedAccount
from equinix.services.fabricv4.models.simplified_link_protocol import SimplifiedLinkProtocol
from equinix.services.fabricv4.models.simplified_location import SimplifiedLocation
from equinix.services.fabricv4.models.simplified_network import SimplifiedNetwork
from equinix.services.fabricv4.models.simplified_port import SimplifiedPort
from equinix.services.fabricv4.models.simplified_service_profile import SimplifiedServiceProfile
from equinix.services.fabricv4.models.virtual_device import VirtualDevice
from equinix.services.fabricv4.models.virtual_network import VirtualNetwork
from equinix.services.fabricv4.models.vpic_interface import VpicInterface
from typing import Optional, Set
from typing_extensions import Self

class AccessPoint(BaseModel):
    """
    Access point object
    """ # noqa: E501
    type: Optional[AccessPointType] = None
    account: Optional[SimplifiedAccount] = None
    location: Optional[SimplifiedLocation] = None
    port: Optional[SimplifiedPort] = None
    profile: Optional[SimplifiedServiceProfile] = None
    router: Optional[CloudRouter] = None
    link_protocol: Optional[SimplifiedLinkProtocol] = Field(default=None, alias="linkProtocol")
    virtual_device: Optional[VirtualDevice] = Field(default=None, alias="virtualDevice")
    interface: Optional[Interface] = None
    network: Optional[SimplifiedNetwork] = None
    seller_region: Optional[StrictStr] = Field(default=None, description="Access point seller region", alias="sellerRegion")
    peering_type: Optional[PeeringType] = Field(default=None, alias="peeringType")
    authentication_key: Optional[StrictStr] = Field(default=None, description="Access point authentication key", alias="authenticationKey")
    provider_connection_id: Optional[StrictStr] = Field(default=None, description="Provider assigned Connection Id", alias="providerConnectionId")
    virtual_network: Optional[VirtualNetwork] = Field(default=None, alias="virtualNetwork")
    interconnection: Optional[MetalInterconnection] = None
    vpic_interface: Optional[VpicInterface] = None
    role: Optional[AccessPointRole] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["type", "account", "location", "port", "profile", "router", "linkProtocol", "virtualDevice", "interface", "network", "sellerRegion", "peeringType", "authenticationKey", "providerConnectionId", "virtualNetwork", "interconnection", "vpic_interface", "role"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AccessPoint from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of port
        if self.port:
            _dict['port'] = self.port.to_dict()
        # override the default output from pydantic by calling `to_dict()` of profile
        if self.profile:
            _dict['profile'] = self.profile.to_dict()
        # override the default output from pydantic by calling `to_dict()` of router
        if self.router:
            _dict['router'] = self.router.to_dict()
        # override the default output from pydantic by calling `to_dict()` of link_protocol
        if self.link_protocol:
            _dict['linkProtocol'] = self.link_protocol.to_dict()
        # override the default output from pydantic by calling `to_dict()` of virtual_device
        if self.virtual_device:
            _dict['virtualDevice'] = self.virtual_device.to_dict()
        # override the default output from pydantic by calling `to_dict()` of interface
        if self.interface:
            _dict['interface'] = self.interface.to_dict()
        # override the default output from pydantic by calling `to_dict()` of network
        if self.network:
            _dict['network'] = self.network.to_dict()
        # override the default output from pydantic by calling `to_dict()` of virtual_network
        if self.virtual_network:
            _dict['virtualNetwork'] = self.virtual_network.to_dict()
        # override the default output from pydantic by calling `to_dict()` of interconnection
        if self.interconnection:
            _dict['interconnection'] = self.interconnection.to_dict()
        # override the default output from pydantic by calling `to_dict()` of vpic_interface
        if self.vpic_interface:
            _dict['vpic_interface'] = self.vpic_interface.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AccessPoint from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "account": SimplifiedAccount.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "location": SimplifiedLocation.from_dict(obj["location"]) if obj.get("location") is not None else None,
            "port": SimplifiedPort.from_dict(obj["port"]) if obj.get("port") is not None else None,
            "profile": SimplifiedServiceProfile.from_dict(obj["profile"]) if obj.get("profile") is not None else None,
            "router": CloudRouter.from_dict(obj["router"]) if obj.get("router") is not None else None,
            "linkProtocol": SimplifiedLinkProtocol.from_dict(obj["linkProtocol"]) if obj.get("linkProtocol") is not None else None,
            "virtualDevice": VirtualDevice.from_dict(obj["virtualDevice"]) if obj.get("virtualDevice") is not None else None,
            "interface": Interface.from_dict(obj["interface"]) if obj.get("interface") is not None else None,
            "network": SimplifiedNetwork.from_dict(obj["network"]) if obj.get("network") is not None else None,
            "sellerRegion": obj.get("sellerRegion"),
            "peeringType": obj.get("peeringType"),
            "authenticationKey": obj.get("authenticationKey"),
            "providerConnectionId": obj.get("providerConnectionId"),
            "virtualNetwork": VirtualNetwork.from_dict(obj["virtualNetwork"]) if obj.get("virtualNetwork") is not None else None,
            "interconnection": MetalInterconnection.from_dict(obj["interconnection"]) if obj.get("interconnection") is not None else None,
            "vpic_interface": VpicInterface.from_dict(obj["vpic_interface"]) if obj.get("vpic_interface") is not None else None,
            "role": obj.get("role")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


