# coding: utf-8

"""
    Equinix Fabric API v4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from equinix.services.fabricv4.models.aws_permission import AWSPermission
from equinix.services.fabricv4.models.gcp_permission import GCPPermission
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

ACTIONREQUEST_ONE_OF_SCHEMAS = ["AWSPermission", "GCPPermission"]

class ActionRequest(BaseModel):
    """
    ActionRequest
    """
    # data type: AWSPermission
    oneof_schema_1_validator: Optional[AWSPermission] = None
    # data type: GCPPermission
    oneof_schema_2_validator: Optional[GCPPermission] = None
    actual_instance: Optional[Union[AWSPermission, GCPPermission]] = None
    one_of_schemas: Set[str] = { "AWSPermission", "GCPPermission" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = ActionRequest.model_construct()
        error_messages = []
        match = 0
        # validate data type: AWSPermission
        if not isinstance(v, AWSPermission):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AWSPermission`")
        else:
            match += 1
        # validate data type: GCPPermission
        if not isinstance(v, GCPPermission):
            error_messages.append(f"Error! Input type `{type(v)}` is not `GCPPermission`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in ActionRequest with oneOf schemas: AWSPermission, GCPPermission. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in ActionRequest with oneOf schemas: AWSPermission, GCPPermission. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into AWSPermission
        try:
            instance.actual_instance = AWSPermission.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into GCPPermission
        try:
            instance.actual_instance = GCPPermission.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into ActionRequest with oneOf schemas: AWSPermission, GCPPermission. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ActionRequest with oneOf schemas: AWSPermission, GCPPermission. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], AWSPermission, GCPPermission]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


