# coding: utf-8

"""
    Equinix Fabric API v4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.fabricv4.models.alert_rule_post_request_type import AlertRulePostRequestType
from equinix.services.fabricv4.models.detection_method import DetectionMethod
from equinix.services.fabricv4.models.metric_selector import MetricSelector
from equinix.services.fabricv4.models.resource_selector import ResourceSelector
from typing import Optional, Set
from typing_extensions import Self

class AlertRulePostRequest(BaseModel):
    """
    Create Stream Alert Rules
    """ # noqa: E501
    type: Optional[AlertRulePostRequestType] = None
    name: Optional[StrictStr] = Field(default=None, description="Customer-provided stream name")
    description: Optional[StrictStr] = Field(default=None, description="Customer-provided stream description")
    enabled: Optional[StrictBool] = Field(default=True, description="Stream alert rule enabled status")
    metric_selector: Optional[MetricSelector] = Field(default=None, alias="metricSelector")
    resource_selector: Optional[ResourceSelector] = Field(default=None, alias="resourceSelector")
    detection_method: Optional[DetectionMethod] = Field(default=None, alias="detectionMethod")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["type", "name", "description", "enabled", "metricSelector", "resourceSelector", "detectionMethod"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AlertRulePostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of metric_selector
        if self.metric_selector:
            _dict['metricSelector'] = self.metric_selector.to_dict()
        # override the default output from pydantic by calling `to_dict()` of resource_selector
        if self.resource_selector:
            _dict['resourceSelector'] = self.resource_selector.to_dict()
        # override the default output from pydantic by calling `to_dict()` of detection_method
        if self.detection_method:
            _dict['detectionMethod'] = self.detection_method.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AlertRulePostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "metricSelector": MetricSelector.from_dict(obj["metricSelector"]) if obj.get("metricSelector") is not None else None,
            "resourceSelector": ResourceSelector.from_dict(obj["resourceSelector"]) if obj.get("resourceSelector") is not None else None,
            "detectionMethod": DetectionMethod.from_dict(obj["detectionMethod"]) if obj.get("detectionMethod") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


