# coding: utf-8

"""
    Equinix Fabric API v4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.fabricv4.models.bandwidth_utilization_unit import BandwidthUtilizationUnit
from equinix.services.fabricv4.models.direction import Direction
from typing import Optional, Set
from typing_extensions import Self

class BandwidthUtilization(BaseModel):
    """
    Bandwidth utilization statistics (octet counters-based)
    """ # noqa: E501
    unit: Optional[BandwidthUtilizationUnit] = None
    metric_interval: Optional[StrictStr] = Field(default=None, description="An interval formatted value, indicating the time-interval the metric objects within the response represent", alias="metricInterval")
    inbound: Optional[Direction] = None
    outbound: Optional[Direction] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["unit", "metricInterval", "inbound", "outbound"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BandwidthUtilization from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of inbound
        if self.inbound:
            _dict['inbound'] = self.inbound.to_dict()
        # override the default output from pydantic by calling `to_dict()` of outbound
        if self.outbound:
            _dict['outbound'] = self.outbound.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BandwidthUtilization from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "unit": obj.get("unit"),
            "metricInterval": obj.get("metricInterval"),
            "inbound": Direction.from_dict(obj["inbound"]) if obj.get("inbound") is not None else None,
            "outbound": Direction.from_dict(obj["outbound"]) if obj.get("outbound") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


