# coding: utf-8

"""
    Equinix Fabric API v4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.fabricv4.models.cloud_event_data import CloudEventData
from typing import Optional, Set
from typing_extensions import Self

class CloudEvent(BaseModel):
    """
    Cloud Event object
    """ # noqa: E501
    spec: Optional[StrictStr] = Field(default=None, description="Cloud Event Open Telemetry specification")
    source: Optional[StrictStr] = Field(default=None, description="Cloud Event source")
    id: Optional[StrictStr] = Field(default=None, description="Cloud Event identifier")
    type: Optional[StrictStr] = Field(default=None, description="Equinix supported event type")
    subject: Optional[StrictStr] = Field(default=None, description="Cloud Event subject")
    time: Optional[datetime] = Field(default=None, description="Cloud Event time the event occurred")
    dataschema: Optional[StrictStr] = Field(default=None, description="Cloud Event dataschema reference")
    datacontenttype: Optional[StrictStr] = Field(default=None, description="Cloud Event data content type")
    severitynumber: Optional[StrictStr] = Field(default=None, description="Cloud Event severity number")
    severitytext: Optional[StrictStr] = Field(default=None, description="Cloud Event severity text")
    equinixalert: Optional[StrictStr] = Field(default=None, description="Equinix alert")
    equinixorganization: Optional[StrictStr] = Field(default=None, description="Equinix organization identifier")
    equinixproject: Optional[StrictStr] = Field(default=None, description="Equinix project identifier")
    authtype: Optional[StrictStr] = Field(default=None, description="Cloud Event auth type")
    authid: Optional[StrictStr] = Field(default=None, description="Cloud Event user identifier")
    traceparent: Optional[StrictStr] = Field(default=None, description="Cloud Event traceparent")
    tracestate: Optional[StrictStr] = Field(default=None, description="Cloud Event tracestate")
    data: Optional[CloudEventData] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["spec", "source", "id", "type", "subject", "time", "dataschema", "datacontenttype", "severitynumber", "severitytext", "equinixalert", "equinixorganization", "equinixproject", "authtype", "authid", "traceparent", "tracestate", "data"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CloudEvent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "spec",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of data
        if self.data:
            _dict['data'] = self.data.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CloudEvent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "spec": obj.get("spec"),
            "source": obj.get("source"),
            "id": obj.get("id"),
            "type": obj.get("type"),
            "subject": obj.get("subject"),
            "time": obj.get("time"),
            "dataschema": obj.get("dataschema"),
            "datacontenttype": obj.get("datacontenttype"),
            "severitynumber": obj.get("severitynumber"),
            "severitytext": obj.get("severitytext"),
            "equinixalert": obj.get("equinixalert"),
            "equinixorganization": obj.get("equinixorganization"),
            "equinixproject": obj.get("equinixproject"),
            "authtype": obj.get("authtype"),
            "authid": obj.get("authid"),
            "traceparent": obj.get("traceparent"),
            "tracestate": obj.get("tracestate"),
            "data": CloudEventData.from_dict(obj["data"]) if obj.get("data") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


