# coding: utf-8

"""
    Equinix Fabric API v4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from equinix.services.fabricv4.models.fabric_connection import FabricConnection
from equinix.services.fabricv4.models.fabric_ipwan import FabricIPWAN
from equinix.services.fabricv4.models.fabric_ipwan_connection import FabricIPWANConnection
from equinix.services.fabricv4.models.fabric_route_protocols import FabricRouteProtocols
from equinix.services.fabricv4.models.fabric_router import FabricRouter
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

FABRICPROVIDERRESOURCE_ONE_OF_SCHEMAS = ["FabricConnection", "FabricIPWAN", "FabricIPWANConnection", "FabricRouteProtocols", "FabricRouter"]

class FabricProviderResource(BaseModel):
    """
    FabricProviderResource
    """
    # data type: FabricRouter
    oneof_schema_1_validator: Optional[FabricRouter] = None
    # data type: FabricConnection
    oneof_schema_2_validator: Optional[FabricConnection] = None
    # data type: FabricRouteProtocols
    oneof_schema_3_validator: Optional[FabricRouteProtocols] = None
    # data type: FabricIPWAN
    oneof_schema_4_validator: Optional[FabricIPWAN] = None
    # data type: FabricIPWANConnection
    oneof_schema_5_validator: Optional[FabricIPWANConnection] = None
    actual_instance: Optional[Union[FabricConnection, FabricIPWAN, FabricIPWANConnection, FabricRouteProtocols, FabricRouter]] = None
    one_of_schemas: Set[str] = { "FabricConnection", "FabricIPWAN", "FabricIPWANConnection", "FabricRouteProtocols", "FabricRouter" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = FabricProviderResource.model_construct()
        error_messages = []
        match = 0
        # validate data type: FabricRouter
        if not isinstance(v, FabricRouter):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FabricRouter`")
        else:
            match += 1
        # validate data type: FabricConnection
        if not isinstance(v, FabricConnection):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FabricConnection`")
        else:
            match += 1
        # validate data type: FabricRouteProtocols
        if not isinstance(v, FabricRouteProtocols):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FabricRouteProtocols`")
        else:
            match += 1
        # validate data type: FabricIPWAN
        if not isinstance(v, FabricIPWAN):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FabricIPWAN`")
        else:
            match += 1
        # validate data type: FabricIPWANConnection
        if not isinstance(v, FabricIPWANConnection):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FabricIPWANConnection`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in FabricProviderResource with oneOf schemas: FabricConnection, FabricIPWAN, FabricIPWANConnection, FabricRouteProtocols, FabricRouter. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in FabricProviderResource with oneOf schemas: FabricConnection, FabricIPWAN, FabricIPWANConnection, FabricRouteProtocols, FabricRouter. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into FabricRouter
        try:
            instance.actual_instance = FabricRouter.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FabricConnection
        try:
            instance.actual_instance = FabricConnection.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FabricRouteProtocols
        try:
            instance.actual_instance = FabricRouteProtocols.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FabricIPWAN
        try:
            instance.actual_instance = FabricIPWAN.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FabricIPWANConnection
        try:
            instance.actual_instance = FabricIPWANConnection.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into FabricProviderResource with oneOf schemas: FabricConnection, FabricIPWAN, FabricIPWANConnection, FabricRouteProtocols, FabricRouter. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into FabricProviderResource with oneOf schemas: FabricConnection, FabricIPWAN, FabricIPWANConnection, FabricRouteProtocols, FabricRouter. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], FabricConnection, FabricIPWAN, FabricIPWANConnection, FabricRouteProtocols, FabricRouter]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


