# coding: utf-8

"""
    Equinix Fabric API v4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from equinix.services.fabricv4.models.fabric_connection_response import FabricConnectionResponse
from equinix.services.fabricv4.models.fabric_ipwan_connection_response import FabricIPWANConnectionResponse
from equinix.services.fabricv4.models.fabric_ipwan_response import FabricIPWANResponse
from equinix.services.fabricv4.models.fabric_route_protocols_response import FabricRouteProtocolsResponse
from equinix.services.fabricv4.models.fabric_router_response import FabricRouterResponse
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

FABRICPROVIDERRESOURCERESPONSE_ONE_OF_SCHEMAS = ["FabricConnectionResponse", "FabricIPWANConnectionResponse", "FabricIPWANResponse", "FabricRouteProtocolsResponse", "FabricRouterResponse"]

class FabricProviderResourceResponse(BaseModel):
    """
    FabricProviderResourceResponse
    """
    # data type: FabricRouterResponse
    oneof_schema_1_validator: Optional[FabricRouterResponse] = None
    # data type: FabricConnectionResponse
    oneof_schema_2_validator: Optional[FabricConnectionResponse] = None
    # data type: FabricRouteProtocolsResponse
    oneof_schema_3_validator: Optional[FabricRouteProtocolsResponse] = None
    # data type: FabricIPWANResponse
    oneof_schema_4_validator: Optional[FabricIPWANResponse] = None
    # data type: FabricIPWANConnectionResponse
    oneof_schema_5_validator: Optional[FabricIPWANConnectionResponse] = None
    actual_instance: Optional[Union[FabricConnectionResponse, FabricIPWANConnectionResponse, FabricIPWANResponse, FabricRouteProtocolsResponse, FabricRouterResponse]] = None
    one_of_schemas: Set[str] = { "FabricConnectionResponse", "FabricIPWANConnectionResponse", "FabricIPWANResponse", "FabricRouteProtocolsResponse", "FabricRouterResponse" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = FabricProviderResourceResponse.model_construct()
        error_messages = []
        match = 0
        # validate data type: FabricRouterResponse
        if not isinstance(v, FabricRouterResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FabricRouterResponse`")
        else:
            match += 1
        # validate data type: FabricConnectionResponse
        if not isinstance(v, FabricConnectionResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FabricConnectionResponse`")
        else:
            match += 1
        # validate data type: FabricRouteProtocolsResponse
        if not isinstance(v, FabricRouteProtocolsResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FabricRouteProtocolsResponse`")
        else:
            match += 1
        # validate data type: FabricIPWANResponse
        if not isinstance(v, FabricIPWANResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FabricIPWANResponse`")
        else:
            match += 1
        # validate data type: FabricIPWANConnectionResponse
        if not isinstance(v, FabricIPWANConnectionResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FabricIPWANConnectionResponse`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in FabricProviderResourceResponse with oneOf schemas: FabricConnectionResponse, FabricIPWANConnectionResponse, FabricIPWANResponse, FabricRouteProtocolsResponse, FabricRouterResponse. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in FabricProviderResourceResponse with oneOf schemas: FabricConnectionResponse, FabricIPWANConnectionResponse, FabricIPWANResponse, FabricRouteProtocolsResponse, FabricRouterResponse. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into FabricRouterResponse
        try:
            instance.actual_instance = FabricRouterResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FabricConnectionResponse
        try:
            instance.actual_instance = FabricConnectionResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FabricRouteProtocolsResponse
        try:
            instance.actual_instance = FabricRouteProtocolsResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FabricIPWANResponse
        try:
            instance.actual_instance = FabricIPWANResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FabricIPWANConnectionResponse
        try:
            instance.actual_instance = FabricIPWANConnectionResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into FabricProviderResourceResponse with oneOf schemas: FabricConnectionResponse, FabricIPWANConnectionResponse, FabricIPWANResponse, FabricRouteProtocolsResponse, FabricRouterResponse. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into FabricProviderResourceResponse with oneOf schemas: FabricConnectionResponse, FabricIPWANConnectionResponse, FabricIPWANResponse, FabricRouteProtocolsResponse, FabricRouterResponse. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], FabricConnectionResponse, FabricIPWANConnectionResponse, FabricIPWANResponse, FabricRouteProtocolsResponse, FabricRouterResponse]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


