# coding: utf-8

"""
    Equinix Fabric API v4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.fabricv4.models.peering_connection_res_ipv4_auth_keys import PeeringConnectionResIpv4AuthKeys
from typing import Optional, Set
from typing_extensions import Self

class PeeringConnectionResIpv6(BaseModel):
    """
    BGP IPv6 Connection Details
    """ # noqa: E501
    customer_peer_ip: Optional[StrictStr] = Field(default=None, description="Customer peer IPv6 address", alias="customerPeerIp")
    primary_equinix_peer_ip: Optional[StrictStr] = Field(default=None, description="Primary Equinix peer IPv6 address", alias="primaryEquinixPeerIp")
    secondary_equinix_peer_ip: Optional[StrictStr] = Field(default=None, description="Secondary Equinix peer IPv6 address", alias="secondaryEquinixPeerIp")
    reverse_dns_address: Optional[StrictStr] = Field(default=None, description="Reverse DNS address for the BGP session", alias="reverseDnsAddress")
    as_set: Optional[StrictStr] = Field(default=None, description="Autonomous System Set for the BGP session", alias="asSet")
    mlpe_enabled: Optional[StrictBool] = Field(default=None, description="Whether MLPE is enabled for the BGP session", alias="mlpeEnabled")
    auth_keys: Optional[List[PeeringConnectionResIpv4AuthKeys]] = Field(default=None, alias="authKeys")
    ip_prefixes: Optional[List[StrictStr]] = Field(default=None, description="List of IP prefixes for the BGP session", alias="ipPrefixes")
    enabled: Optional[StrictBool] = Field(default=None, description="Whether BGP IPv6 is enabled")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["customerPeerIp", "primaryEquinixPeerIp", "secondaryEquinixPeerIp", "reverseDnsAddress", "asSet", "mlpeEnabled", "authKeys", "ipPrefixes", "enabled"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PeeringConnectionResIpv6 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in auth_keys (list)
        _items = []
        if self.auth_keys:
            for _item_auth_keys in self.auth_keys:
                if _item_auth_keys:
                    _items.append(_item_auth_keys.to_dict())
            _dict['authKeys'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PeeringConnectionResIpv6 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "customerPeerIp": obj.get("customerPeerIp"),
            "primaryEquinixPeerIp": obj.get("primaryEquinixPeerIp"),
            "secondaryEquinixPeerIp": obj.get("secondaryEquinixPeerIp"),
            "reverseDnsAddress": obj.get("reverseDnsAddress"),
            "asSet": obj.get("asSet"),
            "mlpeEnabled": obj.get("mlpeEnabled"),
            "authKeys": [PeeringConnectionResIpv4AuthKeys.from_dict(_item) for _item in obj["authKeys"]] if obj.get("authKeys") is not None else None,
            "ipPrefixes": obj.get("ipPrefixes"),
            "enabled": obj.get("enabled")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


