# coding: utf-8

"""
    Equinix Fabric API v4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.fabricv4.models.port_operation_operational_status import PortOperationOperationalStatus
from typing import Optional, Set
from typing_extensions import Self

class PortOperation(BaseModel):
    """
    Operational specifications for ports.
    """ # noqa: E501
    operational_status: Optional[PortOperationOperationalStatus] = Field(default=None, alias="operationalStatus")
    connection_count: Optional[StrictInt] = Field(default=None, description="Total number of connections.", alias="connectionCount")
    evpl_vc_count: Optional[StrictInt] = Field(default=None, description="Total number of connections.", alias="evplVCCount")
    fg_vc_count: Optional[StrictInt] = Field(default=None, description="Total number of connections.", alias="fgVCCount")
    access_vc_count: Optional[StrictInt] = Field(default=None, description="Total number of connections.", alias="accessVCCount")
    op_status_changed_at: Optional[datetime] = Field(default=None, description="Date and time at which port availability changed.", alias="opStatusChangedAt")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["operationalStatus", "connectionCount", "evplVCCount", "fgVCCount", "accessVCCount", "opStatusChangedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PortOperation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PortOperation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "operationalStatus": obj.get("operationalStatus"),
            "connectionCount": obj.get("connectionCount"),
            "evplVCCount": obj.get("evplVCCount"),
            "fgVCCount": obj.get("fgVCCount"),
            "accessVCCount": obj.get("accessVCCount"),
            "opStatusChangedAt": obj.get("opStatusChangedAt")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


