# coding: utf-8

"""
    Equinix Fabric API v4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.fabricv4.models.port_package_source_type import PortPackageSourceType
from equinix.services.fabricv4.models.port_package_supported_service_types_inner import PortPackageSupportedServiceTypesInner
from equinix.services.fabricv4.models.port_package_type import PortPackageType
from typing import Optional, Set
from typing_extensions import Self

class PortPackage(BaseModel):
    """
    Port Package details
    """ # noqa: E501
    href: Optional[StrictStr] = Field(default=None, description="Port Package URI")
    type: PortPackageType
    code: StrictStr = Field(description="Port Package code")
    vc_bandwidth_max: Optional[StrictInt] = Field(default=None, description="Maximum virtual connection bandwidth in Mbps", alias="vcBandwidthMax")
    vc_remote_supported: Optional[StrictBool] = Field(default=None, description="Indicates if remote virtual connections are supported", alias="vcRemoteSupported")
    supported_service_types: Optional[List[PortPackageSupportedServiceTypesInner]] = Field(default=None, description="List of supported service types", alias="supportedServiceTypes")
    supported_source_types: Optional[List[PortPackageSourceType]] = Field(default=None, description="List of supported source types", alias="supportedSourceTypes")
    supported_metros: Optional[List[StrictStr]] = Field(default=None, description="List of supported metros", alias="supportedMetros")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["href", "type", "code", "vcBandwidthMax", "vcRemoteSupported", "supportedServiceTypes", "supportedSourceTypes", "supportedMetros"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PortPackage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "href",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PortPackage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "href": obj.get("href"),
            "type": obj.get("type"),
            "code": obj.get("code"),
            "vcBandwidthMax": obj.get("vcBandwidthMax"),
            "vcRemoteSupported": obj.get("vcRemoteSupported"),
            "supportedServiceTypes": obj.get("supportedServiceTypes"),
            "supportedSourceTypes": obj.get("supportedSourceTypes"),
            "supportedMetros": obj.get("supportedMetros")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


