# coding: utf-8

"""
    Equinix Fabric API v4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from equinix.services.fabricv4.models.changelog import Changelog
from equinix.services.fabricv4.models.ipv4 import Ipv4
from equinix.services.fabricv4.models.md5 import Md5
from equinix.services.fabricv4.models.precision_time_order import PrecisionTimeOrder
from equinix.services.fabricv4.models.precision_time_package_post_response import PrecisionTimePackagePostResponse
from equinix.services.fabricv4.models.precision_time_price import PrecisionTimePrice
from equinix.services.fabricv4.models.precision_time_service_response_state import PrecisionTimeServiceResponseState
from equinix.services.fabricv4.models.precision_time_service_response_type import PrecisionTimeServiceResponseType
from equinix.services.fabricv4.models.project import Project
from equinix.services.fabricv4.models.ptp_advance_configuration import PtpAdvanceConfiguration
from equinix.services.fabricv4.models.simplified_account import SimplifiedAccount
from equinix.services.fabricv4.models.time_service_operation import TimeServiceOperation
from equinix.services.fabricv4.models.virtual_connection_time_service_response import VirtualConnectionTimeServiceResponse
from typing import Optional, Set
from typing_extensions import Self

class PrecisionTimeServiceResponse(BaseModel):
    """
    Precision Time Service Response Schema.
    """ # noqa: E501
    href: StrictStr = Field(description="Precision Time Service URI.")
    type: PrecisionTimeServiceResponseType
    name: Optional[StrictStr] = Field(default=None, description="Precision Time Service Name.")
    uuid: StrictStr = Field(description="Precision Time Service UUID.")
    state: PrecisionTimeServiceResponseState
    operation: Optional[TimeServiceOperation] = None
    package: PrecisionTimePackagePostResponse
    connections: Optional[Annotated[List[VirtualConnectionTimeServiceResponse], Field(min_length=1, max_length=2)]] = Field(default=None, description="Fabric Connections associated with Precision Time Service.")
    ipv4: Optional[Ipv4] = None
    ntp_advanced_configuration: Optional[List[Md5]] = Field(default=None, description="NTP Advanced configuration - MD5 Authentication.", alias="ntpAdvancedConfiguration")
    ptp_advanced_configuration: Optional[PtpAdvanceConfiguration] = Field(default=None, alias="ptpAdvancedConfiguration")
    project: Optional[Project] = None
    account: Optional[SimplifiedAccount] = None
    order: Optional[PrecisionTimeOrder] = None
    pricing: Optional[PrecisionTimePrice] = None
    change_log: Optional[Changelog] = Field(default=None, alias="changeLog")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["href", "type", "name", "uuid", "state", "operation", "package", "connections", "ipv4", "ntpAdvancedConfiguration", "ptpAdvancedConfiguration", "project", "account", "order", "pricing", "changeLog"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PrecisionTimeServiceResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of operation
        if self.operation:
            _dict['operation'] = self.operation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of package
        if self.package:
            _dict['package'] = self.package.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in connections (list)
        _items = []
        if self.connections:
            for _item_connections in self.connections:
                if _item_connections:
                    _items.append(_item_connections.to_dict())
            _dict['connections'] = _items
        # override the default output from pydantic by calling `to_dict()` of ipv4
        if self.ipv4:
            _dict['ipv4'] = self.ipv4.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in ntp_advanced_configuration (list)
        _items = []
        if self.ntp_advanced_configuration:
            for _item_ntp_advanced_configuration in self.ntp_advanced_configuration:
                if _item_ntp_advanced_configuration:
                    _items.append(_item_ntp_advanced_configuration.to_dict())
            _dict['ntpAdvancedConfiguration'] = _items
        # override the default output from pydantic by calling `to_dict()` of ptp_advanced_configuration
        if self.ptp_advanced_configuration:
            _dict['ptpAdvancedConfiguration'] = self.ptp_advanced_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order
        if self.order:
            _dict['order'] = self.order.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pricing
        if self.pricing:
            _dict['pricing'] = self.pricing.to_dict()
        # override the default output from pydantic by calling `to_dict()` of change_log
        if self.change_log:
            _dict['changeLog'] = self.change_log.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PrecisionTimeServiceResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "href": obj.get("href"),
            "type": obj.get("type"),
            "name": obj.get("name"),
            "uuid": obj.get("uuid"),
            "state": obj.get("state"),
            "operation": TimeServiceOperation.from_dict(obj["operation"]) if obj.get("operation") is not None else None,
            "package": PrecisionTimePackagePostResponse.from_dict(obj["package"]) if obj.get("package") is not None else None,
            "connections": [VirtualConnectionTimeServiceResponse.from_dict(_item) for _item in obj["connections"]] if obj.get("connections") is not None else None,
            "ipv4": Ipv4.from_dict(obj["ipv4"]) if obj.get("ipv4") is not None else None,
            "ntpAdvancedConfiguration": [Md5.from_dict(_item) for _item in obj["ntpAdvancedConfiguration"]] if obj.get("ntpAdvancedConfiguration") is not None else None,
            "ptpAdvancedConfiguration": PtpAdvanceConfiguration.from_dict(obj["ptpAdvancedConfiguration"]) if obj.get("ptpAdvancedConfiguration") is not None else None,
            "project": Project.from_dict(obj["project"]) if obj.get("project") is not None else None,
            "account": SimplifiedAccount.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "order": PrecisionTimeOrder.from_dict(obj["order"]) if obj.get("order") is not None else None,
            "pricing": PrecisionTimePrice.from_dict(obj["pricing"]) if obj.get("pricing") is not None else None,
            "changeLog": Changelog.from_dict(obj["changeLog"]) if obj.get("changeLog") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


