# coding: utf-8

"""
    Equinix Fabric API v4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from equinix.services.fabricv4.models.price_error_additional_info import PriceErrorAdditionalInfo
from equinix.services.fabricv4.models.price_error_error_code import PriceErrorErrorCode
from equinix.services.fabricv4.models.price_error_error_message import PriceErrorErrorMessage
from typing import Optional, Set
from typing_extensions import Self

class PriceError(BaseModel):
    """
    Error with details
    """ # noqa: E501
    error_code: PriceErrorErrorCode = Field(alias="errorCode")
    error_message: PriceErrorErrorMessage = Field(alias="errorMessage")
    correlation_id: Optional[StrictStr] = Field(default=None, alias="correlationId")
    details: Optional[StrictStr] = None
    help: Optional[StrictStr] = None
    additional_info: Optional[List[PriceErrorAdditionalInfo]] = Field(default=None, alias="additionalInfo")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["errorCode", "errorMessage", "correlationId", "details", "help", "additionalInfo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PriceError from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in additional_info (list)
        _items = []
        if self.additional_info:
            for _item_additional_info in self.additional_info:
                if _item_additional_info:
                    _items.append(_item_additional_info.to_dict())
            _dict['additionalInfo'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PriceError from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "errorCode": obj.get("errorCode"),
            "errorMessage": obj.get("errorMessage"),
            "correlationId": obj.get("correlationId"),
            "details": obj.get("details"),
            "help": obj.get("help"),
            "additionalInfo": [PriceErrorAdditionalInfo.from_dict(_item) for _item in obj["additionalInfo"]] if obj.get("additionalInfo") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


